/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.editors;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.mcmas.ui.editors.CommonOperation;
import org.mcmas.ui.editors.ExecDot;

public class FlowCanvas
extends JPanel
implements MouseListener,
MouseMotionListener {
    File flowChart;
    Hashtable<Integer, Position> positions;
    StyledText info;
    File sourceText;
    File sourceArray;
    int preferredx;
    int preferredy;
    int shiftx = 10;
    int shifty = 10;
    int minshifty = 2;
    int Width = 0;
    int Height = 0;
    int DotInch = 36;
    Panel parentPanel;
    Dimension canvasSize;
    Object[] currentNode = null;
    Object[] pressedNode = null;
    int currentIndex = -1;
    int pressedIndex = -1;
    Frame parentFrame;
    int[][] succArray;
    boolean isChangeBounds = false;
    String lowerBound1;
    String upperBound1;
    String lowerBound2;
    String upperBound2;
    static final long serialVersionUID = 0L;
    ArrayList<ArrayList<String>> alLine = new ArrayList();
    ArrayList<Integer> alLineDotted = new ArrayList();
    ArrayList<Integer> alLineNoHead = new ArrayList();
    ArrayList<Object[]> alNode = new ArrayList();
    ArrayList<ArrayList<String>> alLabel = new ArrayList();
    int[][] sourceCoords = null;

    public FlowCanvas(Frame p) {
        this.parentFrame = p;
        this.addMouseMotionListener((MouseMotionListener)this);
        this.addMouseListener((MouseListener)this);
    }

    public void setFile(File fname) {
        this.flowChart = fname;
    }

    public void setCounterExampleInfo(StyledText info, Hashtable<Integer, Position> positions) {
        this.info = info;
        this.positions = positions;
    }

    public void setPreferredWindowSize(Dimension d) {
        this.preferredx = d.width;
        this.preferredy = d.height;
    }

    public Dimension getCanvasSize() {
        return this.canvasSize;
    }

    public void setArray(int[][] sa) {
        this.succArray = sa;
    }

    public boolean readDotFile(String dotPath, int osType) {
        Pattern p = Pattern.compile(" ");
        Pattern p1 = Pattern.compile(",");
        ArrayList al = ExecDot.executeDot((String)dotPath, (String)this.flowChart.getAbsolutePath(), (int)osType);
        if (al == null) {
            return false;
        }
        int alindex = 0;
        while (alindex < al.size()) {
            String temps = (String)al.get(alindex);
            if (temps.indexOf("digraph") < 0 && temps.indexOf("node") < 0 && temps.indexOf("}") < 0) {
                int posi;
                if (temps.indexOf("graph") >= 0 && temps.indexOf("bb") >= 0) {
                    int i = temps.indexOf("\"");
                    String[] sp = p1.split(temps.substring(i + 1, temps.length() - 3));
                    this.Width = (int)Float.parseFloat(sp[2]);
                    this.Height = (int)Float.parseFloat(sp[3]);
                    this.canvasSize = new Dimension(this.Width + this.shiftx * 2, this.Height + this.shifty * 2);
                    this.shiftx = this.Width < this.preferredx ? (this.preferredx - this.shiftx) / 2 + this.shiftx : this.shiftx;
                    this.shifty = this.Height < this.preferredy ? (this.preferredy - this.shifty) / 2 + this.shifty : this.shifty;
                } else if (temps.indexOf("->") >= 0) {
                    posi = temps.indexOf("pos=\"") + 5;
                    while (posi < 5 || temps.charAt(temps.length() - 1) == '\\') {
                        temps = temps.substring(0, temps.length() - 1);
                        temps = String.valueOf(temps) + (String)al.get(++alindex);
                        posi = temps.indexOf("pos=\"") + 5;
                    }
                    int posj = temps.indexOf("\"", posi);
                    char direction = temps.charAt(posi);
                    String[] sp = null;
                    int[] x = null;
                    int[] y = null;
                    String dir = "";
                    if (direction == 'e') {
                        sp = p.split(temps.substring(posi + 2, posj));
                        x = new int[sp.length];
                        y = new int[sp.length];
                        dir = "last";
                        int i = 1;
                        while (i < sp.length) {
                            String[] sp1 = p1.split(sp[i]);
                            x[i - 1] = (int)Float.parseFloat(sp1[0]) + this.shiftx;
                            y[i - 1] = this.Height - (int)Float.parseFloat(sp1[1]) + this.shifty;
                            ++i;
                        }
                        String[] sp1 = p1.split(sp[0]);
                        x[x.length - 1] = (int)Float.parseFloat(sp1[0]) + this.shiftx;
                        y[y.length - 1] = this.Height - (int)Float.parseFloat(sp1[1]) + this.shifty;
                    } else {
                        sp = p.split(temps.substring(posi, posj));
                        x = new int[sp.length];
                        y = new int[sp.length];
                        dir = "first";
                        int i = 0;
                        while (i < sp.length) {
                            String[] sp1 = p1.split(sp[i]);
                            x[i] = (int)Float.parseFloat(sp1[0]) + this.shiftx;
                            y[i] = this.Height - (int)Float.parseFloat(sp1[1]) + this.shifty;
                            ++i;
                        }
                    }
                    ArrayList<String> alline = new ArrayList<String>(x.length * 2 + 1);
                    alline.add(dir);
                    int i = 0;
                    while (i < x.length) {
                        alline.add(Integer.toString(x[i]));
                        alline.add(Integer.toString(y[i]));
                        ++i;
                    }
                    Integer attribute = temps.indexOf("dotted") >= 0 ? new Integer(1) : new Integer(0);
                    this.alLineDotted.add(attribute);
                    Integer attribute1 = temps.indexOf("arrowhead=none") >= 0 ? new Integer(1) : new Integer(0);
                    this.alLineNoHead.add(attribute1);
                    this.alLine.add(alline);
                    posi = temps.indexOf("label=");
                    if (posi > 0) {
                        posj = temps.indexOf(",", posi += 6);
                        posi = temps.charAt(posi) == '\"' ? posi + 1 : posi;
                        posj = temps.charAt(posj - 1) == '\"' ? posj - 1 : posj;
                        String label = temps.substring(posi, posj);
                        label = label.replace(';', ',');
                        posi = temps.indexOf("lp=\"") + 4;
                        posj = temps.indexOf("\"", posi);
                        String[] sp2 = p1.split(temps.substring(posi, posj));
                        int labelx = (int)Float.parseFloat(sp2[0]) + this.shiftx;
                        int labely = this.Height - (int)Float.parseFloat(sp2[1]) + this.shifty;
                        ArrayList<String> allabel = new ArrayList<String>(3);
                        allabel.add(label);
                        allabel.add(Integer.toString(labelx));
                        allabel.add(Integer.toString(labely));
                        this.alLabel.add(allabel);
                    }
                } else {
                    int[] coordsx;
                    posi = temps.indexOf("label=") + 6;
                    int posj = temps.indexOf(",", posi);
                    posi = temps.charAt(posi) == '\"' ? posi + 1 : posi;
                    posj = temps.charAt(posj - 1) == '\"' ? posj - 1 : posj;
                    String label = temps.substring(posi, posj);
                    ArrayList<String> allabel = new ArrayList<String>(3);
                    allabel.add(label);
                    int nodeNum = Integer.parseInt(label);
                    posi = temps.indexOf("pos=\"") + 5;
                    posj = temps.indexOf("\"", posi);
                    String[] pos = p1.split(temps.substring(posi, posj));
                    int x = (int)Float.parseFloat(pos[0]) + this.shiftx;
                    int y = this.Height - (int)Float.parseFloat(pos[1]) + this.shifty;
                    allabel.add(Integer.toString(x));
                    allabel.add(Integer.toString(y));
                    this.alLabel.add(allabel);
                    posi = temps.indexOf("width=") + 6;
                    if (temps.charAt(posi) == '\"') {
                        posj = temps.indexOf("\"", ++posi);
                    } else {
                        posj = temps.indexOf(",", posi);
                        if (posj < 0) {
                            posj = temps.indexOf("]", posi);
                        }
                    }
                    float width = Float.parseFloat(temps.substring(posi, posj));
                    posi = temps.indexOf("height=") + 7;
                    if (temps.charAt(posi) == '\"') {
                        posj = temps.indexOf("\"", ++posi);
                    } else {
                        posj = temps.indexOf(",", posi);
                        if (posj < 0) {
                            posj = temps.indexOf("]", posi);
                        }
                    }
                    float height = Float.parseFloat(temps.substring(posi, posj));
                    posi = temps.indexOf("shape=") + 6;
                    posj = temps.indexOf(",", posi);
                    String shape = temps.substring(posi, posj);
                    int cx = CommonOperation.floor((float)((float)this.DotInch * width));
                    int cy = CommonOperation.floor((float)((float)this.DotInch * height));
                    Object[] alnode = new Object[3];
                    alnode[2] = new Integer(nodeNum);
                    if (shape.equals("diamond")) {
                        coordsx = new int[4];
                        int[] coordsy = new int[4];
                        coordsx[0] = x - cx;
                        coordsy[0] = y;
                        coordsx[1] = x;
                        coordsy[1] = y - cy;
                        coordsx[2] = x + cx;
                        coordsy[2] = y;
                        coordsx[3] = x;
                        coordsy[3] = y + cy;
                        alnode[0] = shape;
                        alnode[1] = new Polygon(coordsx, coordsy, 4);
                        this.alNode.add(alnode);
                    } else if (shape.equals("hexagon")) {
                        coordsx = new int[6];
                        int[] coordsy = new int[6];
                        int cx2 = CommonOperation.floor((float)((float)this.DotInch * width / 2.0f));
                        coordsx[0] = x - cx2;
                        coordsy[0] = y - cy;
                        coordsx[1] = x - cx;
                        coordsy[1] = y;
                        coordsx[2] = x - cx2;
                        coordsy[2] = y + cy;
                        coordsx[3] = x + cx2;
                        coordsy[3] = y + cy;
                        coordsx[4] = x + cx;
                        coordsy[4] = y;
                        coordsx[5] = x + cx2;
                        coordsy[5] = y - cy;
                        alnode[0] = shape;
                        alnode[1] = new Polygon(coordsx, coordsy, 6);
                        this.alNode.add(alnode);
                    } else {
                        int x1 = x - cx;
                        int y1 = y - cy;
                        int x2 = x + cx;
                        int y2 = y + cy;
                        alnode[0] = shape;
                        alnode[1] = shape.equals("box") ? new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1) : new Ellipse2D.Double(x1, y1, x2 - x1, y2 - y1);
                        this.alNode.add(alnode);
                    }
                    this.alLabel.add(allabel);
                }
            }
            ++alindex;
        }
        return true;
    }

    @Override
    public void paint(Graphics g) {
        int y1;
        int x1;
        Graphics2D g2d = (Graphics2D)g;
        super.paint(g);
        Color oldColor = g.getColor();
        int i = 0;
        while (i < this.alLine.size()) {
            int y2;
            int x2;
            ArrayList alline = (ArrayList)this.alLine.get(i);
            int attribute = (Integer)this.alLineDotted.get(i);
            int attribute1 = (Integer)this.alLineNoHead.get(i);
            if (attribute == 1) {
                g.setColor(Color.RED);
            }
            int allinesize = attribute1 == 0 ? alline.size() / 2 - 2 : alline.size() / 2 - 1;
            int j = 0;
            while (j < allinesize) {
                x1 = Integer.parseInt((String)alline.get(j * 2 + 1));
                y1 = Integer.parseInt((String)alline.get(j * 2 + 2));
                x2 = Integer.parseInt((String)alline.get(j * 2 + 3));
                y2 = Integer.parseInt((String)alline.get(j * 2 + 4));
                g.drawLine(x1, y1, x2, y2);
                ++j;
            }
            if (attribute1 == 0) {
                x1 = Integer.parseInt((String)alline.get(j * 2 + 1));
                y1 = Integer.parseInt((String)alline.get(j * 2 + 2));
                x2 = Integer.parseInt((String)alline.get(j * 2 + 3));
                y2 = Integer.parseInt((String)alline.get(j * 2 + 4));
                CommonOperation.drawArrow((Graphics)g2d, (int)x1, (int)y1, (int)x2, (int)y2, (double)9.0, (double)10.0);
            }
            if (attribute == 1) {
                g.setColor(oldColor);
            }
            ++i;
        }
        i = 0;
        while (i < this.alNode.size()) {
            Object[] alnode = (Object[])this.alNode.get(i);
            if (((String)alnode[0]).equals("box")) {
                if (this.currentIndex == i) {
                    g2d.setColor(Color.yellow);
                } else if (this.pressedIndex == i) {
                    g2d.setColor(Color.red);
                } else {
                    g2d.setColor(Color.green);
                }
                g2d.fill((Rectangle2D.Double)alnode[1]);
                g2d.setColor(Color.black);
                g2d.draw((Rectangle2D.Double)alnode[1]);
            } else if (((String)alnode[0]).equals("ellipse")) {
                if (this.currentIndex == i) {
                    g2d.setColor(Color.yellow);
                } else if (this.pressedIndex == i) {
                    g2d.setColor(Color.red);
                } else {
                    g2d.setColor(Color.orange);
                }
                g2d.fill((Ellipse2D.Double)alnode[1]);
                g2d.setColor(Color.black);
                g2d.draw((Ellipse2D.Double)alnode[1]);
            } else {
                if (this.currentIndex == i) {
                    g2d.setColor(Color.yellow);
                } else if (this.pressedIndex == i) {
                    g2d.setColor(Color.red);
                } else if (((String)alnode[0]).equals("diamond")) {
                    g2d.setColor(Color.magenta);
                } else {
                    g2d.setColor(Color.cyan);
                }
                g2d.fill((Polygon)alnode[1]);
                g2d.setColor(Color.black);
                g2d.draw((Polygon)alnode[1]);
            }
            ++i;
        }
        FontMetrics fm = g.getFontMetrics();
        g2d.setColor(Color.black);
        int i2 = 0;
        while (i2 < this.alLabel.size()) {
            ArrayList allabel = (ArrayList)this.alLabel.get(i2);
            String label = (String)allabel.get(0);
            x1 = Integer.parseInt((String)allabel.get(1)) - fm.stringWidth(label) / 2;
            y1 = Integer.parseInt((String)allabel.get(2)) + this.minshifty + 1;
            g.drawString(label, x1, y1);
            ++i2;
        }
    }

    public boolean checkSucc(int cnodeNum, int pi) {
        if (pi < 0) {
            return true;
        }
        int k = (Integer)this.pressedNode[2];
        int i = 0;
        while (i < 2) {
            if (this.succArray[k][i] == cnodeNum) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removePressed() {
        this.pressedNode = null;
        this.pressedIndex = -1;
        this.repaint();
    }

    public int getIndexFromNum(int nodenum) {
        int i = 0;
        while (i < this.alNode.size()) {
            Object[] alnode = (Object[])this.alNode.get(i);
            if ((Integer)alnode[2] == nodenum) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setPressed(int nodeNum) {
        int k = this.getIndexFromNum(nodeNum);
        this.pressedNode = (Object[])this.alNode.get(k);
        this.pressedIndex = k;
        this.repaint();
    }

    public void setChangeBounds(boolean b) {
        this.isChangeBounds = b;
    }

    public void setTimeBounds(String lb1, String ub1, String lb2, String ub2) {
        this.lowerBound1 = lb1;
        this.upperBound1 = ub1;
        this.lowerBound2 = lb2;
        this.upperBound2 = ub2;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            e.getButton();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean isInCurrentNode = false;
        if (this.currentNode != null) {
            isInCurrentNode = ((String)this.currentNode[0]).equals("box") ? ((Rectangle2D.Double)this.currentNode[1]).contains(e.getX(), e.getY()) : (((String)this.currentNode[0]).equals("ellipse") ? ((Ellipse2D.Double)this.currentNode[1]).contains(e.getX(), e.getY()) : ((Polygon)this.currentNode[1]).contains(e.getX(), e.getY()));
            if (!isInCurrentNode) {
                this.currentNode = null;
                this.currentIndex = -1;
                this.repaint();
                Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        } else {
            int i = 0;
            while (i < this.alNode.size()) {
                Object[] alnode = (Object[])this.alNode.get(i);
                if (((String)alnode[0]).equals("box")) {
                    if (((Rectangle2D.Double)alnode[1]).contains(e.getX(), e.getY())) {
                        this.currentNode = alnode;
                        this.currentIndex = i;
                        break;
                    }
                } else if (((String)alnode[0]).equals("ellipse")) {
                    if (((Ellipse2D.Double)alnode[1]).contains(e.getX(), e.getY())) {
                        this.currentNode = alnode;
                        this.currentIndex = i;
                        break;
                    }
                } else if (((Polygon)alnode[1]).contains(e.getX(), e.getY())) {
                    this.currentNode = alnode;
                    this.currentIndex = i;
                    break;
                }
                ++i;
            }
            if (this.currentNode != null) {
                this.repaint();
                Position p = (Position)this.positions.get((Integer)this.currentNode[2]);
                Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    public void cancelHighlight() {
        this.currentNode = null;
        this.currentIndex = -1;
        this.repaint();
    }

    public void setHighlight(int nodeNum) {
        int i = 0;
        while (i < this.alNode.size()) {
            Object[] alnode = (Object[])this.alNode.get(i);
            int k = (Integer)alnode[2];
            if (k == nodeNum) {
                this.currentNode = alnode;
                this.currentIndex = i;
                this.repaint();
            }
            ++i;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }
}

