/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.editors;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.mcmas.ui.editors.MCMASEditor;

public class IsplAnnotationHover
implements IAnnotationHover {
    private MCMASEditor editor;

    public String getHoverInfo(ISourceViewer aViewer, int aLine) {
        String info = null;
        IMarker[] marker = this.getMarkerForLine(aViewer, aLine);
        if (marker != null) {
            int i = 0;
            while (i < marker.length) {
                String message = marker[i].getAttribute("message", null);
                if (message != null && message.trim().length() > 0) {
                    info = info == null ? message.trim() : String.valueOf(info) + "\n" + message.trim();
                }
                ++i;
            }
        }
        return info;
    }

    protected IMarker[] getMarkerForLine(ISourceViewer aViewer, int aLine) {
        IAnnotationModel model = aViewer.getAnnotationModel();
        if (model != null) {
            ArrayList<IMarker> markerList = new ArrayList<IMarker>();
            Iterator e = model.getAnnotationIterator();
            while (e.hasNext()) {
                MarkerAnnotation a;
                IMarker marker;
                int line;
                Object o = e.next();
                if (!(o instanceof MarkerAnnotation) || (line = (marker = (a = (MarkerAnnotation)o).getMarker()).getAttribute("lineNumber", 0)) != aLine + 1) continue;
                markerList.add(marker);
            }
            if (markerList.size() > 0) {
                IMarker[] markers = new IMarker[markerList.size()];
                markerList.toArray(markers);
                return markers;
            }
        }
        if (this.editor.annotationModel != null) {
            Iterator e = this.editor.annotationModel.getAnnotationIterator();
            while (e.hasNext()) {
                Object o = e.next();
                if (!(o instanceof ProjectionAnnotation)) continue;
                ProjectionAnnotation a = (ProjectionAnnotation)o;
                Position p = this.editor.annotationModel.getPosition((Annotation)a);
                IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
                try {
                    int startLine = document.getLineOfOffset(p.offset);
                    if (startLine != aLine) continue;
                    ArrayList<IMarker> markerlist = new ArrayList<IMarker>();
                    if (model != null) {
                        Iterator e1 = model.getAnnotationIterator();
                        while (e1.hasNext()) {
                            Object o1 = e1.next();
                            if (!(o1 instanceof MarkerAnnotation)) continue;
                            MarkerAnnotation a1 = (MarkerAnnotation)o1;
                            Position p1 = model.getPosition((Annotation)a1);
                            if (p1.offset < p.offset || p1.offset + p1.length > p.offset + p.length) continue;
                            IMarker marker = a1.getMarker();
                            markerlist.add(marker);
                        }
                    }
                    if (markerlist.size() <= 0) continue;
                    IMarker[] markers = new IMarker[markerlist.size()];
                    markerlist.toArray(markers);
                    return markers;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public void setMCMASEditor(MCMASEditor editor) {
        this.editor = editor;
    }
}

