/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.mcmas.ui.syntax.Util;

public class IsplAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private final String[] key2 = new String[]{"Actions", "Lobsvars", "Obsvars", "Vars", "RedStates", "Protocol", "Evolution", "Evaluation", "InitStates", "Groups", "Fairness", "Formulae"};

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.length == 0 && c.text != null && this.endsWithDelimiter(d, c.text)) {
            this.smartIndentAfterNewLine(d, c);
        } else if ("}".equals(c.text)) {
            this.smartInsertAfterBracket(d, c);
        }
    }

    private boolean endsWithDelimiter(IDocument d, String txt) {
        String[] delimiters = d.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.endsWith((String[])delimiters, (String)txt) > -1;
        }
        return false;
    }

    protected int findMatchingOpenBracket(IDocument document, int line, int end, int closingBracketIncrease) throws BadLocationException {
        int start = document.getLineOffset(line);
        int brackcount = this.getBracketCount(document, start, end, false) - closingBracketIncrease;
        while (brackcount < 0) {
            if (--line < 0) {
                return -1;
            }
            start = document.getLineOffset(line);
            end = start + document.getLineLength(line) - 1;
            brackcount += this.getBracketCount(document, start, end, false);
        }
        return line;
    }

    private int getBracketCount(IDocument document, int start, int end, boolean ignoreCloseBrackets) throws BadLocationException {
        int begin = start;
        int bracketcount = 0;
        block7: while (begin < end) {
            char curr = document.getChar(begin);
            ++begin;
            switch (curr) {
                case '/': {
                    if (begin >= end) break;
                    char next = document.getChar(begin);
                    if (next == '*') {
                        begin = this.getCommentEnd(document, begin + 1, end);
                        break;
                    }
                    if (next != '/') break;
                    begin = end;
                    break;
                }
                case '*': {
                    char next;
                    if (begin >= end || (next = document.getChar(begin)) != '/') continue block7;
                    bracketcount = 0;
                    ++begin;
                    break;
                }
                case '{': {
                    ++bracketcount;
                    ignoreCloseBrackets = false;
                    break;
                }
                case '}': {
                    if (ignoreCloseBrackets) break;
                    --bracketcount;
                    break;
                }
                case '\"': 
                case '\'': {
                    begin = this.getStringEnd(document, begin, end, curr);
                }
            }
        }
        return bracketcount;
    }

    private int getCommentEnd(IDocument document, int position, int end) throws BadLocationException {
        int currentPosition = position;
        while (currentPosition < end) {
            char curr = document.getChar(currentPosition);
            if (curr != '*' || ++currentPosition >= end || document.getChar(currentPosition) != '/') continue;
            return currentPosition + 1;
        }
        return end;
    }

    protected String getIndentOfLine(IDocument document, int line) throws BadLocationException {
        if (line > -1) {
            int start = document.getLineOffset(line);
            int end = start + document.getLineLength(line) - 1;
            int whiteend = this.findEndOfWhiteSpace(document, start, end);
            return document.get(start, whiteend - start);
        }
        return "";
    }

    private int getStringEnd(IDocument document, int position, int end, char character) throws BadLocationException {
        int currentPosition = position;
        while (currentPosition < end) {
            char currentCharacter = document.getChar(currentPosition);
            ++currentPosition;
            if (currentCharacter == '\\') {
                ++currentPosition;
                continue;
            }
            if (currentCharacter != character) continue;
            return currentPosition;
        }
        return end;
    }

    protected void smartIndentAfterNewLine(IDocument document, DocumentCommand command) {
        int docLength = document.getLength();
        if (command.offset == -1 || docLength == 0) {
            return;
        }
        try {
            int p = command.offset == docLength ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            StringBuffer buf = new StringBuffer(command.text);
            if (command.offset < docLength && document.getChar(command.offset) == '}') {
                int indLine = this.findMatchingOpenBracket(document, line, command.offset, 0);
                if (indLine == -1) {
                    indLine = line;
                }
                buf.append(this.getIndentOfLine(document, indLine));
            } else {
                boolean isdefault = true;
                int nonspace = Util.getOffsetBackward((IDocument)document, (int)p);
                if (nonspace >= 0) {
                    char c = document.getChar(nonspace);
                    if (c == ';') {
                        boolean flag = false;
                        Position pos2 = null;
                        do {
                            flag = false;
                            pos2 = Util.searchMatchedWord((IDocument)document, (String[])this.key2, (int)(nonspace - 1));
                            if (document.get(pos2.offset, pos2.length).compareTo("RedStates") != 0 || (nonspace = Util.getDotOffset((IDocument)document, (int)pos2.offset)) <= -1) continue;
                            flag = true;
                        } while (flag);
                        if (pos2.length > 0) {
                            int line1 = document.getLineOfOffset(pos2.offset);
                            int start = document.getLineOffset(line1);
                            int whiteend = this.findEndOfWhiteSpace(document, start, pos2.offset);
                            String sss = document.get(pos2.offset, pos2.length);
                            if (sss.compareTo("Actions") != 0 && sss.compareTo("RedStates") != 0 && sss.compareTo("InitStates") != 0) {
                                int start1;
                                int length = document.getLineLength(line);
                                String rest = document.get(p, length - (p - (start1 = document.getLineOffset(line))));
                                if (!Util.isNonWhitespace((String)rest)) {
                                    buf.append(document.get(start, whiteend - start));
                                    buf.append('\t');
                                } else {
                                    whiteend = this.findEndOfWhiteSpace(document, start1, p);
                                    buf.append(document.get(start1, whiteend - start1));
                                }
                            }
                            isdefault = false;
                        }
                    } else if (c == ':') {
                        String str;
                        Position pos = Util.getWordPositionBackward((IDocument)document, (int)nonspace);
                        if (pos.length > 0 && ((str = document.get(pos.offset, pos.length)).compareTo("Obsvars") == 0 || str.compareTo("Vars") == 0 || str.compareTo("RedStates") == 0 || str.compareTo("Protocol") == 0 || str.compareTo("Evolution") == 0)) {
                            int line1 = document.getLineOfOffset(pos.offset);
                            int start = document.getLineOffset(line1);
                            int whiteend = this.findEndOfWhiteSpace(document, start, pos.offset);
                            buf.append(document.get(start, whiteend - start));
                            buf.append('\t');
                            isdefault = false;
                        }
                    } else {
                        String str;
                        Position pos = Util.getCurrentWord((IDocument)document, (int)nonspace);
                        if (pos.length > 0 && ((str = document.get(pos.offset, pos.length)).compareTo("Obsvars") == 0 || str.compareTo("Vars") == 0 || str.compareTo("RedStates") == 0 || str.compareTo("Protocol") == 0 || str.compareTo("Evolution") == 0 || str.compareTo("Agent") == 0 || str.compareTo("Evaluation") == 0 || str.compareTo("InitStates") == 0 || str.compareTo("Groups") == 0 || str.compareTo("Fairness") == 0 || str.compareTo("Formulae") == 0)) {
                            Position pos1 = Util.getWordPositionBackward((IDocument)document, (int)(pos.offset - 1));
                            if (pos1.length > 0) {
                                String str1 = document.get(pos1.offset, pos1.length);
                                if (str1.compareTo("end") == 0) {
                                    Position pos2 = Util.searchMatchedWord((IDocument)document, (String)str, (int)(pos1.offset - 1));
                                    if (pos2.length > 0) {
                                        int line1 = document.getLineOfOffset(pos2.offset);
                                        int start = document.getLineOffset(line1);
                                        int whiteend = this.findEndOfWhiteSpace(document, start, pos2.offset);
                                        if (str.compareTo("Evolution") != 0) {
                                            buf.append(document.get(start, whiteend - start));
                                        }
                                        isdefault = false;
                                    }
                                } else {
                                    int line1 = document.getLineOfOffset(pos.offset);
                                    int start = document.getLineOffset(line1);
                                    int whiteend = this.findEndOfWhiteSpace(document, start, pos.offset);
                                    buf.append(document.get(start, whiteend - start));
                                    buf.append('\t');
                                    isdefault = false;
                                }
                            }
                        }
                    }
                }
                if (isdefault) {
                    int start = document.getLineOffset(line);
                    int whiteend = this.findEndOfWhiteSpace(document, start, command.offset);
                    buf.append(document.get(start, whiteend - start));
                    if (this.getBracketCount(document, start, command.offset, true) > 0) {
                        buf.append('\t');
                    }
                }
            }
            command.text = buf.toString();
        }
        catch (BadLocationException excp) {
            System.out.println("AutoIndent.error.bad_location_1");
        }
    }

    protected void smartInsertAfterBracket(IDocument document, DocumentCommand command) {
        if (command.offset == -1 || document.getLength() == 0) {
            return;
        }
        try {
            int indLine;
            int p = command.offset == document.getLength() ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            int start = document.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(document, start, command.offset);
            if (whiteend == command.offset && (indLine = this.findMatchingOpenBracket(document, line, command.offset, 1)) != -1 && indLine != line) {
                StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(document, indLine));
                replaceText.append(document.get(whiteend, command.offset - whiteend));
                replaceText.append(command.text);
                command.length = command.offset - start;
                command.offset = start;
                command.text = replaceText.toString();
            }
        }
        catch (BadLocationException excp) {
            System.out.println("AutoIndent.error.bad_location_2");
        }
    }
}

