/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.editors;

import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.mcmas.ui.editors.IsplColorProvider;
import org.mcmas.ui.editors.IsplWhitespaceDetector;
import org.mcmas.ui.editors.IsplWordDetector;

public class IsplCodeScanner
extends RuleBasedScanner {
    private static String[] fgKeywords = new String[]{"Action", "Actions", "Agent", "end", "Environment", "Evaluation", "Evolution", "Fairness", "Formulae", "Groups", "InitStates", "Lobsvars", "Obsvars", "Protocol", "RedStates", "Vars", "Other", "if", "GreenStates", "Semantics", "MultiAssignment", "SingleAssignment", "MA", "SA"};
    private static String[] fgOperators = new String[]{"and", "or", "AG", "EG", "AX", "EX", "X", "F", "G", "AF", "EF", "A", "E", "U", "K", "GK", "GCK", "O", "DK"};
    private static String[] fgTypes = new String[]{"boolean"};
    private static String[] fgConstants = new String[]{"false", "true"};

    public IsplCodeScanner(IsplColorProvider provider) {
        Token keyword = new Token((Object)new TextAttribute(provider.getColor(IsplColorProvider.KEYWORD)));
        Token operator = new Token((Object)new TextAttribute(provider.getColor(IsplColorProvider.OPERATOR)));
        Token type = new Token((Object)new TextAttribute(provider.getColor(IsplColorProvider.TYPE)));
        Token comment = new Token((Object)new TextAttribute(provider.getColor(IsplColorProvider.SINGLE_LINE_COMMENT)));
        Token other = new Token((Object)new TextAttribute(provider.getColor(IsplColorProvider.DEFAULT)));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("--", (IToken)comment));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new IsplWhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new IsplWordDetector(), (IToken)other);
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < fgTypes.length) {
            wordRule.addWord(fgTypes[i], (IToken)type);
            ++i;
        }
        i = 0;
        while (i < fgConstants.length) {
            wordRule.addWord(fgConstants[i], (IToken)type);
            ++i;
        }
        i = 0;
        while (i < fgOperators.length) {
            wordRule.addWord(fgOperators[i], (IToken)operator);
            ++i;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

