/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.editors;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.rules.IToken;
import org.mcmas.ui.editors.IsplCompletionProcessor;
import org.mcmas.ui.editors.IsplWordScanner;
import org.mcmas.ui.editors.MCMASEditor;
import org.mcmas.ui.editors.MCMASEditorMessages;
import org.mcmas.ui.editors.Segment;
import org.mcmas.ui.syntax.Util;

public class IsplCompletionProcessor
implements IContentAssistProcessor {
    MCMASEditor editor;
    protected static final String[] fgProposals = new String[]{"Action", "Actions", "Agent", "end", "Environment", "Evaluation", "Evolution", "Fairness", "Formulae", "Groups", "InitStates", "Obsvars", "Protocol", "RedStates", "Vars", "Other", "if", "and", "or", "AG", "EG", "AX", "EX", "X", "F", "G", "AF", "EF", "A", "E", "U", "K", "GK", "GCK", "O", "DK", "boolean", "false", "true", "Lobsvars", "Semantics", "MultiAssignment", "SingleAssignment", "MA", "SA"};
    protected IContextInformationValidator fValidator = new Validator();

    public IsplCompletionProcessor(MCMASEditor editor) {
        this.editor = editor;
    }

    private CompletionProposal generateProposal(String str, String displaystr, int documentOffset) {
        ContextInformation info = new ContextInformation(str, MessageFormat.format(MCMASEditorMessages.getString((String)"CompletionProcessor.Proposal.ContextInfo.pattern"), str));
        return new CompletionProposal(str, documentOffset, 0, str.length(), null, displaystr, (IContextInformation)info, MessageFormat.format(MCMASEditorMessages.getString((String)"CompletionProcessor.Proposal.hoverinfo.pattern"), str));
    }

    private String[] getActions(IDocument document, Segment agent) {
        String[] result = null;
        ArrayList<String> actionList = new ArrayList<String>();
        if (agent.children != null) {
            int i = 0;
            while (i < agent.children.size()) {
                Segment actions = (Segment)agent.children.get(i);
                if (actions.name.compareTo("Actions") == 0) {
                    try {
                        String str = document.get(actions.position.offset, actions.position.length);
                        int openBracket = str.indexOf(123);
                        if (openBracket < 0) {
                            openBracket = str.indexOf("=");
                        }
                        if (openBracket > 0) {
                            IsplWordScanner scanner = new IsplWordScanner();
                            scanner.setRange(document, actions.position.offset + openBracket + 1, str.length() - openBracket - 1);
                            IToken t = scanner.nextToken();
                            while (!t.isEOF()) {
                                if (t.isOther() && t.getData() != null && t.getData().toString().compareTo("__ispl_word") == 0) {
                                    actionList.add(document.get(scanner.getTokenOffset(), scanner.getTokenLength()));
                                }
                                t = scanner.nextToken();
                            }
                            if (actionList.size() > 0) {
                                result = new String[actionList.size()];
                                actionList.toArray(result);
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        block39: {
            Segment[] path;
            IDocument document;
            ArrayList<CompletionProposal> proposals;
            ICompletionProposal[] result;
            block38: {
                result = null;
                proposals = new ArrayList<CompletionProposal>();
                document = viewer.getDocument();
                path = this.editor.getTreePath(documentOffset);
                if (path != null && (path == null || path[0].name.compareTo("Semantics") != 0)) break block38;
                int eqOffset = Util.getEqOffset((IDocument)document, (int)documentOffset);
                if (eqOffset > -1) {
                    Position p = Util.getWordPositionBackward((IDocument)document, (int)eqOffset);
                    String str = document.get(p.offset, p.length);
                    if (str.compareTo("Semantics") == 0) {
                        Position pos2 = null;
                        if (p.offset > 0) {
                            pos2 = Util.searchMatchedWord((IDocument)document, (String)str, (int)(p.offset - 1));
                        }
                        if (pos2 == null || pos2.length == 0) {
                            result = new ICompletionProposal[]{this.generateProposal("MultiAssignment", "MultiAssignment", documentOffset), this.generateProposal("SingleAssignment", "SingleAssignment", documentOffset)};
                            return result;
                        }
                    }
                }
                return null;
            }
            try {
                boolean isInAgent = path[0].name.startsWith("Agent");
                int dotOffset = Util.getDotOffset((IDocument)document, (int)documentOffset);
                if (dotOffset > -1) {
                    Position p = Util.getWordPositionBackward((IDocument)document, (int)documentOffset);
                    String str = document.get(p.offset, p.length);
                    Segment seg = this.editor.getAgentSegmentbyName(str);
                    if (seg == null) break block39;
                    if (isInAgent) {
                        proposals.add(this.generateProposal("Action", "Action", documentOffset));
                        if (str.compareTo("Environment") == 0 && seg.children != null) {
                            int i = 0;
                            while (i < seg.children.size()) {
                                Segment obsvars = (Segment)seg.children.get(i);
                                if (obsvars.name.compareTo("Obsvars") == 0) {
                                    if (obsvars.children == null) break;
                                    int j = 0;
                                    while (j < obsvars.children.size()) {
                                        Segment variable2 = (Segment)obsvars.children.get(j);
                                        int spaceOffset = variable2.name.indexOf(32);
                                        if (spaceOffset > 0) {
                                            String varName = variable2.name.substring(0, spaceOffset);
                                            proposals.add(this.generateProposal(varName, variable2.name, documentOffset));
                                        }
                                        ++j;
                                    }
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (path[0].children != null) {
                            Segment lobsvars = (Segment)path[0].children.get(0);
                            if (lobsvars.name.compareTo("Lobsvars") == 0) {
                                String lobsvarstr = document.get(lobsvars.position.offset, lobsvars.position.length);
                                int lb = lobsvarstr.indexOf(123);
                                int rb = lobsvarstr.indexOf(125);
                                if (lb > 0 && rb > 0) {
                                    lobsvarstr = lobsvarstr.substring(lb + 1, rb);
                                    String[] lvs = (lobsvarstr = lobsvarstr.replaceAll(" ", "")).split(",");
                                    if (lvs.length > 0 && str.compareTo("Environment") == 0 && seg.children != null) {
                                        int i = 0;
                                        while (i < seg.children.size()) {
                                            Segment vars = (Segment)seg.children.get(i);
                                            if (vars.name.compareTo("Vars") == 0) {
                                                if (vars.children == null) break;
                                                int j = 0;
                                                while (j < vars.children.size()) {
                                                    Segment variable3 = (Segment)vars.children.get(j);
                                                    int spaceOffset = variable3.name.indexOf(32);
                                                    if (spaceOffset > 0) {
                                                        String varName = variable3.name.substring(0, spaceOffset);
                                                        int k = 0;
                                                        while (k < lvs.length) {
                                                            if (varName.compareTo(lvs[k]) == 0) {
                                                                proposals.add(this.generateProposal(varName, variable3.name, documentOffset));
                                                                break;
                                                            }
                                                            ++k;
                                                        }
                                                    }
                                                    ++j;
                                                }
                                                break;
                                            }
                                            ++i;
                                        }
                                    }
                                }
                            }
                        }
                        result = new ICompletionProposal[proposals.size()];
                        proposals.toArray(result);
                        return result;
                    }
                    if (seg.children != null) {
                        int i = 0;
                        while (i < seg.children.size()) {
                            Segment obsvars = (Segment)seg.children.get(i);
                            if ((obsvars.name.compareTo("Obsvars") == 0 && str.compareTo("Environment") == 0 || obsvars.name.compareTo("Vars") == 0) && obsvars.children != null) {
                                int j = 0;
                                while (j < obsvars.children.size()) {
                                    Segment variable4 = (Segment)obsvars.children.get(j);
                                    int spaceOffset = variable4.name.indexOf(32);
                                    if (spaceOffset > 0) {
                                        String varName = variable4.name.substring(0, spaceOffset);
                                        proposals.add(this.generateProposal(varName, variable4.name, documentOffset));
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                    }
                    if (proposals.size() > 0) {
                        result = new ICompletionProposal[proposals.size()];
                        proposals.toArray(result);
                        return result;
                    }
                    break block39;
                }
                int eqOffset = Util.getEqOffset((IDocument)document, (int)documentOffset);
                if (eqOffset > -1) {
                    Position p = Util.getWordPositionBackward((IDocument)document, (int)eqOffset);
                    String str = document.get(p.offset, p.length);
                    if (str.compareTo("Action") == 0) {
                        String[] actionList;
                        dotOffset = Util.getDotOffset((IDocument)document, (int)p.offset);
                        if (dotOffset > -1) {
                            String[] actionList2;
                            p = Util.getWordPositionBackward((IDocument)document, (int)p.offset);
                            str = document.get(p.offset, p.length);
                            Segment seg = this.editor.getAgentSegmentbyName(str);
                            if (seg != null && (actionList2 = this.getActions(document, seg)) != null) {
                                int j = 0;
                                while (j < actionList2.length) {
                                    proposals.add(this.generateProposal(actionList2[j], actionList2[j], documentOffset));
                                    ++j;
                                }
                                result = new ICompletionProposal[proposals.size()];
                                proposals.toArray(result);
                                return result;
                            }
                        } else if (isInAgent && (actionList = this.getActions(document, path[0])) != null) {
                            int j = 0;
                            while (j < actionList.length) {
                                proposals.add(this.generateProposal(actionList[j], actionList[j], documentOffset));
                                ++j;
                            }
                            result = new ICompletionProposal[proposals.size()];
                            proposals.toArray(result);
                            return result;
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        IContextInformation[] result = new IContextInformation[5];
        int i = 0;
        while (i < result.length) {
            result[i] = new ContextInformation(MessageFormat.format(MCMASEditorMessages.getString((String)"CompletionProcessor.ContextInfo.display.pattern"), new Integer(i), new Integer(documentOffset)), MessageFormat.format(MCMASEditorMessages.getString((String)"CompletionProcessor.ContextInfo.value.pattern"), new Integer(i), new Integer(documentOffset - 5), new Integer(documentOffset + 5)));
            ++i;
        }
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.', '='};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{'#'};
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public String getErrorMessage() {
        return null;
    }
}

