/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.editors;

import java.util.ArrayList;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.mcmas.ui.editors.IsplAgentScanner;
import org.mcmas.ui.editors.IsplContentOutlinePage;
import org.mcmas.ui.editors.IsplGroupScanner;
import org.mcmas.ui.editors.IsplItemScanner;
import org.mcmas.ui.editors.IsplPartitionScanner;
import org.mcmas.ui.editors.IsplStateScanner;
import org.mcmas.ui.editors.IsplWordScanner;
import org.mcmas.ui.editors.MCMASEditor;
import org.mcmas.ui.editors.Segment;

public class IsplContentOutlinePage
extends ContentOutlinePage {
    protected static IsplPartitionScanner scanner;
    protected static IsplAgentScanner AgentScanner;
    protected static IsplWordScanner WordScanner;
    protected static IsplStateScanner StateScanner;
    protected static IsplGroupScanner GroupScanner;
    protected static IsplItemScanner ItemScanner;
    protected static FindReplaceDocumentAdapter adapter;
    protected ISelection previous;
    protected boolean moveCursor = true;
    protected ContentProvider contentprovider;
    protected MCMASEditor editor;
    ISelectionChangedListener editorListener = new /* Unavailable Anonymous Inner Class!! */;
    protected Object fInput;
    protected IDocumentProvider fDocumentProvider;
    protected ITextEditor fTextEditor;

    public ISelectionChangedListener getISelectionChangedListener() {
        return this.editorListener;
    }

    public IsplContentOutlinePage(IDocumentProvider provider, ITextEditor editor) {
        this.fDocumentProvider = provider;
        this.fTextEditor = editor;
        if (scanner == null) {
            scanner = new IsplPartitionScanner();
        }
        if (AgentScanner == null) {
            AgentScanner = new IsplAgentScanner();
        }
        if (WordScanner == null) {
            WordScanner = new IsplWordScanner();
        }
        if (StateScanner == null) {
            StateScanner = new IsplStateScanner();
        }
        if (GroupScanner == null) {
            GroupScanner = new IsplGroupScanner();
        }
        if (ItemScanner == null) {
            ItemScanner = new IsplItemScanner();
        }
    }

    public IsplPartitionScanner getIsplPartitionScanner() {
        return scanner;
    }

    public IsplAgentScanner getIsplAgentScanner() {
        return AgentScanner;
    }

    public IsplWordScanner getIsplWordScanner() {
        return WordScanner;
    }

    public IsplStateScanner getIsplStateScanner() {
        return StateScanner;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        this.contentprovider = new ContentProvider(this);
        viewer.setContentProvider((IContentProvider)this.contentprovider);
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.fInput != null) {
            viewer.setInput(this.fInput);
            viewer.expandAll();
            if (this.fTextEditor instanceof MCMASEditor) {
                ((MCMASEditor)this.fTextEditor).updateFoldingStructure();
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (!this.moveCursor) {
            this.moveCursor = true;
            return;
        }
        if (selection.isEmpty()) {
            this.fTextEditor.resetHighlightRange();
        } else {
            Segment segment = (Segment)((IStructuredSelection)selection).getFirstElement();
            int start = segment.position.getOffset();
            int length = segment.position.getLength();
            try {
                this.fTextEditor.setHighlightRange(start, length, true);
            }
            catch (IllegalArgumentException x) {
                this.fTextEditor.resetHighlightRange();
            }
        }
    }

    public void setInput(Object input) {
        this.fInput = input;
        this.update();
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput(this.fInput);
            viewer.expandAll();
            control.setRedraw(true);
        }
    }

    public void setSelectedItem(int offset) {
        Object[] paths = this.contentprovider.getSelectedSegment(offset);
        if (paths != null) {
            this.moveCursor = false;
            this.setSelection((ISelection)new TreeSelection(new TreePath(paths)));
        }
    }

    public Segment[] getTreePath(int offset) {
        return this.contentprovider.getSelectedSegment(offset);
    }

    public ArrayList<Position> getProjectionPositions() {
        return this.contentprovider.getProjectionPositions();
    }

    public Segment getSegmentbyName(String name) {
        return this.contentprovider.getSegmentbyName(name);
    }

    public Segment getAgentSegmentbyName(String name) {
        return this.contentprovider.getAgentSegmentbyName(name);
    }

    static /* synthetic */ TreeViewer access$0(IsplContentOutlinePage isplContentOutlinePage) {
        return isplContentOutlinePage.getTreeViewer();
    }
}

