/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.editors;

import java.util.LinkedList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.rules.IToken;
import org.mcmas.ui.editors.IsplWordScanner;
import org.mcmas.ui.syntax.Util;

public class IsplFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private int indent = 0;

    public IsplFormattingStrategy() {
    }

    public IsplFormattingStrategy(int indent) {
        this.indent = indent;
    }

    public void format() {
        super.format();
        IDocument document = (IDocument)this.fDocuments.removeFirst();
        if (document != null) {
            String newcontent = this.format(document);
            document.set(newcontent);
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fDocuments.clear();
    }

    private String format(IDocument document) {
        StringBuffer newcontent = new StringBuffer("");
        String delimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        IsplWordScanner WordScanner = new IsplWordScanner();
        try {
            int lines = document.getNumberOfLines();
            boolean pendingend = false;
            boolean expectColumn = false;
            boolean expectID = false;
            boolean linebreak = true;
            int i = 0;
            while (i < lines) {
                int offset = document.getLineOffset(i);
                int length = document.getLineLength(i);
                String strLine = document.get(offset, length);
                if (!Util.isEmpty((String)(strLine = strLine.trim()))) {
                    if (strLine.startsWith("--")) {
                        newcontent.append(String.valueOf(this.indentstr()) + strLine + delimiter);
                    } else {
                        int whiteend = Util.findEndOfWhiteSpace((IDocument)document, (int)offset, (int)(offset + length));
                        WordScanner.setRange(document, whiteend, strLine.length());
                        boolean isFirstToken = true;
                        IToken t = WordScanner.nextToken();
                        while (!t.isEOF()) {
                            String strToken;
                            if (t.isUndefined()) {
                                strToken = document.get(WordScanner.getTokenOffset(), WordScanner.getTokenLength());
                                if (isFirstToken) {
                                    newcontent.append(this.indentstr());
                                    isFirstToken = false;
                                }
                                newcontent.append(strToken);
                            } else if (t.isWhitespace()) {
                                if (isFirstToken) {
                                    newcontent.append(this.indentstr());
                                    isFirstToken = false;
                                } else {
                                    newcontent.append(' ');
                                }
                            } else if (t.isOther()) {
                                if (t.getData() != null) {
                                    String strType = t.getData().toString();
                                    if (pendingend) {
                                        boolean addspace;
                                        pendingend = false;
                                        boolean bl = addspace = !Character.isWhitespace(newcontent.charAt(newcontent.length() - 1));
                                        if (strType.compareTo("__ispl_agent") == 0) {
                                            if (addspace) {
                                                newcontent.append(' ');
                                            }
                                            newcontent.append("Agent\n\n");
                                            isFirstToken = true;
                                            linebreak = false;
                                        } else if (strType.compareTo("__ispl_obsvars") == 0) {
                                            if (addspace) {
                                                newcontent.append(' ');
                                            }
                                            newcontent.append("Obsvars\n");
                                            isFirstToken = true;
                                            linebreak = false;
                                        } else if (strType.compareTo("__ispl_vars") == 0) {
                                            if (addspace) {
                                                newcontent.append(' ');
                                            }
                                            newcontent.append("Vars\n");
                                            isFirstToken = true;
                                            linebreak = false;
                                        } else if (strType.compareTo("__ispl_RedStates") == 0) {
                                            if (addspace) {
                                                newcontent.append(' ');
                                            }
                                            newcontent.append("RedStates\n");
                                            isFirstToken = true;
                                            linebreak = false;
                                        } else if (strType.compareTo("__ispl_protocol") == 0) {
                                            if (addspace) {
                                                newcontent.append(' ');
                                            }
                                            newcontent.append("Protocol\n");
                                            isFirstToken = true;
                                            linebreak = false;
                                        } else if (strType.compareTo("__ispl_evolution") == 0) {
                                            if (addspace) {
                                                newcontent.append(' ');
                                            }
                                            newcontent.append("Evolution\n");
                                            isFirstToken = true;
                                            linebreak = false;
                                        } else if (strType.compareTo("__ispl_evaluation") == 0) {
                                            if (addspace) {
                                                newcontent.append(' ');
                                            }
                                            newcontent.append("Evaluation\n\n");
                                            isFirstToken = true;
                                            linebreak = false;
                                        } else if (strType.compareTo("__ispl_initstates") == 0) {
                                            if (addspace) {
                                                newcontent.append(' ');
                                            }
                                            newcontent.append("InitStates\n\n");
                                            isFirstToken = true;
                                            linebreak = false;
                                        } else if (strType.compareTo("__ispl_groups") == 0) {
                                            if (addspace) {
                                                newcontent.append(' ');
                                            }
                                            newcontent.append("Groups\n\n");
                                            isFirstToken = true;
                                            linebreak = false;
                                        } else if (strType.compareTo("__ispl_fairness") == 0) {
                                            if (addspace) {
                                                newcontent.append(' ');
                                            }
                                            newcontent.append("Fairness\n\n");
                                            isFirstToken = true;
                                        } else if (strType.compareTo("__ispl_formulae") == 0) {
                                            if (addspace) {
                                                newcontent.append(' ');
                                            }
                                            newcontent.append("Formulae\n");
                                            isFirstToken = true;
                                            linebreak = false;
                                        } else if (strType.compareTo("__ispl_end") == 0) {
                                            this.decreaseIndent();
                                            newcontent.append("\n" + this.indentstr() + "end");
                                            pendingend = true;
                                            expectColumn = false;
                                            expectID = false;
                                            isFirstToken = false;
                                            linebreak = false;
                                        } else {
                                            String strToken2 = document.get(WordScanner.getTokenOffset(), WordScanner.getTokenLength());
                                            newcontent.append("\n" + this.indentstr() + strToken2);
                                            pendingend = true;
                                            expectColumn = false;
                                            expectID = false;
                                            isFirstToken = false;
                                            linebreak = true;
                                        }
                                    } else if (strType.compareTo("__ispl_semantics") == 0) {
                                        if (newcontent.length() > 0 && newcontent.charAt(newcontent.length() - 1) != '\n') {
                                            newcontent.append('\n');
                                        }
                                        newcontent.append("Semantics");
                                        isFirstToken = true;
                                        this.setIndent(0);
                                        linebreak = false;
                                    } else if (strType.compareTo("__ispl_agent") == 0) {
                                        if (newcontent.length() > 0 && newcontent.charAt(newcontent.length() - 1) != '\n') {
                                            newcontent.append('\n');
                                        }
                                        newcontent.append("Agent");
                                        this.setIndent(1);
                                        isFirstToken = false;
                                        pendingend = false;
                                        expectColumn = false;
                                        expectID = true;
                                        linebreak = false;
                                    } else if (strType.compareTo("__ispl_obsvars") == 0) {
                                        if (newcontent.length() > 0 && newcontent.charAt(newcontent.length() - 1) != '\n') {
                                            newcontent.append('\n');
                                        }
                                        newcontent.append(this.indentstr(1));
                                        newcontent.append("Obsvars");
                                        isFirstToken = false;
                                        this.setIndent(2);
                                        pendingend = false;
                                        expectColumn = true;
                                        expectID = false;
                                        linebreak = false;
                                    } else if (strType.compareTo("__ispl_vars") == 0) {
                                        if (newcontent.length() > 0 && newcontent.charAt(newcontent.length() - 1) != '\n') {
                                            newcontent.append('\n');
                                        }
                                        newcontent.append(this.indentstr(1));
                                        newcontent.append("Vars");
                                        isFirstToken = false;
                                        this.setIndent(2);
                                        pendingend = false;
                                        expectColumn = true;
                                        expectID = false;
                                        linebreak = false;
                                    } else if (strType.compareTo("__ispl_RedStates") == 0) {
                                        if (newcontent.length() > 0 && newcontent.charAt(newcontent.length() - 1) != '\n') {
                                            newcontent.append('\n');
                                        }
                                        newcontent.append(this.indentstr(1));
                                        newcontent.append("RedStates");
                                        isFirstToken = false;
                                        this.setIndent(2);
                                        pendingend = false;
                                        expectColumn = true;
                                        expectID = false;
                                        linebreak = false;
                                    } else if (strType.compareTo("__ispl_protocol") == 0) {
                                        if (newcontent.length() > 0 && newcontent.charAt(newcontent.length() - 1) != '\n') {
                                            newcontent.append('\n');
                                        }
                                        newcontent.append(this.indentstr(1));
                                        newcontent.append("Protocol");
                                        isFirstToken = false;
                                        this.setIndent(2);
                                        pendingend = false;
                                        expectColumn = true;
                                        expectID = false;
                                        linebreak = false;
                                    } else if (strType.compareTo("__ispl_evolution") == 0) {
                                        if (newcontent.length() > 0 && newcontent.charAt(newcontent.length() - 1) != '\n') {
                                            newcontent.append('\n');
                                        }
                                        newcontent.append(this.indentstr(1));
                                        newcontent.append("Evolution");
                                        isFirstToken = false;
                                        this.setIndent(2);
                                        pendingend = false;
                                        expectColumn = true;
                                        expectID = false;
                                        linebreak = false;
                                    } else if (strType.compareTo("__ispl_evaluation") == 0) {
                                        if (newcontent.length() > 0 && newcontent.charAt(newcontent.length() - 1) != '\n') {
                                            newcontent.append('\n');
                                        }
                                        newcontent.append("Evaluation\n");
                                        isFirstToken = true;
                                        this.setIndent(1);
                                        linebreak = false;
                                    } else if (strType.compareTo("__ispl_initstates") == 0) {
                                        if (newcontent.length() > 0 && newcontent.charAt(newcontent.length() - 1) != '\n') {
                                            newcontent.append('\n');
                                        }
                                        newcontent.append("InitStates\n");
                                        isFirstToken = true;
                                        this.setIndent(1);
                                        linebreak = false;
                                    } else if (strType.compareTo("__ispl_groups") == 0) {
                                        if (newcontent.length() > 0 && newcontent.charAt(newcontent.length() - 1) != '\n') {
                                            newcontent.append('\n');
                                        }
                                        newcontent.append("Groups\n");
                                        isFirstToken = true;
                                        this.setIndent(1);
                                        linebreak = false;
                                    } else if (strType.compareTo("__ispl_fairness") == 0) {
                                        if (newcontent.length() > 0 && newcontent.charAt(newcontent.length() - 1) != '\n') {
                                            newcontent.append('\n');
                                        }
                                        newcontent.append("Fairness\n");
                                        isFirstToken = true;
                                        this.setIndent(1);
                                        linebreak = false;
                                    } else if (strType.compareTo("__ispl_formulae") == 0) {
                                        if (newcontent.length() > 0 && newcontent.charAt(newcontent.length() - 1) != '\n') {
                                            newcontent.append('\n');
                                        }
                                        newcontent.append("Formulae\n");
                                        isFirstToken = true;
                                        this.setIndent(1);
                                        linebreak = false;
                                    } else if (strType.compareTo("__ispl_end") == 0) {
                                        if (newcontent.length() > 0 && newcontent.charAt(newcontent.length() - 1) != '\n') {
                                            newcontent.append('\n');
                                        }
                                        this.decreaseIndent();
                                        newcontent.append(String.valueOf(this.indentstr()) + "end");
                                        isFirstToken = false;
                                        pendingend = true;
                                        expectColumn = false;
                                        expectID = false;
                                        linebreak = false;
                                    } else {
                                        String strToken3 = document.get(WordScanner.getTokenOffset(), WordScanner.getTokenLength());
                                        if (expectID) {
                                            if (!Character.isWhitespace(newcontent.charAt(newcontent.length() - 1))) {
                                                newcontent.append(' ');
                                            }
                                            newcontent.append(String.valueOf(strToken3) + "\n");
                                            linebreak = false;
                                        } else {
                                            if (isFirstToken) {
                                                newcontent.append(this.indentstr());
                                            }
                                            newcontent.append(strToken3);
                                            linebreak = true;
                                            this.increaseTwoIndent();
                                        }
                                        pendingend = false;
                                        expectColumn = false;
                                        expectID = false;
                                        isFirstToken = false;
                                    }
                                } else {
                                    strToken = document.get(WordScanner.getTokenOffset(), WordScanner.getTokenLength());
                                    if (expectColumn) {
                                        if (strToken.compareTo(":") == 0) {
                                            while (newcontent.length() > 0) {
                                                if (!Character.isWhitespace(newcontent.length() - 1)) break;
                                                newcontent.deleteCharAt(newcontent.length() - 1);
                                            }
                                            newcontent.append(":\n");
                                            isFirstToken = true;
                                            linebreak = false;
                                        } else {
                                            newcontent.append("\n" + this.indentstr() + strToken);
                                            isFirstToken = false;
                                            if (strToken.compareTo(";") == 0) {
                                                this.decreaseTwoIndent();
                                                newcontent.append('\n');
                                                linebreak = false;
                                            }
                                        }
                                    } else {
                                        if (isFirstToken) {
                                            newcontent.append(this.indentstr());
                                            isFirstToken = false;
                                        }
                                        newcontent.append(strToken);
                                        if (strToken.compareTo(";") == 0) {
                                            this.decreaseTwoIndent();
                                            newcontent.append('\n');
                                            linebreak = false;
                                            Position p = Util.getWordPositionBackward((IDocument)document, (int)WordScanner.getTokenOffset());
                                            String str = document.get(p.offset, p.length);
                                            if (str.compareTo("SingleAssignment") == 0 || str.compareTo("SA") == 0 || str.compareTo("MultiAssignment") == 0 || str.compareTo("MA") == 0) {
                                                newcontent.append('\n');
                                            }
                                        }
                                    }
                                    pendingend = false;
                                    expectColumn = false;
                                    expectID = false;
                                }
                            }
                            t = WordScanner.nextToken();
                        }
                        if (linebreak) {
                            newcontent.append('\n');
                        }
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return newcontent.toString();
    }

    private String indentstr() {
        String str = "";
        int i = 0;
        while (i < this.indent) {
            str = String.valueOf(str) + "\t";
            ++i;
        }
        return str;
    }

    private String indentstr(int count) {
        String str = "";
        int i = 0;
        while (i < count) {
            str = String.valueOf(str) + "\t";
            ++i;
        }
        return str;
    }

    private void decreaseIndent() {
        this.indent = this.indent > 0 ? this.indent - 1 : 0;
    }

    private void increaseTwoIndent() {
        this.indent = this.indent < 3 ? this.indent + 2 : this.indent;
    }

    private void decreaseTwoIndent() {
        this.indent = this.indent > 2 ? this.indent - 2 : this.indent;
    }

    private void setIndent(int i) {
        this.indent = i;
    }
}

