/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.editors;

import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.mcmas.ui.editors.IsplAnnotationHover;
import org.mcmas.ui.editors.IsplAutoIndentStrategy;
import org.mcmas.ui.editors.IsplCodeScanner;
import org.mcmas.ui.editors.IsplColorProvider;
import org.mcmas.ui.editors.IsplCompletionProcessor;
import org.mcmas.ui.editors.IsplFormattingStrategy;
import org.mcmas.ui.editors.IsplTextHover;
import org.mcmas.ui.editors.MCMASEditor;

public class IsplSourceViewerConfig
extends SourceViewerConfiguration {
    private static IsplCodeScanner scanner;
    private MCMASEditor fEditor;

    public IsplSourceViewerConfig(MCMASEditor anEditor) {
        this.fEditor = anEditor;
        if (scanner == null) {
            scanner = new IsplCodeScanner(new IsplColorProvider());
        }
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer aSourceViewer) {
        IsplAnnotationHover h = new IsplAnnotationHover();
        h.setMCMASEditor(this.fEditor);
        return h;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        IsplTextHover h = new IsplTextHover();
        h.setMCMASEditor(this.fEditor);
        return h;
    }

    public IReconciler getReconciler(ISourceViewer aSourceViewer) {
        return new MonoReconciler((IReconcilingStrategy)this.fEditor.getReconcilingStrategy(), false);
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return 4;
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"\t", "    "};
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        IsplAutoIndentStrategy strategy = "__dftl_partition_content_type".equals(contentType) ? new IsplAutoIndentStrategy() : new DefaultIndentLineAutoEditStrategy();
        return new IAutoEditStrategy[]{strategy};
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
        formatter.setMasterStrategy((IFormattingStrategy)new IsplFormattingStrategy());
        return formatter;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new IsplCompletionProcessor(this.fEditor), "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(100);
        assistant.setProposalPopupOrientation(10);
        return assistant;
    }
}

