/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.editors;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.mcmas.ui.Activator;
import org.mcmas.ui.editors.IsplColorProvider;
import org.mcmas.ui.editors.IsplContentOutlinePage;
import org.mcmas.ui.editors.IsplReconcilingStrategy;
import org.mcmas.ui.editors.IsplSourceViewerConfig;
import org.mcmas.ui.editors.IsplWordScanner;
import org.mcmas.ui.editors.MCMASEditorMessages;
import org.mcmas.ui.editors.MultiPageEditor;
import org.mcmas.ui.editors.Segment;
import org.mcmas.ui.syntax.CounterExample;
import org.mcmas.ui.syntax.EnabledTransitions;
import org.mcmas.ui.syntax.ErrorInfo;
import org.mcmas.ui.syntax.ISPLLexer;
import org.mcmas.ui.syntax.ISPLParser;
import org.mcmas.ui.syntax.ISPLTREE;
import org.mcmas.ui.syntax.InterpretedSystem;
import org.mcmas.ui.syntax.RawSegment;
import org.mcmas.ui.syntax.Util;
import org.mcmas.ui.syntax.bool_expression;
import org.mcmas.ui.syntax.counterexampleLexer;
import org.mcmas.ui.syntax.counterexampleParser;
import org.mcmas.ui.syntax.enabledtransitionsLexer;
import org.mcmas.ui.syntax.enabledtransitionsParser;

public class MCMASEditor
extends TextEditor {
    private IsplContentOutlinePage fOutlinePage;
    private static IsplWordScanner WordScanner;
    public String errorMessage = "";
    public InterpretedSystem is;
    public int semantics = 0;
    private ISPLLexer lexer;
    private CommonTokenStream tokens;
    private ISPLParser parser;
    public ArrayList<RawSegment> ispltree;
    private IsplReconcilingStrategy fReconcilingStrategy = new IsplReconcilingStrategy(this);
    private ProjectionSupport projectionSupport;
    private Annotation[] oldAnnotations;
    public ProjectionAnnotationModel annotationModel;
    private boolean isInteractiveMode = false;
    private boolean isInteractiveMode1 = false;
    private String BDDOrdering;
    private Process proc;
    private BufferedReader br;
    private BufferedWriter bw;
    private MultiPageEditor parentEditor;
    private CounterExample r;
    private EnabledTransitions et;
    private int step;
    private ArrayList<Position> symbolicStack;
    private int symbolicOffset;
    private IsplColorProvider colorProvider;

    public MCMASEditor() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new IsplSourceViewerConfig(this));
        if (WordScanner == null) {
            WordScanner = new IsplWordScanner();
        }
        this.ispltree = new ArrayList();
        this.colorProvider = new IsplColorProvider();
    }

    public void setMultiPageEditor(MultiPageEditor parentEditor) {
        this.parentEditor = parentEditor;
    }

    public MultiPageEditor getMultiPageEditor() {
        return this.parentEditor;
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new IsplContentOutlinePage(this.getDocumentProvider(), (ITextEditor)this);
                if (this.getEditorInput() != null) {
                    this.fOutlinePage.setInput((Object)this.getEditorInput());
                }
            }
            return this.fOutlinePage;
        }
        return super.getAdapter(required);
    }

    public void dispose() {
        if (this.fOutlinePage != null) {
            this.getSelectionProvider().removeSelectionChangedListener(this.fOutlinePage.getISelectionChangedListener());
        }
        this.disposeIsplTree();
        IEditorInput editorInput = this.getEditorInput();
        try {
            if (editorInput instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)editorInput).getFile();
                file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            } else if (editorInput instanceof FileStoreEditorInput) {
                URI uri = ((FileStoreEditorInput)editorInput).getURI();
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
                if (files != null && files.length > 0) {
                    int j = 0;
                    while (j < files.length) {
                        files[j].deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                        ++j;
                    }
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        this.checkSyntax();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.checkSyntax();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSaveAs() {
        super.doSaveAs();
        this.checkSyntax();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void updateOutlinePage() {
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public IsplReconcilingStrategy getReconcilingStrategy() {
        return this.fReconcilingStrategy;
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        ISelection selection = this.getEditorSite().getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            int start = ((ITextSelection)selection).getOffset();
            IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            try {
                char c = document.getChar(start);
                while (Character.isWhitespace(c) && c != '\n') {
                    c = document.getChar(++start);
                }
                if (this.fOutlinePage != null) {
                    this.fOutlinePage.setSelectedItem(start);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void updateFoldingStructure() {
        if (this.fOutlinePage != null) {
            ArrayList positions = this.fOutlinePage.getProjectionPositions();
            Annotation[] annotations = new Annotation[positions.size()];
            HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
            int i = 0;
            while (i < positions.size()) {
                ProjectionAnnotation annotation = new ProjectionAnnotation();
                newAnnotations.put(annotation, (Position)positions.get(i));
                annotations[i] = annotation;
                ++i;
            }
            this.annotationModel.modifyAnnotations(this.oldAnnotations, newAnnotations, null);
            this.oldAnnotations = annotations;
        }
    }

    public void addAgent() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        WordScanner.setRange(document, 0, document.getLength());
        IToken t = WordScanner.nextToken();
        TypedRegion r = null;
        while (!t.isEOF()) {
            if (t.getData() != null && t.getData().toString().compareTo("__ispl_agent") == 0) {
                r = new TypedRegion(WordScanner.getTokenOffset(), WordScanner.getTokenLength(), "__ispl_agent");
            }
            t = WordScanner.nextToken();
        }
        String basicFrame = "Agent\n";
        basicFrame = String.valueOf(basicFrame) + "    Vars:\n";
        basicFrame = String.valueOf(basicFrame) + "    end Vars\n";
        basicFrame = String.valueOf(basicFrame) + "    Actions = {};\n";
        basicFrame = String.valueOf(basicFrame) + "    Protocol:\n";
        basicFrame = String.valueOf(basicFrame) + "    end Protocol\n";
        basicFrame = String.valueOf(basicFrame) + "    Evolution:\n";
        basicFrame = String.valueOf(basicFrame) + "    end Evolution\n";
        basicFrame = String.valueOf(basicFrame) + "end Agent";
        try {
            if (r != null) {
                document.replace(r.getOffset() + r.getLength(), 0, "\n\n" + basicFrame);
            } else {
                document.replace(0, 0, String.valueOf(basicFrame) + "\n\n");
            }
        }
        catch (BadLocationException x) {
            x.printStackTrace();
        }
    }

    public void disposeIsplTree() {
        if (this.ispltree != null) {
            int i = 0;
            while (i < this.ispltree.size()) {
                ArrayList children;
                RawSegment seg = (RawSegment)this.ispltree.get(i);
                if (seg != null && (children = seg.getChildren()) != null) {
                    int j = 0;
                    while (j < children.size()) {
                        RawSegment child = (RawSegment)children.get(j);
                        if (child != null && child.getChildren() != null) {
                            child.getChildren().clear();
                        }
                        ++j;
                    }
                    children.clear();
                }
                ++i;
            }
            this.ispltree.clear();
            this.ispltree = null;
        }
    }

    public synchronized boolean checkSyntax() {
        this.disposeIsplTree();
        this.ispltree = new ArrayList();
        this.errorMessage = "";
        IEditorInput editorInput = this.getEditorInput();
        IDocument document = this.getDocumentProvider().getDocument((Object)editorInput);
        try {
            ANTLRStringStream cs = new ANTLRStringStream(document.get());
            this.lexer = new ISPLLexer((CharStream)cs);
            this.lexer.setMCMASEditor(this);
            this.tokens = new CommonTokenStream();
            this.tokens.setTokenSource((TokenSource)this.lexer);
            this.parser = new ISPLParser((TokenStream)this.tokens);
            this.parser.setMCMASEditor(this);
            ISPLParser.is_return r = this.parser.is();
            if (Util.isEmpty((String)this.errorMessage)) {
                CommonTree t = (CommonTree)r.getTree();
                CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)t);
                ISPLTREE walker = new ISPLTREE((TreeNodeStream)nodes);
                walker.setMCMASEditor(this);
                walker.is();
            }
        }
        catch (RecognitionException cs) {
        }
        catch (Exception cs) {
            // empty catch block
        }
        if (Util.isEmpty((String)this.errorMessage)) {
            this.errorMessage = Util.global_consistency_check((Hashtable)this.is.is_agents, (ArrayList)this.is.agents, (Hashtable)this.is.is_evaluation, (bool_expression)this.is.is_istates, (Hashtable)this.is.is_groups, (ArrayList)this.is.is_formulae, (ArrayList)this.is.is_fairness, (IDocument)document, (int)this.semantics);
        }
        try {
            if (!Util.isEmpty((String)this.errorMessage)) {
                ArrayList info = this.getErrorInfo(document);
                if (info != null) {
                    if (editorInput instanceof IFileEditorInput) {
                        IFile file = ((IFileEditorInput)editorInput).getFile();
                        file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                        int i = 0;
                        while (i < info.size()) {
                            ErrorInfo m = (ErrorInfo)info.get(i);
                            this.addProblemMarker(file, m.message, m.line + 1, m.length, m.offset);
                            ++i;
                        }
                    } else if (editorInput instanceof FileStoreEditorInput) {
                        URI uri = ((FileStoreEditorInput)editorInput).getURI();
                        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
                        if (files != null && files.length > 0) {
                            int j = 0;
                            while (j < files.length) {
                                files[j].deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                                int i = 0;
                                while (i < info.size()) {
                                    ErrorInfo m = (ErrorInfo)info.get(i);
                                    System.out.println("Line = " + m.line + ", Column = " + m.pos + ", Offset = " + m.offset + ", Length = " + m.length + ": " + m.message);
                                    this.addProblemMarker(files[j], m.message, m.line + 1, m.length, m.offset);
                                    ++i;
                                }
                                ++j;
                            }
                        }
                    }
                }
            } else if (editorInput instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)editorInput).getFile();
                file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            } else if (editorInput instanceof FileStoreEditorInput) {
                URI uri = ((FileStoreEditorInput)editorInput).getURI();
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
                if (files != null && files.length > 0) {
                    int j = 0;
                    while (j < files.length) {
                        files[j].deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                        ++j;
                    }
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return Util.isEmpty((String)this.errorMessage);
    }

    public ArrayList<ErrorInfo> getErrorInfo(IDocument document) {
        ArrayList<ErrorInfo> info = null;
        if (this.errorMessage != null && this.errorMessage.compareTo("") != 0) {
            String[] errors = this.errorMessage.split("\n");
            info = new ArrayList<ErrorInfo>();
            int i = 0;
            while (i < errors.length) {
                try {
                    int start = errors[i].indexOf(32);
                    int column1 = errors[i].indexOf(58, start + 1);
                    int column2 = errors[i].indexOf(58, column1 + 1);
                    int end = errors[i].indexOf(32, column2 + 1);
                    int line = Integer.parseInt(errors[i].substring(start + 1, column1)) - 1;
                    int pos = Integer.parseInt(errors[i].substring(column1 + 1, column2));
                    int length = Integer.parseInt(errors[i].substring(column2 + 1, end));
                    int offset = document.getLineOffset(line) + pos;
                    String message = errors[i].substring(end + 1);
                    ErrorInfo m = new ErrorInfo(line, pos, offset, length, message);
                    info.add(m);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                ++i;
            }
        }
        return info;
    }

    public void addProblemMarker(IFile file, String message, int line, int length, int offset) {
        try {
            IMarker marker = file.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("severity", 2);
            marker.setAttribute("lineNumber", line);
            marker.setAttribute("message", (Object)message);
            Position pos = new Position(offset);
            marker.setAttribute("charStart", offset);
            marker.setAttribute("charEnd", offset + length);
            marker.setAttribute("priority", 2);
            MarkerAnnotation ma = new MarkerAnnotation(marker);
            this.getSourceViewer().getAnnotationModel().addAnnotation((Annotation)ma, pos);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Segment[] getTreePath(int offset) {
        if (this.fOutlinePage == null) {
            return null;
        }
        return this.fOutlinePage.getTreePath(offset);
    }

    public Segment getSegmentbyName(String name) {
        if (this.fOutlinePage == null) {
            return null;
        }
        return this.fOutlinePage.getSegmentbyName(name);
    }

    public Segment getAgentSegmentbyName(String name) {
        if (this.fOutlinePage == null) {
            return null;
        }
        return this.fOutlinePage.getAgentSegmentbyName(name);
    }

    public void formatText() {
        SourceViewer viewer = (SourceViewer)this.getSourceViewer();
        viewer.doOperation(15);
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction a = new TextOperationAction(MCMASEditorMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
    }

    public void interactiveExecution() {
        boolean confirmed;
        if (this.isInteractiveMode) {
            confirmed = MessageDialog.openQuestion(null, (String)"Warning", (String)"Explicit interactive execution is running! Restart it?");
            if (!confirmed) {
                return;
            }
        } else if (this.isInteractiveMode1) {
            confirmed = MessageDialog.openQuestion(null, (String)"Warning", (String)"Symbolic interactive execution is running! Restart it?");
            if (!confirmed) {
                return;
            }
            this.isInteractiveMode1 = false;
            if (this.proc != null) {
                this.proc.destroy();
            }
        }
        this.getSourceViewer().setEditable(false);
        this.isInteractiveMode = true;
        this.parentEditor.setText("");
        ArrayList gstates = this.is.generateInitialGlobalStates();
        if (gstates != null && gstates.size() > 0) {
            String strStates = this.is.displayCandidateStates();
            this.parentEditor.setText2(strStates);
            this.parentEditor.setNumberText("");
            this.parentEditor.setChosenFlag(true);
            this.parentEditor.enableButtons(true);
            this.parentEditor.setPromptText("Choose an initial state");
            if (gstates.size() == 1) {
                this.chooseState(1);
            }
            this.parentEditor.enableBacktrackButtons(false);
        } else {
            MessageDialog.openInformation(null, (String)"Warning", (String)"There is no initial state in the model!");
            this.quitInteractiveMode();
        }
    }

    public void interactiveExecution1() {
        boolean confirmed;
        if (this.isInteractiveMode1) {
            confirmed = MessageDialog.openQuestion(null, (String)"Warning", (String)"Symbolic nteractive execution is running! Restart it?");
            if (!confirmed) {
                return;
            }
            if (this.proc != null) {
                this.proc.destroy();
            }
        } else if (this.isInteractiveMode) {
            confirmed = MessageDialog.openQuestion(null, (String)"Warning", (String)"Explicit interactive execution is running! Restart it?");
            if (!confirmed) {
                return;
            }
            this.isInteractiveMode = false;
        }
        this.getSourceViewer().setEditable(false);
        this.isInteractiveMode1 = true;
        this.parentEditor.setText("");
        this.symbolicStack = new ArrayList();
        this.symbolicOffset = 0;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String MCMASPath = store.getString("mcmas");
        String cygwinPath = store.getString("cygwin");
        this.BDDOrdering = store.getString("BDDOrdering");
        if (Util.isEmpty((String)this.BDDOrdering)) {
            this.BDDOrdering = "1";
        }
        String path = this.parentEditor.getFilePath();
        String title = this.parentEditor.getFileTitle();
        int osType = this.parentEditor.getOsType();
        String slash = osType == 0 ? "\\" : "/";
        String[] mcmasCommand = new String[]{String.valueOf(MCMASPath) + slash + "mcmas", "-s", "-q", "-o", this.BDDOrdering, String.valueOf(path) + title};
        Runtime rt = Runtime.getRuntime();
        try {
            this.proc = osType > 0 ? rt.exec(mcmasCommand) : rt.exec(mcmasCommand, new String[]{"Path=" + cygwinPath});
            InputStreamReader isr = new InputStreamReader(this.proc.getInputStream());
            InputStreamReader isr1 = new InputStreamReader(this.proc.getErrorStream());
            this.br = new BufferedReader(isr);
            OutputStreamWriter isw = new OutputStreamWriter(this.proc.getOutputStream());
            this.bw = new BufferedWriter(isw);
            BufferedReader br1 = new BufferedReader(isr1);
            String line = null;
            String output = "";
            while (!this.br.ready()) {
                if (!br1.ready()) continue;
                while (br1.ready()) {
                    line = br1.readLine();
                }
            }
            while ((line = this.br.readLine()) != null) {
                if (line.startsWith("Done.")) break;
                output = String.valueOf(output) + line + "\n";
            }
            if (!output.startsWith("No initial state. Check your model!")) {
                this.r = this.getGlobalStates(output);
                String strStates = this.r.toString1();
                this.parentEditor.setText2(strStates);
                this.parentEditor.setNumberText("");
                this.parentEditor.setChosenFlag(true);
                this.parentEditor.enableButtons(true);
                this.parentEditor.setPromptText("Choose an initial state");
                this.step = 0;
                if (this.r.numberOfStates() == 1) {
                    this.chooseState1(1);
                }
                this.parentEditor.enableBacktrackButtons(false);
            } else {
                MessageDialog.openInformation(null, (String)"Warning", (String)"There is no initial state in the model!");
                this.quitInteractiveMode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void quitInteractiveMode() {
        if (this.isInteractiveMode) {
            this.is.quitInteractiveMode();
        } else if (this.isInteractiveMode1 && this.proc != null) {
            try {
                this.bw.write("-1\n");
                this.bw.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.proc.destroy();
        }
        this.isInteractiveMode = false;
        this.isInteractiveMode1 = false;
        this.getSourceViewer().setEditable(true);
    }

    public void chooseState(int number) {
        boolean result = this.is.chooseState(number);
        if (!result) {
            MessageDialog.openError(null, (String)"Error", (String)"State No is invalid!");
        } else {
            String strState = this.is.displayCurrentState();
            this.parentEditor.appendText(strState);
            ArrayList trans = this.is.generateEnabledActions();
            if (trans != null && trans.size() > 0) {
                String strActions = this.is.displayCurrentActions();
                this.parentEditor.setText2(strActions);
                this.parentEditor.setChosenFlag(false);
                this.parentEditor.setNumberText("");
                this.parentEditor.enableBacktrackButtons(true);
                this.parentEditor.enableChooseButtons(true);
                this.parentEditor.setPromptText("Choose a action");
            } else {
                this.parentEditor.enableChooseButtons(false);
                MessageDialog.openInformation(null, (String)"Warning", (String)"There is no enabled action in the current state!");
            }
        }
    }

    public void chooseState1(int number) {
        if (number < 1 || number > this.r.numberOfStates()) {
            MessageDialog.openError(null, (String)"Error", (String)"State No is invalid!");
        } else {
            String strState = this.r.getState(number, this.step++);
            this.parentEditor.appendText(strState);
            Position p = new Position(this.symbolicOffset, strState.length());
            this.symbolicStack.add(p);
            this.symbolicOffset += strState.length();
            try {
                this.bw.write(String.valueOf(Integer.toString(number)) + "\n");
                this.bw.flush();
                String line = null;
                String output = "";
                while ((line = this.br.readLine()) != null) {
                    if (line.startsWith("Done.")) break;
                    output = String.valueOf(output) + line + "\n";
                }
                if (output.startsWith("There is no enabled action. Please backtrack or quit.")) {
                    this.parentEditor.enableChooseButtons(false);
                    MessageDialog.openInformation(null, (String)"Warning", (String)output);
                } else if (output.startsWith("There is no enabled action in the initial state.")) {
                    this.parentEditor.enableButtons(false);
                    MessageDialog.openInformation(null, (String)"Warning", (String)(String.valueOf(output) + " Interactive execution stops."));
                    this.proc.destroy();
                    this.quitInteractiveMode();
                } else {
                    this.et = this.getEnabledTransitions(output);
                    String strActions = this.et.toString();
                    this.parentEditor.setText2(strActions);
                    this.parentEditor.setChosenFlag(false);
                    this.parentEditor.setNumberText("");
                    this.parentEditor.enableBacktrackButtons(true);
                    this.parentEditor.enableChooseButtons(true);
                    this.parentEditor.setPromptText("Choose a action");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void chooseAction(int number) {
        boolean result = this.is.chooseAction(number);
        if (!result) {
            MessageDialog.openError(null, (String)"Error", (String)"Action No is invalid!");
        } else {
            String strAction = this.is.displayChosenAction();
            this.parentEditor.appendText(strAction);
            ArrayList successors = null;
            successors = this.semantics == 0 ? this.is.generateSuccessorStates() : this.is.generateSuccessorStates1();
            if (successors != null && successors.size() > 0) {
                String strStates = this.is.displayCandidateStates();
                this.parentEditor.setText2(strStates);
                this.parentEditor.setChosenFlag(true);
                this.parentEditor.setNumberText("");
                this.parentEditor.enableBacktrackButtons(true);
                this.parentEditor.enableChooseButtons(true);
                this.parentEditor.setPromptText("Choose a successor state");
                if (successors.size() == 1) {
                    this.chooseState(1);
                }
            } else {
                MessageDialog.openInformation(null, (String)"Warning", (String)"The current state does not have any successor states!");
            }
        }
    }

    public void chooseAction1(int number) {
        if (number < 1 || number > this.et.transitions.length) {
            MessageDialog.openError(null, (String)"Error", (String)"Action No is invalid!");
        } else {
            String strAction = this.et.getTransition(number);
            this.parentEditor.appendText(strAction);
            this.symbolicOffset += strAction.length();
            try {
                this.bw.write(String.valueOf(Integer.toString(number)) + "\n");
                this.bw.flush();
                String line = null;
                String output = "";
                while ((line = this.br.readLine()) != null) {
                    if (line.startsWith("Done.")) break;
                    output = String.valueOf(output) + line + "\n";
                }
                if (!output.startsWith("Maximum stack depth is reached. Please backtrack or quit.")) {
                    this.r = this.getGlobalStates(output);
                    String strStates = this.r.toString1();
                    this.parentEditor.setText2(strStates);
                    this.parentEditor.setChosenFlag(true);
                    this.parentEditor.setNumberText("");
                    this.parentEditor.enableBacktrackButtons(true);
                    this.parentEditor.enableChooseButtons(true);
                    this.parentEditor.setPromptText("Choose a successor state");
                    if (this.r.numberOfStates() == 1) {
                        this.chooseState1(1);
                    }
                } else {
                    MessageDialog.openInformation(null, (String)"Warning", (String)output);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void backtrack() {
        if (this.isInteractiveMode) {
            this.is.backtrack();
            Position p = this.is.getTopTextState();
            int start = p == null ? 0 : p.offset + p.length;
            this.parentEditor.deleteText(start);
            if (this.is.isStackEmpty()) {
                ArrayList gstates = this.is.generateInitialGlobalStates();
                String strStates = this.is.displayCandidateStates();
                this.parentEditor.setText2(strStates);
                this.parentEditor.setNumberText("");
                this.parentEditor.setChosenFlag(true);
                this.parentEditor.enableButtons(true);
                this.parentEditor.setPromptText("Choose an initial state");
                if (gstates.size() == 1) {
                    this.chooseState(1);
                }
                this.parentEditor.enableBacktrackButtons(false);
            } else {
                String strActions = this.is.displayCurrentActions();
                this.parentEditor.setText2(strActions);
                this.parentEditor.setChosenFlag(false);
                this.parentEditor.setNumberText("");
                this.parentEditor.enableBacktrackButtons(true);
                this.parentEditor.setPromptText("Choose a action");
            }
        } else {
            Position p = (Position)this.symbolicStack.get(this.symbolicStack.size() - 1);
            if (p.offset + p.length == this.symbolicOffset) {
                if (this.step > 0) {
                    --this.step;
                }
                this.symbolicStack.remove(this.symbolicStack.size() - 1);
                if (!this.symbolicStack.isEmpty()) {
                    p = (Position)this.symbolicStack.get(this.symbolicStack.size() - 1);
                    this.symbolicOffset = p.length + p.offset;
                } else {
                    this.symbolicOffset = 0;
                }
            } else {
                this.symbolicOffset = p.length + p.offset;
            }
            this.parentEditor.deleteText(this.symbolicOffset);
            try {
                this.bw.write("0\n");
                this.bw.flush();
                String line = null;
                String output = "";
                while ((line = this.br.readLine()) != null) {
                    if (line.startsWith("Done.")) break;
                    output = String.valueOf(output) + line + "\n";
                }
                if (this.symbolicStack.isEmpty()) {
                    this.r = this.getGlobalStates(output);
                    String strStates = this.r.toString1();
                    this.parentEditor.setText2(strStates);
                    this.parentEditor.setNumberText("");
                    this.parentEditor.setChosenFlag(true);
                    this.parentEditor.enableButtons(true);
                    this.parentEditor.setPromptText("Choose an initial state");
                    if (this.r.numberOfStates() == 1) {
                        this.chooseState(1);
                    }
                    this.parentEditor.enableBacktrackButtons(false);
                } else {
                    this.et = this.getEnabledTransitions(output);
                    String strActions = this.et.toString();
                    this.parentEditor.setText2(strActions);
                    this.parentEditor.setChosenFlag(false);
                    this.parentEditor.setNumberText("");
                    this.parentEditor.enableBacktrackButtons(true);
                    this.parentEditor.setPromptText("Choose a action");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Color getColor(RGB rgb) {
        return this.colorProvider.getColor(rgb);
    }

    private CounterExample getGlobalStates(String content) {
        try {
            ANTLRStringStream cs = new ANTLRStringStream(content);
            counterexampleLexer lexer1 = new counterexampleLexer((CharStream)cs);
            this.tokens = new CommonTokenStream();
            this.tokens.setTokenSource((TokenSource)lexer1);
            counterexampleParser parser = new counterexampleParser((TokenStream)this.tokens);
            CounterExample r = parser.is();
            return r;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private EnabledTransitions getEnabledTransitions(String content) {
        try {
            ANTLRStringStream cs = new ANTLRStringStream(content);
            enabledtransitionsLexer lexer1 = new enabledtransitionsLexer((CharStream)cs);
            this.tokens = new CommonTokenStream();
            this.tokens.setTokenSource((TokenSource)lexer1);
            enabledtransitionsParser parser = new enabledtransitionsParser((TokenStream)this.tokens);
            EnabledTransitions r = parser.is();
            return r;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isExplicitInteractiveExecution() {
        return this.isInteractiveMode;
    }

    public void incrementStep() {
        ++this.step;
    }

    public boolean saveFile() {
        if (this.isDirty()) {
            boolean save = MessageDialog.openConfirm(null, (String)"File changed", (String)"The content has been changed. Do you want to save it to proceed?");
            if (save) {
                this.doSave(null);
            } else {
                return false;
            }
        }
        return true;
    }
}

