/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JScrollPane;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.mcmas.ui.Activator;
import org.mcmas.ui.editors.BddButtonSelectionAdapter;
import org.mcmas.ui.editors.ExecuteMCMAS;
import org.mcmas.ui.editors.FlowCanvas;
import org.mcmas.ui.editors.IsplColorProvider;
import org.mcmas.ui.editors.MCMASEditor;
import org.mcmas.ui.editors.MultiPageEditor;
import org.mcmas.ui.syntax.CounterExample;
import org.mcmas.ui.syntax.Util;
import org.mcmas.ui.syntax.counterexampleLexer;
import org.mcmas.ui.syntax.counterexampleParser;
import org.mcmas.ui.syntax.modal_formula;

public class MultiPageEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private MCMASEditor editor;
    private Font font;
    private StyledText text1;
    private SashForm sashForm;
    private StyledText text;
    private StyledText text2;
    private Text numberText;
    private Button Choose;
    private Button Backtrack;
    private Button Quit;
    private Label label;
    private boolean chosenFlag;
    private Label prompt;
    private ScrolledForm form;
    private FormToolkit toolkit;
    private Composite formParent;
    private int osType;
    private counterexampleLexer lexer;
    private counterexampleParser parser;
    private CommonTokenStream tokens;
    private String sPath;
    private String title;
    private String MCMASPath;
    private String dotPath;
    private String cygwinPath;
    private String ReachableStates;
    private String BDDOrdering;
    private String BDDDynReorder;
    private String BDDGroup;
    private String ATLWitness;
    private String ATLCounterexample;
    private String ATLsemantics;
    private String ATLWitnessNewState;
    private String NoSubset;
    private String Deadlock;
    private String OverFlow;
    private String ExportModel;
    private ArrayList<Label> formLabels = new ArrayList();
    private ArrayList<Text> formTexts = new ArrayList();
    private ArrayList<Button> formButtons = new ArrayList();
    private StyledText t1;
    private BddButtonSelectionAdapter bddadapter;
    private Button bddinfo;
    private ArrayList<SelectionAdapter> cwadapter = new ArrayList();
    public String output;
    public Dialog cancelDialog;
    private final Hashtable<Integer, CES> cesPages = new Hashtable();
    private final ArrayList<Integer> cesPageIndex = new ArrayList();

    public MultiPageEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        String sOsName = System.getProperty("os.name");
        this.osType = sOsName.startsWith("Windows") || sOsName.startsWith("windows") ? 0 : (sOsName.startsWith("Linux") || sOsName.startsWith("linux") ? 1 : 2);
    }

    void createPage0() {
        try {
            this.editor = new MCMASEditor();
            this.editor.setMultiPageEditor(this);
            int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(index, this.editor.getTitle());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    void createPage1() {
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.text = new StyledText(composite, 768);
        this.text.setEditable(false);
        this.sashForm = new SashForm(composite, 512);
        this.sashForm.SASH_WIDTH = 5;
        this.prompt = new Label((Composite)this.sashForm, 0);
        this.prompt.setText("");
        FontData fontData = this.prompt.getFont().getFontData()[0];
        int fontHeight = fontData.getHeight();
        fontData.setHeight(fontHeight * 2);
        fontData.setStyle(1);
        this.prompt.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.font != null) {
            this.font.dispose();
        }
        this.font = new Font((Device)this.prompt.getDisplay(), fontData);
        this.prompt.setFont(this.font);
        this.text2 = new StyledText((Composite)this.sashForm, 768);
        this.text2.setEditable(false);
        Composite buttons = new Composite((Composite)this.sashForm, 0);
        GridLayout layout1 = new GridLayout();
        buttons.setLayout((Layout)layout1);
        layout1.numColumns = 5;
        layout1.verticalSpacing = 9;
        this.label = new Label(buttons, 0);
        this.label.setText("No.:");
        this.numberText = new Text(buttons, 2052);
        GridData gd = new GridData(768);
        this.numberText.setLayoutData((Object)gd);
        this.Choose = new Button(buttons, 8);
        this.Choose.setText("Choose");
        this.Choose.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.Backtrack = new Button(buttons, 8);
        this.Backtrack.setText("Backtrack");
        this.Backtrack.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.Quit = new Button(buttons, 8);
        this.Quit.setText("Quit");
        this.Quit.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        int[] weights = new int[]{5, 85, 10};
        this.sashForm.setWeights(weights);
        this.enableButtons(false);
        int index = this.addPage((Control)composite);
        this.setPageText(index, "Interactive Mode");
    }

    void createPage2() {
        this.formParent = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        layout.type = 512;
        this.formParent.setLayout((Layout)layout);
        this.toolkit = new FormToolkit(this.formParent.getDisplay());
        this.form = this.toolkit.createScrolledForm(this.formParent);
        this.form.setText("Verification result");
        GridLayout layout1 = new GridLayout();
        this.form.getBody().setLayout((Layout)layout1);
        layout1.numColumns = 4;
        layout1.verticalSpacing = 9;
        this.t1 = new StyledText(this.formParent, 768);
        this.t1.setEditable(false);
        int index = this.addPage((Control)this.formParent);
        this.setPageText(index, "Verification Results");
    }

    int createCounterExamplePage(String name, String dotPath, File dotfile, File textfile, String strFormula) {
        Composite newroot = new Composite(this.getContainer(), 0);
        GridLayout filllayout = new GridLayout();
        filllayout.numColumns = 1;
        newroot.setLayout((Layout)filllayout);
        Label formula = new Label(newroot, 8);
        formula.setLayoutData((Object)new GridData(768));
        Composite root = new Composite(newroot, 0);
        FillLayout layout1 = new FillLayout();
        root.setLayout((Layout)layout1);
        root.setLayoutData((Object)new GridData(1808));
        SashForm sashForm1 = new SashForm(root, 256);
        sashForm1.SASH_WIDTH = 5;
        Composite composite = new Composite((Composite)sashForm1, 0x1000000);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        Frame flowChart = SWT_AWT.new_Frame((Composite)composite);
        BorderLayout borderLayout1 = new BorderLayout();
        flowChart.setLayout(borderLayout1);
        FlowCanvas jPFlow = new FlowCanvas(flowChart);
        jPFlow.setFile(dotfile);
        jPFlow.readDotFile(dotPath, this.osType);
        Dimension d = jPFlow.getCanvasSize();
        jPFlow.setMinimumSize(d);
        jPFlow.setPreferredSize(d);
        JScrollPane jSPFLowChart = new JScrollPane();
        flowChart.add((Component)jSPFLowChart, "Center");
        jSPFLowChart.getViewport().add((Component)jPFlow);
        jPFlow.setBackground(Color.white);
        StyledText info = new StyledText((Composite)sashForm1, 2816);
        BufferedReader bis = null;
        String content = "";
        CounterExample r = null;
        try {
            bis = new BufferedReader(new InputStreamReader(new FileInputStream(textfile)));
            String s = bis.readLine();
            while (s != null) {
                content = String.valueOf(content) + s + "\n";
                s = bis.readLine();
            }
            bis.close();
            ANTLRStringStream cs = new ANTLRStringStream(content);
            this.lexer = new counterexampleLexer((CharStream)cs);
            this.tokens = new CommonTokenStream();
            this.tokens.setTokenSource((TokenSource)this.lexer);
            this.parser = new counterexampleParser((TokenStream)this.tokens);
            r = this.parser.is();
            this.setCounterExampleText(r, info);
            jPFlow.setCounterExampleInfo(info, r.getStatePositions());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RecognitionException e) {
            e.printStackTrace(System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] allAgents = r.getAllAgents();
        Composite c = new Composite((Composite)sashForm1, 0);
        GridLayout layout2 = new GridLayout();
        c.setLayout((Layout)layout2);
        layout2.numColumns = 2;
        layout2.verticalSpacing = 9;
        Group group = new Group(c, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        RowLayout rl = new RowLayout();
        rl.type = 512;
        group.setLayout((Layout)rl);
        Button[] checkButtons = new Button[allAgents.length];
        int i = 0;
        while (i < allAgents.length) {
            checkButtons[i] = new Button((Composite)group, 32);
            checkButtons[i].setText(allAgents[i]);
            checkButtons[i].setSelection(true);
            ++i;
        }
        Button selectAll = new Button(c, 8);
        selectAll.setText("Select all");
        selectAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button unselectAll = new Button(c, 8);
        unselectAll.setText("Unselect all");
        unselectAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        sashForm1.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        int index = this.addPage((Control)newroot);
        int count = this.getPageNameCount(name);
        CES ces = new CES(this, name, count, r, c);
        this.addCounterExamplePage(index, ces);
        Button apply = new Button(c, 8);
        apply.setText("Apply");
        apply.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setPageText(index, count == 0 ? name : String.valueOf(name) + " (" + count + ")");
        this.setActivePage(index);
        formula.setText(strFormula);
        return index;
    }

    private int getPageNameCount(String name) {
        int i = this.cesPageIndex.size() - 1;
        while (i >= 0) {
            CES ces = (CES)this.cesPages.get(this.cesPageIndex.get(i));
            if (ces.name.compareTo(name) == 0) {
                return ces.count + 1;
            }
            --i;
        }
        return 0;
    }

    private void addCounterExamplePage(int index, CES ces) {
        this.cesPages.put(new Integer(index), ces);
        this.cesPageIndex.add(new Integer(index));
    }

    public CES getCES(int index) {
        return (CES)this.cesPages.get(new Integer(index));
    }

    public boolean hasOpenCEPage() {
        return this.cesPages.isEmpty();
    }

    private CES getCounterExamplePageData(String name, int index) {
        int i = 0;
        while (i < this.cesPageIndex.size()) {
            Integer key = (Integer)this.cesPageIndex.get(i);
            CES ces = (CES)this.cesPages.get(key);
            if (ces.name.compareTo(name) == 0 && ces.count == index) {
                return ces;
            }
            ++i;
        }
        return null;
    }

    private void markOrphan() {
        int i = 0;
        while (i < this.cesPageIndex.size()) {
            Integer index = (Integer)this.cesPageIndex.get(i);
            CES ces = (CES)this.cesPages.get(index);
            if (!ces.isOrphan()) {
                ces.setOrphan();
            }
            ++i;
        }
    }

    private void setCounterExampleText(CounterExample r, StyledText info) {
        String content = r.toString();
        info.setText(content);
        int i = 0;
        while (i < r.numberOfStates()) {
            int line = r.getFirstLine(i);
            info.setLineBackground(line, 1, this.editor.getColor(IsplColorProvider.CYAN));
            ++i;
        }
        i = 0;
        while (i < r.numberOfAgents()) {
            Position p = r.getAgentPosition(i);
            StyleRange styleRange = new StyleRange();
            styleRange.start = p.offset;
            styleRange.length = p.length;
            styleRange.fontStyle = 1;
            styleRange.foreground = this.editor.getColor(IsplColorProvider.KEYWORD);
            info.setStyleRange(styleRange);
            p = r.getNamePosition(i);
            styleRange = new StyleRange();
            styleRange.start = p.offset;
            styleRange.length = p.length;
            styleRange.fontStyle = 1;
            styleRange.foreground = this.editor.getColor(IsplColorProvider.OPERATOR);
            info.setStyleRange(styleRange);
            ++i;
        }
    }

    protected void createPages() {
        this.createPage0();
        this.createPage1();
        this.createPage2();
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.dispose();
        }
        if (this.font != null) {
            this.font.dispose();
        }
        if (this.text1 != null) {
            this.text1.dispose();
        }
        if (this.sashForm != null) {
            this.sashForm.dispose();
        }
        if (this.text != null) {
            this.text.dispose();
        }
        if (this.text2 != null) {
            this.text2.dispose();
        }
        if (this.numberText != null) {
            this.numberText.dispose();
        }
        if (this.Choose != null) {
            this.Choose.dispose();
        }
        if (this.Backtrack != null) {
            this.Backtrack.dispose();
        }
        if (this.Quit != null) {
            this.Quit.dispose();
        }
        if (this.label != null) {
            this.label.dispose();
        }
        if (this.prompt != null) {
            this.prompt.dispose();
        }
        if (this.form != null) {
            this.form.dispose();
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
        if (this.formParent != null) {
            this.formParent.dispose();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(0).doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput) && !(editorInput instanceof FileStoreEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
        this.setPartName(editorInput.getName());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void quitInteractiveMode() {
        this.editor.quitInteractiveMode();
        this.enableButtons(false);
    }

    private void chooseNumber() {
        String strNumber = this.numberText.getText();
        try {
            int number = Integer.parseInt(strNumber);
            if (this.chosenFlag) {
                if (this.editor.isExplicitInteractiveExecution()) {
                    this.editor.chooseState(number);
                } else {
                    this.editor.chooseState1(number);
                }
            } else if (this.editor.isExplicitInteractiveExecution()) {
                this.editor.chooseAction(number);
            } else {
                this.editor.chooseAction1(number);
            }
            this.numberText.setFocus();
        }
        catch (NumberFormatException e) {
            MessageDialog.openError(null, (String)"Error", (String)"Please enter an valid number!");
        }
    }

    private void backtrackState() {
        this.editor.backtrack();
        this.numberText.setFocus();
    }

    public void enableButtons(boolean status) {
        this.label.setEnabled(status);
        this.numberText.setEnabled(status);
        this.Choose.setEnabled(status);
        this.Backtrack.setEnabled(status);
        this.Quit.setEnabled(status);
        this.numberText.setFocus();
    }

    public void enterInteractiveMode() {
        this.setActivePage(1);
    }

    public void enterModelChecking() {
        this.setActivePage(2);
    }

    public void appendText(String str) {
        int pos = this.text.getCaretOffset();
        this.text.append(str);
        int lastpos = pos + str.length();
        this.text.setCaretOffset(lastpos);
        this.text.setSelection(lastpos);
    }

    public void setText(String str) {
        this.text.setText(str);
    }

    public void deleteText(int start) {
        int length = this.text.getCharCount() - start;
        this.text.replaceTextRange(start, length, "");
    }

    public void setText2(String str) {
        this.text2.setText(str);
    }

    public void setNumberText(String str) {
        this.numberText.setText(str);
    }

    public void setChosenFlag(boolean flag) {
        this.chosenFlag = flag;
    }

    public void enableChooseButtons(boolean status) {
        this.label.setEnabled(status);
        this.numberText.setEnabled(status);
        this.Choose.setEnabled(status);
    }

    public void enableBacktrackButtons(boolean status) {
        this.Backtrack.setEnabled(status);
    }

    public MCMASEditor getMCMASEditor() {
        return this.editor;
    }

    public void setPromptText(String str) {
        this.prompt.setText(str);
    }

    private void createSelectionAdapter(String pagename, String dPath, File f, File f1, String strFormula, String strButtonName) {
        Button b3 = this.toolkit.createButton(this.form.getBody(), "show " + strButtonName, 8);
        this.formButtons.add(b3);
        10 sa = new /* Unavailable Anonymous Inner Class!! */;
        b3.addSelectionListener((SelectionListener)sa);
        this.cwadapter.add(sa);
    }

    public void displayResultsInForm(String[] results, String dotPath, String path, String title) {
        Label l4;
        Label l3;
        File f1;
        File f;
        Label l2;
        String strFormula;
        Label l1;
        String fullpath = String.valueOf(path) + "." + title + (this.osType == 0 ? "\\" : "/");
        String dPath = Util.isEmpty((String)dotPath) || dotPath.endsWith("/") || dotPath.endsWith("\\") ? dotPath : (this.osType == 0 ? String.valueOf(dotPath) + "\\" : String.valueOf(dotPath) + "/");
        String log = "";
        if (this.ExportModel.compareTo("1") == 0) {
            l1 = this.toolkit.createLabel(this.form.getBody(), "LTS model");
            strFormula = "LTS model";
            l2 = this.toolkit.createLabel(this.form.getBody(), " ");
            this.formLabels.add(l1);
            this.formLabels.add(l2);
            f = new File(String.valueOf(fullpath) + "model.dot");
            f1 = new File(String.valueOf(fullpath) + "model.info");
            if (f.exists()) {
                l3 = this.toolkit.createLabel(this.form.getBody(), "YES");
                this.formLabels.add(l3);
                this.createSelectionAdapter("LTS model", dPath, f, f1, "LTS model", "LTS model");
            } else {
                l3 = this.toolkit.createLabel(this.form.getBody(), "No");
                this.formLabels.add(l3);
                l4 = this.toolkit.createLabel(this.form.getBody(), "");
                this.formLabels.add(l4);
            }
            l1.setBackground(this.editor.getColor(IsplColorProvider.BLUEVIOLET));
            l3.setBackground(this.editor.getColor(IsplColorProvider.BLUEVIOLET));
        }
        if (this.Deadlock.compareTo("1") == 0) {
            l1 = this.toolkit.createLabel(this.form.getBody(), "Deadlock");
            strFormula = "Deadlock witness";
            l2 = this.toolkit.createLabel(this.form.getBody(), " ");
            this.formLabels.add(l1);
            this.formLabels.add(l2);
            f = new File(String.valueOf(fullpath) + "deadlock.dot");
            f1 = new File(String.valueOf(fullpath) + "deadlock.info");
            if (f.exists()) {
                l3 = this.toolkit.createLabel(this.form.getBody(), "TRUE");
                this.formLabels.add(l3);
                this.createSelectionAdapter("Deadlock", dPath, f, f1, "Deadlock witness", "Deadlock witness");
            } else {
                l3 = this.toolkit.createLabel(this.form.getBody(), "FALSE");
                this.formLabels.add(l3);
                l4 = this.toolkit.createLabel(this.form.getBody(), "");
                this.formLabels.add(l4);
            }
            l1.setBackground(this.editor.getColor(IsplColorProvider.GREEN));
            l3.setBackground(this.editor.getColor(IsplColorProvider.GREEN));
        }
        if (this.OverFlow.compareTo("1") == 0) {
            l1 = this.toolkit.createLabel(this.form.getBody(), "Overflow");
            strFormula = "Overflow witness";
            l2 = this.toolkit.createLabel(this.form.getBody(), " ");
            this.formLabels.add(l1);
            this.formLabels.add(l2);
            f = new File(String.valueOf(fullpath) + "overflow.dot");
            f1 = new File(String.valueOf(fullpath) + "overflow.info");
            if (f.exists()) {
                l3 = this.toolkit.createLabel(this.form.getBody(), "TRUE");
                this.formLabels.add(l3);
                this.createSelectionAdapter("Overflow", dPath, f, f1, "Overflow witness", "overflow witness");
            } else {
                l3 = this.toolkit.createLabel(this.form.getBody(), "FALSE");
                this.formLabels.add(l3);
                l4 = this.toolkit.createLabel(this.form.getBody(), "");
                this.formLabels.add(l4);
            }
            l1.setBackground(this.editor.getColor(IsplColorProvider.MAGENTA));
            l3.setBackground(this.editor.getColor(IsplColorProvider.MAGENTA));
        }
        int i = 0;
        while (i < results.length) {
            if (results[i] != null && !Util.isEmpty((String)results[i])) {
                if (results[i].compareTo("FALSE") == 0 || results[i].compareTo("TRUE") == 0) {
                    Label l12 = this.toolkit.createLabel(this.form.getBody(), "Formula " + (i + 1) + ": ");
                    String strFormula2 = ((modal_formula)this.editor.is.is_formulae.get(i)).toString();
                    Text t1 = this.toolkit.createText(this.form.getBody(), "", 8);
                    t1.setLayoutData((Object)new GridData(768));
                    Label l22 = this.toolkit.createLabel(this.form.getBody(), results[i]);
                    this.formLabels.add(l12);
                    this.formTexts.add(t1);
                    this.formLabels.add(l22);
                    File f2 = new File(String.valueOf(fullpath) + "formula" + (i + 1) + ".dot");
                    File f12 = new File(String.valueOf(fullpath) + "formula" + (i + 1) + ".info");
                    if (f2.exists()) {
                        String pagename = "Formula " + (i + 1);
                        this.createSelectionAdapter(pagename, dPath, f2, f12, strFormula2, "counterexample/witness");
                    } else {
                        Label l32 = this.toolkit.createLabel(this.form.getBody(), "");
                        this.formLabels.add(l32);
                    }
                    if (i % 2 == 0) {
                        l12.setBackground(this.editor.getColor(IsplColorProvider.YELLOW));
                        l22.setBackground(this.editor.getColor(IsplColorProvider.YELLOW));
                    } else {
                        l12.setBackground(this.editor.getColor(IsplColorProvider.CYAN));
                        l22.setBackground(this.editor.getColor(IsplColorProvider.CYAN));
                    }
                } else {
                    log = String.valueOf(log) + results[i] + "\n";
                }
            }
            ++i;
        }
        if (!Util.isEmpty((String)log)) {
            Label l13 = this.toolkit.createLabel(this.form.getBody(), " ");
            Label l23 = this.toolkit.createLabel(this.form.getBody(), " ");
            Label l33 = this.toolkit.createLabel(this.form.getBody(), " ");
            this.formLabels.add(l13);
            this.formLabels.add(l23);
            this.formLabels.add(l33);
            this.bddinfo = this.toolkit.createButton(this.form.getBody(), "show BDD information", 8);
            this.bddadapter = new BddButtonSelectionAdapter(log, this.bddinfo, this.t1);
            this.bddinfo.addSelectionListener((SelectionListener)this.bddadapter);
        }
        this.form.pack();
        this.formParent.layout();
        i = 0;
        while (i < this.formTexts.size()) {
            ((Text)this.formTexts.get(i)).setText(((modal_formula)this.editor.is.is_formulae.get(i)).toString());
            ++i;
        }
    }

    public void closePage(String name, int index) {
        int i = 0;
        while (i < this.cesPageIndex.size()) {
            Integer key = (Integer)this.cesPageIndex.get(i);
            CES ces = (CES)this.cesPages.get(key);
            if (ces.name.compareTo(name) == 0 && ces.count == index) {
                this.removePage(key.intValue());
                this.cesPages.remove(key);
                this.cesPageIndex.remove(i);
                break;
            }
            ++i;
        }
        int j = i;
        while (j < this.cesPageIndex.size()) {
            Integer k = (Integer)this.cesPageIndex.remove(j);
            CES ces = (CES)this.cesPages.remove(k);
            Integer newk = new Integer(k - 1);
            this.cesPages.put(newk, ces);
            this.cesPageIndex.add(j, newk);
            ++j;
        }
    }

    public void setPathAndTitle() {
        if (this.sPath == null || Util.isEmpty((String)this.sPath)) {
            IEditorInput editorInput = this.editor.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                IFileEditorInput fInput = (IFileEditorInput)editorInput;
                String path = fInput.getFile().getLocation().toOSString();
                this.title = fInput.getFile().getName();
                int index = path.lastIndexOf(this.title);
                this.sPath = path.substring(0, index);
            } else {
                URI uri = ((FileStoreEditorInput)editorInput).getURI();
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
                if (files != null && files.length > 0) {
                    String path = files[0].getLocation().toOSString();
                    this.title = files[0].getName();
                    int index = path.lastIndexOf(this.title);
                    this.sPath = path.substring(0, index);
                }
            }
        }
    }

    public String getFilePath() {
        if (this.sPath == null || Util.isEmpty((String)this.sPath)) {
            this.setPathAndTitle();
        }
        return this.sPath;
    }

    public String getFileTitle() {
        if (this.title == null || Util.isEmpty((String)this.title)) {
            this.setPathAndTitle();
        }
        return this.title;
    }

    public void modelChecking() {
        Label l;
        this.markOrphan();
        int i = 0;
        while (i < this.formLabels.size()) {
            l = (Label)this.formLabels.get(i);
            l.dispose();
            ++i;
        }
        this.formLabels.clear();
        i = 0;
        while (i < this.formTexts.size()) {
            l = (Text)this.formTexts.get(i);
            l.dispose();
            ++i;
        }
        this.formTexts.clear();
        i = 0;
        while (i < this.formButtons.size()) {
            Button b = (Button)this.formButtons.get(i);
            SelectionAdapter sa = (SelectionAdapter)this.cwadapter.get(i);
            b.removeSelectionListener((SelectionListener)sa);
            b.dispose();
            ++i;
        }
        this.formButtons.clear();
        this.cwadapter.clear();
        this.t1.setText("");
        if (this.bddinfo != null && !this.bddinfo.isDisposed()) {
            this.bddinfo.removeSelectionListener((SelectionListener)this.bddadapter);
            this.bddinfo.dispose();
        }
        this.setPathAndTitle();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.MCMASPath = store.getString("mcmas");
        this.dotPath = store.getString("dot");
        this.cygwinPath = store.getString("cygwin");
        this.ReachableStates = store.getString("ReachableStates");
        if (Util.isEmpty((String)this.ReachableStates)) {
            this.ReachableStates = "2";
        }
        this.BDDOrdering = store.getString("BDDOrdering");
        if (Util.isEmpty((String)this.BDDOrdering)) {
            this.BDDOrdering = "2";
        }
        this.BDDDynReorder = store.getString("BDDDynamicReordering");
        if (Util.isEmpty((String)this.BDDDynReorder)) {
            this.BDDDynReorder = "3";
        }
        this.BDDGroup = store.getString("BDDGroup");
        if (Util.isEmpty((String)this.BDDGroup)) {
            this.BDDGroup = "3";
        }
        this.ATLWitness = store.getString("ATLWitness");
        if (Util.isEmpty((String)this.ATLWitness)) {
            this.ATLWitness = "0";
        }
        this.ATLCounterexample = store.getString("ATLCounterexample");
        if (Util.isEmpty((String)this.ATLCounterexample)) {
            this.ATLCounterexample = "0";
        }
        this.ATLsemantics = store.getString("ATLsemantics");
        if (this.ATLsemantics.equals("1") && this.editor.is != null && (this.editor.is.is_fairness == null || this.editor.is.is_fairness.isEmpty())) {
            this.ATLsemantics = "0";
        }
        this.ATLWitnessNewState = store.getBoolean("ATLWitnessNewState") ? "1" : "0";
        this.NoSubset = store.getBoolean("NoSubset") ? "1" : "0";
        this.Deadlock = store.getBoolean("Deadlock") ? "1" : "0";
        this.OverFlow = store.getBoolean("OverFlow") ? "1" : "0";
        this.ExportModel = store.getBoolean("ExportModel") ? "1" : "0";
        this.output = "";
        String filepath = String.valueOf(this.sPath) + this.title;
        String cexpath = String.valueOf(this.sPath) + "." + this.title;
        File f = new File(cexpath);
        boolean dirExist = true;
        if (!f.exists()) {
            dirExist = f.mkdir();
        }
        String slash = this.osType == 0 ? "\\" : "/";
        ArrayList<String> commandoptions = new ArrayList<String>();
        commandoptions.add(String.valueOf(this.MCMASPath) + slash + "mcmas");
        commandoptions.add("-q");
        commandoptions.add("-c");
        commandoptions.add("2");
        commandoptions.add("-u");
        commandoptions.add("-p");
        commandoptions.add(String.valueOf(cexpath) + slash);
        commandoptions.add("-f");
        commandoptions.add(this.ATLWitness);
        commandoptions.add("-l");
        commandoptions.add(this.ATLCounterexample);
        commandoptions.add("-e");
        commandoptions.add(this.ReachableStates);
        commandoptions.add("-o");
        commandoptions.add(this.BDDOrdering);
        commandoptions.add("-g");
        commandoptions.add(this.BDDGroup);
        commandoptions.add("-d");
        commandoptions.add(this.BDDDynReorder);
        if (this.ATLsemantics.equals("3")) {
            commandoptions.add("-uniform");
        } else {
            commandoptions.add("-atlk");
            commandoptions.add(this.ATLsemantics);
        }
        if (this.ATLWitnessNewState.compareTo("1") == 0) {
            commandoptions.add("-w");
        }
        if (this.NoSubset.compareTo("1") == 0) {
            commandoptions.add("-n");
        }
        if (this.Deadlock.compareTo("1") == 0) {
            commandoptions.add("-k");
        }
        if (this.OverFlow.compareTo("1") == 0) {
            commandoptions.add("-a");
        }
        if (this.ExportModel.compareTo("1") == 0) {
            commandoptions.add("-exportmodel");
        }
        commandoptions.add(filepath);
        String[] mcmasCommand = new String[commandoptions.size()];
        commandoptions.toArray(mcmasCommand);
        if (dirExist) {
            File[] cexfiles = f.listFiles();
            if (cexfiles != null) {
                int i2 = 0;
                while (i2 < cexfiles.length) {
                    cexfiles[i2].delete();
                    ++i2;
                }
            }
        } else {
            System.out.println("Cannot create the directory " + cexpath + ". Counterexample generation is disabled!");
            mcmasCommand = new String[]{String.valueOf(this.MCMASPath) + slash + "mcmas", "-q", "-u", "-e", this.ReachableStates, "-o", this.BDDOrdering, filepath};
        }
        try {
            ExecuteMCMAS et = new ExecuteMCMAS(this, mcmasCommand, this.osType, "Path=" + this.cygwinPath);
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)et);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            System.out.println("Executing MCMAS was interrupted by the user.");
        }
        if (!Util.isEmpty((String)this.output)) {
            String[] tmpresults = this.output.split("\n");
            String[] results = null;
            if (tmpresults[0].compareToIgnoreCase("TRUE") != 0 && tmpresults[0].compareToIgnoreCase("FALSE") != 0) {
                results = new String[tmpresults.length - 1];
                int i3 = 0;
                while (i3 < tmpresults.length - 1) {
                    results[i3] = tmpresults[i3 + 1];
                    ++i3;
                }
                MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"Warning", (String)tmpresults[0]);
            } else {
                results = tmpresults;
            }
            this.displayResultsInForm(results, this.dotPath, this.sPath, this.title);
        }
    }

    public int getOsType() {
        return this.osType;
    }

    static /* synthetic */ MCMASEditor access$0(MultiPageEditor multiPageEditor) {
        return multiPageEditor.editor;
    }

    static /* synthetic */ Label access$1(MultiPageEditor multiPageEditor) {
        return multiPageEditor.prompt;
    }

    static /* synthetic */ Font access$2(MultiPageEditor multiPageEditor) {
        return multiPageEditor.font;
    }

    static /* synthetic */ void access$3(MultiPageEditor multiPageEditor, Font font) {
        multiPageEditor.font = font;
    }

    static /* synthetic */ void access$4(MultiPageEditor multiPageEditor) {
        multiPageEditor.chooseNumber();
    }

    static /* synthetic */ void access$5(MultiPageEditor multiPageEditor) {
        multiPageEditor.backtrackState();
    }

    static /* synthetic */ void access$6(MultiPageEditor multiPageEditor) {
        multiPageEditor.quitInteractiveMode();
    }

    static /* synthetic */ CES access$7(MultiPageEditor multiPageEditor, String string, int n) {
        return multiPageEditor.getCounterExamplePageData(string, n);
    }

    static /* synthetic */ void access$8(MultiPageEditor multiPageEditor, CounterExample counterExample, StyledText styledText) {
        multiPageEditor.setCounterExampleText(counterExample, styledText);
    }
}

