/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.syntax;

import java.util.Hashtable;
import org.mcmas.ui.syntax.assignment;
import org.mcmas.ui.syntax.expression;

public class CEAgent {
    private String name;
    private assignment[] assignments;
    private Hashtable<String, expression> vartable;
    private int length;

    public CEAgent(String name, assignment[] assignments) {
        this.name = name;
        this.assignments = assignments;
        if (assignments != null) {
            this.vartable = new Hashtable();
            int i = 0;
            while (i < assignments.length) {
                this.vartable.put(assignments[i].get_var().get_variable_name(), assignments[i].get_var_value());
                ++i;
            }
        }
        this.length = assignments == null ? 1 : 1 + assignments.length;
    }

    public String getName() {
        return this.name;
    }

    public Hashtable<String, expression> getVarTable() {
        return this.vartable;
    }

    public assignment[] getAssignments() {
        return this.assignments;
    }

    public String toString() {
        String str = "Agent " + this.name + "\n";
        if (this.assignments != null) {
            int i = 0;
            while (i < this.assignments.length) {
                str = String.valueOf(str) + "  " + this.assignments[i].toString() + "\n";
                ++i;
            }
        }
        return str;
    }

    public String toString1() {
        String str = "";
        if (this.assignments != null) {
            int i = 0;
            while (i < this.assignments.length) {
                str = String.valueOf(str) + this.assignments[i].toString() + "\n";
                ++i;
            }
        }
        return str;
    }

    public int numberOfLines() {
        return this.length;
    }

    public boolean isEqual(CEAgent cea) {
        if (this.name.compareTo(cea.getName()) != 0 || this.assignments.length != cea.getAssignments().length) {
            return false;
        }
        Hashtable vartable1 = cea.getVarTable();
        int i = 0;
        while (i < this.assignments.length) {
            String var = this.assignments[i].get_var().get_variable_name();
            expression value = this.assignments[i].get_var_value();
            expression value1 = (expression)vartable1.get(var);
            if (value1 == null || !value.equalTo(value1)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

