/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.syntax;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.text.Position;
import org.mcmas.ui.syntax.CEAgent;
import org.mcmas.ui.syntax.GlobalState;
import org.mcmas.ui.syntax.LocalState;
import org.mcmas.ui.syntax.expression;

public class CESystem {
    private int index;
    private CEAgent[] agents;
    private int length;
    private Hashtable<String, CEAgent> agenttable;

    public CESystem(int index, CEAgent[] agents) {
        this.index = index;
        this.agents = agents;
        this.length = 1;
        this.agenttable = new Hashtable();
        int i = 0;
        while (i < agents.length) {
            this.agenttable.put(agents[i].getName(), agents[i]);
            this.length += agents[i].numberOfLines();
            ++i;
        }
    }

    public CEAgent[] getAgents() {
        return this.agents;
    }

    public String prefix() {
        return "-------- State " + this.index + " --------\n";
    }

    public String toString() {
        String str = this.prefix();
        int i = 0;
        while (i < this.agents.length) {
            str = String.valueOf(str) + this.agents[i].toString();
            ++i;
        }
        return str;
    }

    public String toString1() {
        String str = "----------------------------- State No. " + this.index + " -----------------------------\n";
        int i = 0;
        while (i < this.agents.length) {
            str = String.valueOf(str) + this.agents[i].toString();
            ++i;
        }
        return str;
    }

    public String toString2(int step) {
        String str = step == 0 ? "----------------------------- Initial State -----------------------------\n" : "----------------------------- Step " + step + " -----------------------------\n";
        int i = 0;
        while (i < this.agents.length) {
            str = String.valueOf(str) + this.agents[i].toString();
            ++i;
        }
        return str;
    }

    public String toString3() {
        String str = "";
        int i = 0;
        while (i < this.agents.length) {
            str = String.valueOf(str) + this.agents[i].toString1();
            ++i;
        }
        return str;
    }

    public int numberOfLines() {
        return this.length;
    }

    public int numberOfAgents() {
        return this.agents.length;
    }

    public CESystem project(String[] names) {
        CEAgent[] subset = new CEAgent[names.length];
        int count = 0;
        int i = 0;
        while (i < names.length) {
            subset[count] = (CEAgent)this.agenttable.get(names[i]);
            ++count;
            ++i;
        }
        return new CESystem(this.index, subset);
    }

    public Position[] getAgentPositions() {
        Position[] positions = new Position[this.agents.length];
        int count = this.prefix().length();
        int i = 0;
        while (i < this.agents.length) {
            positions[i] = new Position(count, 5);
            count += this.agents[i].toString().length();
            ++i;
        }
        return positions;
    }

    public Position[] getNamePositions() {
        Position[] positions = new Position[this.agents.length];
        int count = this.prefix().length();
        int i = 0;
        while (i < this.agents.length) {
            positions[i] = new Position(count + 6, this.agents[i].getName().length());
            count += this.agents[i].toString().length();
            ++i;
        }
        return positions;
    }

    public String[] getAllAgents() {
        String[] names = new String[this.agents.length];
        int i = 0;
        while (i < this.agents.length) {
            names[i] = this.agents[i].getName();
            ++i;
        }
        return names;
    }

    public int getIndex() {
        return this.index;
    }

    public expression getVarValue(String agname, String name) {
        CEAgent agent = (CEAgent)this.agenttable.get(agname);
        if (agent != null) {
            return (expression)agent.getVarTable().get(name);
        }
        return null;
    }

    public boolean isLocalState(GlobalState g) {
        int i = 0;
        while (i < this.agents.length) {
            Hashtable vartable = this.agents[i].getVarTable();
            Enumeration k = vartable.keys();
            while (k.hasMoreElements()) {
                String key = (String)k.nextElement();
                expression value = (expression)vartable.get(key);
                LocalState lstate = (LocalState)g.getGlobalState().get(this.agents[i].getName());
                expression v = lstate.getValue(key);
                if (v != null && value.equalTo(v)) continue;
                return false;
            }
            ++i;
        }
        return true;
    }
}

