/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.syntax;

import java.util.Hashtable;
import org.eclipse.jface.text.Position;
import org.mcmas.ui.syntax.CESystem;

public class CounterExample {
    private CESystem[] states;
    private Position[] positions;
    private Position[] agentpositions;
    private Position[] namepositions;
    private int[] firstlines;
    private Hashtable<Integer, Position> indexedPosition;

    public CounterExample(CESystem[] states) {
        this.states = states;
        this.positions = new Position[states.length];
        int numOfAgents = states[0].numberOfAgents();
        this.agentpositions = new Position[states.length * numOfAgents];
        this.namepositions = new Position[states.length * numOfAgents];
        this.firstlines = new int[states.length];
        int start = 0;
        int line = 0;
        int i = 0;
        while (i < states.length) {
            String s = states[i].toString();
            this.positions[i] = new Position(start, s.length());
            this.firstlines[i] = line;
            Position[] aps = states[i].getAgentPositions();
            Position[] nps = states[i].getNamePositions();
            int j = 0;
            while (j < numOfAgents) {
                this.agentpositions[i * numOfAgents + j] = new Position(aps[j].offset + start, aps[j].length);
                this.namepositions[i * numOfAgents + j] = new Position(nps[j].offset + start, nps[j].length);
                ++j;
            }
            line += states[i].numberOfLines();
            start += s.length();
            ++i;
        }
    }

    public CESystem[] getStates() {
        return this.states;
    }

    public String toString() {
        String str = "";
        int i = 0;
        while (i < this.states.length) {
            str = String.valueOf(str) + this.states[i].toString();
            ++i;
        }
        return str;
    }

    public String toString1() {
        String str = "";
        int i = 0;
        while (i < this.states.length) {
            str = String.valueOf(str) + this.states[i].toString1();
            ++i;
        }
        return str;
    }

    public CounterExample project(String[] names) {
        CESystem[] subset = new CESystem[this.states.length];
        int i = 0;
        while (i < this.states.length) {
            subset[i] = this.states[i].project(names);
            ++i;
        }
        return new CounterExample(subset);
    }

    public Position getStatePosition(int index) {
        if (index >= 0 && index < this.positions.length) {
            return this.positions[index];
        }
        return null;
    }

    public Position getAgentPosition(int index) {
        if (index >= 0 && index < this.agentpositions.length) {
            return this.agentpositions[index];
        }
        return null;
    }

    public int numberOfAgents() {
        return this.agentpositions.length;
    }

    public Position getNamePosition(int index) {
        if (index >= 0 && index < this.namepositions.length) {
            return this.namepositions[index];
        }
        return null;
    }

    public int numberOfNames() {
        return this.namepositions.length;
    }

    public int getFirstLine(int index) {
        if (index >= 0 && index < this.firstlines.length) {
            return this.firstlines[index];
        }
        return -1;
    }

    public int numberOfStates() {
        return this.states.length;
    }

    public String[] getAllAgents() {
        return this.states[0].getAllAgents();
    }

    public Hashtable<Integer, Position> getStatePositions() {
        if (this.indexedPosition == null) {
            this.indexedPosition = new Hashtable();
        }
        int i = 0;
        while (i < this.states.length) {
            this.indexedPosition.put(new Integer(this.states[i].getIndex()), this.positions[i]);
            ++i;
        }
        return this.indexedPosition;
    }

    public String getState(int index, int step) {
        if (index >= 1 && index <= this.states.length) {
            return this.states[index - 1].toString2(step);
        }
        return "";
    }
}

