/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.syntax;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import org.mcmas.ui.syntax.HashKey;
import org.mcmas.ui.syntax.LocalState;
import org.mcmas.ui.syntax.OneVariable;
import org.mcmas.ui.syntax.basic_agent;
import org.mcmas.ui.syntax.bool_expression;
import org.mcmas.ui.syntax.expression;

public class GlobalState {
    boolean[] value;
    public Hashtable<String, LocalState> localStates;

    public GlobalState(Hashtable<String, LocalState> localStates, Hashtable<String, bool_expression> is_evaluation) {
        this.localStates = localStates;
        this.value = new boolean[is_evaluation.size()];
        int j = 0;
        Enumeration<String> i = is_evaluation.keys();
        while (i.hasMoreElements()) {
            String key = i.nextElement();
            bool_expression c = is_evaluation.get(key);
            boolean bl = this.value[j++] = c.evaluate2(this);
        }
    }

    public void computeValue(Hashtable<String, bool_expression> is_evaluation, HashMap<String, HashSet<HashKey>> propositions, HashKey hk) {
        this.value = new boolean[is_evaluation.size()];
        int j = 0;
        Enumeration<String> i = is_evaluation.keys();
        while (i.hasMoreElements()) {
            String key = i.nextElement();
            bool_expression c = is_evaluation.get(key);
            boolean result = c.evaluate2(this);
            this.value[j++] = result;
            if (!result) continue;
            HashSet<Object> states = null;
            if (propositions.containsKey(key)) {
                states = propositions.get(key);
            } else {
                states = new HashSet();
                propositions.put(key, states);
            }
            states.add(hk);
        }
    }

    public GlobalState(Hashtable<String, LocalState> localStates, boolean[] value) {
        this.localStates = localStates;
        this.value = value;
    }

    public GlobalState() {
        this.localStates = new Hashtable();
    }

    public Hashtable<String, LocalState> getGlobalState() {
        return this.localStates;
    }

    public boolean addOneLocalVariable(String agentName, OneVariable var) {
        LocalState lstate = (LocalState)this.localStates.get(agentName);
        if (lstate == null) {
            lstate = new LocalState();
            this.localStates.put(agentName, lstate);
        }
        return lstate.addVariable(var);
    }

    public GlobalState Clone() {
        Hashtable<String, LocalState> states = new Hashtable<String, LocalState>();
        Enumeration i = this.localStates.keys();
        while (i.hasMoreElements()) {
            String agent = (String)i.nextElement();
            LocalState lstate = (LocalState)this.localStates.get(agent);
            states.put(agent, lstate.Clone());
        }
        boolean[] values = null;
        return new GlobalState(states, values);
    }

    public boolean isVariableAssigned(String name, String agentName) {
        LocalState lstate = (LocalState)this.localStates.get(agentName);
        if (lstate == null) {
            return false;
        }
        return lstate.isVariableAssigned(name);
    }

    public String toString() {
        String str = "";
        Enumeration i = this.localStates.keys();
        while (i.hasMoreElements()) {
            String agentName = (String)i.nextElement();
            LocalState lstate = (LocalState)this.localStates.get(agentName);
            str = String.valueOf(str) + agentName + "\n" + lstate.toString();
        }
        return str;
    }

    public String toString(ArrayList<basic_agent> agents) {
        String str = "";
        int i = 0;
        while (i < agents.size()) {
            String agentName = agents.get(i).get_name();
            LocalState lstate = (LocalState)this.localStates.get(agentName);
            if (lstate != null) {
                str = String.valueOf(str) + agentName + "\n" + lstate.toString();
            }
            ++i;
        }
        return str;
    }

    public String toString(ArrayList<basic_agent> agents, ArrayList<ArrayList<String>> localvariables) {
        String str = "";
        int i = 0;
        while (i < agents.size()) {
            String agentName = agents.get(i).get_name();
            LocalState lstate = (LocalState)this.localStates.get(agentName);
            if (lstate != null) {
                str = String.valueOf(str) + lstate.toString(localvariables.get(i));
            }
            ++i;
        }
        return str;
    }

    public void toIntArray(ArrayList<basic_agent> agents, ArrayList<ArrayList<String>> localvariables, int[] source, int intsize) {
        int i = 0;
        while (i < agents.size()) {
            String agentName = agents.get(i).get_name();
            LocalState lstate = (LocalState)this.localStates.get(agentName);
            if (lstate != null) {
                lstate.toIntArray(source, localvariables.get(i), intsize);
            }
            ++i;
        }
    }

    public void toIntArray1(ArrayList<basic_agent> agents, ArrayList<ArrayList<String>> localvariables, boolean[] source) {
        int i = 0;
        while (i < agents.size()) {
            String agentName = agents.get(i).get_name();
            LocalState lstate = (LocalState)this.localStates.get(agentName);
            if (lstate != null) {
                lstate.toIntArray1(source, localvariables.get(i));
            }
            ++i;
        }
    }

    public expression getValue(String agentName, String varName) {
        LocalState lstate = (LocalState)this.localStates.get(agentName);
        if (lstate == null) {
            return null;
        }
        return lstate.getValue(varName);
    }

    public void replaceValue(String agentName, String varName, expression value) {
        LocalState lstate = (LocalState)this.localStates.get(agentName);
        if (lstate == null) {
            return;
        }
        lstate.replaceValue(varName, value);
    }

    public boolean equalTo(GlobalState gstate) {
        if (gstate != null && gstate.getGlobalState() != null && this.localStates != null) {
            Hashtable vars = gstate.getGlobalState();
            if (this.localStates.size() == vars.size()) {
                Enumeration i = this.localStates.keys();
                while (i.hasMoreElements()) {
                    String vname = (String)i.nextElement();
                    LocalState value = (LocalState)this.localStates.get(vname);
                    LocalState value1 = (LocalState)vars.get(vname);
                    if (value1 != null && value.equalTo(value1)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

