/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.syntax;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.jface.text.Position;
import org.mcmas.ui.syntax.GlobalState;
import org.mcmas.ui.syntax.OneVariable;
import org.mcmas.ui.syntax.Util;
import org.mcmas.ui.syntax.arithmetic_expression;
import org.mcmas.ui.syntax.assignment;
import org.mcmas.ui.syntax.basic_agent;
import org.mcmas.ui.syntax.basictype;
import org.mcmas.ui.syntax.bit_expression;
import org.mcmas.ui.syntax.bool_expression;
import org.mcmas.ui.syntax.bool_value;
import org.mcmas.ui.syntax.enum_value;
import org.mcmas.ui.syntax.enumerate;
import org.mcmas.ui.syntax.evolution_line;
import org.mcmas.ui.syntax.expression;
import org.mcmas.ui.syntax.fairness_expression;
import org.mcmas.ui.syntax.groupitem;
import org.mcmas.ui.syntax.int_value;
import org.mcmas.ui.syntax.logic_expression;
import org.mcmas.ui.syntax.modal_formula;
import org.mcmas.ui.syntax.protocol_line;
import org.mcmas.ui.syntax.rangedint;
import org.mcmas.ui.syntax.variable;

public class InterpretedSystem {
    public Hashtable<String, basic_agent> is_agents;
    public ArrayList<basic_agent> agents;
    public Hashtable<String, bool_expression> is_evaluation;
    public bool_expression is_istates;
    public Hashtable<String, TreeSet<groupitem>> is_groups;
    public ArrayList<modal_formula> is_formulae;
    public ArrayList<fairness_expression> is_fairness;
    private ArrayList<ArrayList<String>> localvariables;
    private ArrayList<GlobalState> iniStates;
    private int semantics;
    private int osarch;
    private int bddlength;
    private ArrayList<GlobalState> interactiveStack;
    private ArrayList<Position> textStack;
    private int offset = 0;
    private ArrayList<GlobalState> currentStates;
    private ArrayList<Hashtable<String, String>> currentActions;
    private Hashtable<String, String> chosenAction;
    private boolean stateActionFlag;
    public static final String initprefix = "----------------------------- Initial State -----------------------------\n";
    public static final String tranprefix = "----------------------------- Action -----------------------------\n";
    public static final String stateprefix1 = "----------------------------- Step ";
    public static final String stateprefix2 = " -----------------------------\n";

    public InterpretedSystem(Hashtable<String, basic_agent> is_agents, ArrayList<basic_agent> agents, Hashtable<String, bool_expression> is_evaluation, bool_expression is_istates, Hashtable<String, TreeSet<groupitem>> is_groups, ArrayList<modal_formula> is_formulae, ArrayList<fairness_expression> is_fairness) {
        this.is_agents = is_agents;
        this.agents = agents;
        this.is_evaluation = is_evaluation;
        this.is_istates = is_istates;
        this.is_groups = is_groups;
        this.is_formulae = is_formulae;
        this.is_fairness = is_fairness;
        this.semantics = 0;
        this.interactiveStack = new ArrayList();
        this.textStack = new ArrayList();
        this.localvariables = new ArrayList();
        int i = 0;
        while (i < agents.size()) {
            Enumeration j;
            basic_agent agent = agents.get(i);
            ArrayList<String> lvariables = new ArrayList<String>();
            if (agent.obsvars != null) {
                j = agent.obsvars.keys();
                while (j.hasMoreElements()) {
                    lvariables.add((String)j.nextElement());
                }
            }
            if (agent.vars != null) {
                j = agent.vars.keys();
                while (j.hasMoreElements()) {
                    lvariables.add((String)j.nextElement());
                }
            }
            this.localvariables.add(lvariables);
            ++i;
        }
        this.osarch = 32;
    }

    public void setSemantics(int semantics) {
        this.semantics = semantics;
    }

    public ArrayList<GlobalState> generateInitialGlobalStates() {
        ArrayList<GlobalState> globalStates = new ArrayList<GlobalState>();
        GlobalState gstate = new GlobalState();
        globalStates.add(gstate);
        bool_expression initialStates = this.is_istates.push_negation_inside();
        this.processBoolExpression(initialStates, globalStates);
        this.addMissingVariables(globalStates);
        this.currentStates = globalStates;
        this.stateActionFlag = true;
        return globalStates;
    }

    private void processBoolExpression(bool_expression stateExpression, ArrayList<GlobalState> globalStates) {
        int op = stateExpression.get_op();
        if (op == 0) {
            this.addLogicExpressionToGlobalStates((logic_expression)stateExpression.get_operand(0), globalStates);
        } else if (op == 3) {
            bool_expression expr = (bool_expression)stateExpression.get_operand(0);
            logic_expression lexpr = (logic_expression)expr.get_operand(0);
            ArrayList lexprs = lexpr.getNegation();
            ArrayList gstates = null;
            ArrayList<GlobalState> allStates = new ArrayList<GlobalState>();
            int j = lexprs.size() - 1;
            while (j >= 0) {
                logic_expression exp = (logic_expression)lexprs.get(j);
                gstates = j > 0 ? this.duplicateGlobalStates(globalStates) : globalStates;
                this.addLogicExpressionToGlobalStates(exp, gstates);
                int i = 0;
                while (i < gstates.size()) {
                    GlobalState gstate = (GlobalState)gstates.get(i);
                    boolean flag = false;
                    int k = 0;
                    while (k < allStates.size()) {
                        GlobalState gstate1 = (GlobalState)allStates.get(k);
                        if (gstate.equalTo(gstate1)) {
                            flag = true;
                            break;
                        }
                        ++k;
                    }
                    if (!flag) {
                        allStates.add(gstate);
                    }
                    ++i;
                }
                --j;
            }
            globalStates.clear();
            globalStates.addAll(allStates);
        } else if (op == 1) {
            bool_expression expr1 = (bool_expression)stateExpression.get_operand(0);
            bool_expression expr2 = (bool_expression)stateExpression.get_operand(1);
            this.processBoolExpression(expr1, globalStates);
            this.processBoolExpression(expr2, globalStates);
        } else {
            bool_expression expr1 = (bool_expression)stateExpression.get_operand(0);
            bool_expression expr2 = (bool_expression)stateExpression.get_operand(1);
            ArrayList newGlobalStates = this.duplicateGlobalStates(globalStates);
            this.processBoolExpression(expr1, globalStates);
            this.processBoolExpression(expr2, newGlobalStates);
            int i = 0;
            while (i < newGlobalStates.size()) {
                GlobalState gstate = (GlobalState)newGlobalStates.get(i);
                boolean flag = false;
                int j = 0;
                while (j < globalStates.size()) {
                    GlobalState gstate1 = (GlobalState)globalStates.get(j);
                    if (gstate.equalTo(gstate1)) {
                        flag = true;
                        break;
                    }
                    ++j;
                }
                if (!flag) {
                    globalStates.add(gstate);
                }
                ++i;
            }
        }
    }

    private ArrayList<GlobalState> duplicateGlobalStates(ArrayList<GlobalState> globalStates) {
        ArrayList<GlobalState> newGlobalStates = new ArrayList<GlobalState>();
        int i = 0;
        while (i < globalStates.size()) {
            GlobalState gstate = globalStates.get(i);
            newGlobalStates.add(gstate.Clone());
            ++i;
        }
        return newGlobalStates;
    }

    private void addLogicExpressionToGlobalStates(logic_expression expr, ArrayList<GlobalState> globalStates) {
        int i = 0;
        while (i < globalStates.size()) {
            GlobalState gstate = globalStates.get(i);
            globalStates.remove(i);
            ArrayList result = this.processLogicExpression(expr, gstate);
            if (result.size() <= 0) continue;
            globalStates.addAll(i, result);
            i += result.size();
        }
    }

    private ArrayList<GlobalState> processLogicExpression(logic_expression lexpression, GlobalState gstate) {
        variable var = (variable)lexpression.get_operand(0);
        int rop = lexpression.get_operand(1).get_type();
        ArrayList<GlobalState> globalStates = new ArrayList<GlobalState>();
        if (rop == 0) {
            variable rvar = (variable)lexpression.get_operand(1);
            basictype rbt = rvar.get_var_type();
            int bttype = rbt.get_type();
            if (bttype == 1) {
                String agentName1;
                OneVariable statevar1;
                OneVariable statevar = new OneVariable(var.get_var_type(), (expression)new bool_value(true, 0, 0));
                String agentName = var.get_agent_name();
                GlobalState tmpgstate = gstate.Clone();
                if (tmpgstate.addOneLocalVariable(agentName, statevar)) {
                    statevar1 = lexpression.get_op() == 0 ? new OneVariable(rvar.get_var_type(), (expression)new bool_value(true, 0, 0)) : new OneVariable(rvar.get_var_type(), (expression)new bool_value(false, 0, 0));
                    agentName1 = rvar.get_agent_name();
                    if (tmpgstate.addOneLocalVariable(agentName1, statevar1)) {
                        globalStates.add(tmpgstate);
                    }
                }
                statevar = new OneVariable(var.get_var_type(), (expression)new bool_value(false, 0, 0));
                agentName = var.get_agent_name();
                tmpgstate = gstate.Clone();
                if (tmpgstate.addOneLocalVariable(agentName, statevar)) {
                    statevar1 = lexpression.get_op() == 0 ? new OneVariable(rvar.get_var_type(), (expression)new bool_value(false, 0, 0)) : new OneVariable(rvar.get_var_type(), (expression)new bool_value(true, 0, 0));
                    agentName1 = rvar.get_agent_name();
                    if (tmpgstate.addOneLocalVariable(agentName1, statevar1)) {
                        globalStates.add(tmpgstate);
                    }
                }
            } else if (bttype == 2) {
                basictype bt = var.get_var_type();
                int index_begin1 = ((rangedint)bt).get_lowerbound();
                int index_end1 = ((rangedint)bt).get_upperbound();
                int index_begin2 = ((rangedint)rbt).get_lowerbound();
                int index_end2 = ((rangedint)rbt).get_upperbound();
                if (lexpression.get_op() == 0) {
                    int i = index_begin1;
                    while (i <= index_end1) {
                        if (i >= index_begin2 && i <= index_end2) {
                            OneVariable statevar = new OneVariable(var.get_var_type(), (expression)new int_value(i, 0, 0, 0, 0));
                            String agentName = var.get_agent_name();
                            GlobalState tmpgstate = gstate.Clone();
                            if (tmpgstate.addOneLocalVariable(agentName, statevar)) {
                                OneVariable statevar1 = new OneVariable(rvar.get_var_type(), (expression)new int_value(i, 0, 0, 0, 0));
                                String agentName1 = rvar.get_agent_name();
                                if (tmpgstate.addOneLocalVariable(agentName1, statevar1)) {
                                    globalStates.add(tmpgstate);
                                }
                            }
                        }
                        ++i;
                    }
                } else {
                    int i = index_begin1;
                    while (i <= index_end1) {
                        int j = index_begin2;
                        while (j <= index_end2) {
                            if (i != j) {
                                OneVariable statevar = new OneVariable(var.get_var_type(), (expression)new int_value(i, 0, 0, 0, 0));
                                String agentName = var.get_agent_name();
                                GlobalState tmpgstate = gstate.Clone();
                                if (tmpgstate.addOneLocalVariable(agentName, statevar)) {
                                    OneVariable statevar1 = new OneVariable(rvar.get_var_type(), (expression)new int_value(j, 0, 0, 0, 0));
                                    String agentName1 = rvar.get_agent_name();
                                    if (tmpgstate.addOneLocalVariable(agentName1, statevar1)) {
                                        globalStates.add(tmpgstate);
                                    }
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            } else {
                TreeSet renumvalue = ((enumerate)rbt).get_enumvalue();
                Iterator rk = renumvalue.iterator();
                if (lexpression.get_op() == 0) {
                    while (rk.hasNext()) {
                        String element = (String)rk.next();
                        OneVariable statevar = new OneVariable(var.get_var_type(), (expression)new enum_value(element, 0, 0));
                        String agentName = var.get_agent_name();
                        GlobalState tmpgstate = gstate.Clone();
                        if (!tmpgstate.addOneLocalVariable(agentName, statevar)) continue;
                        OneVariable statevar1 = new OneVariable(rvar.get_var_type(), (expression)new enum_value(element, 0, 0));
                        String agentName1 = rvar.get_agent_name();
                        if (!tmpgstate.addOneLocalVariable(agentName1, statevar1)) continue;
                        globalStates.add(tmpgstate);
                    }
                } else {
                    Iterator lk = null;
                    while (rk.hasNext()) {
                        String relement = (String)rk.next();
                        for (String lelement : renumvalue) {
                            if (lelement.compareTo(relement) == 0) continue;
                            OneVariable statevar = new OneVariable(var.get_var_type(), (expression)new enum_value(relement, 0, 0));
                            String agentName = var.get_agent_name();
                            GlobalState tmpgstate = gstate.Clone();
                            if (!tmpgstate.addOneLocalVariable(agentName, statevar)) continue;
                            OneVariable statevar1 = new OneVariable(rvar.get_var_type(), (expression)new enum_value(lelement, 0, 0));
                            String agentName1 = rvar.get_agent_name();
                            if (!tmpgstate.addOneLocalVariable(agentName1, statevar1)) continue;
                            globalStates.add(tmpgstate);
                        }
                    }
                }
            }
        } else {
            OneVariable statevar = new OneVariable(var.get_var_type(), lexpression.get_operand(1));
            String agentName = var.get_agent_name();
            GlobalState tmpgstate = gstate.Clone();
            if (tmpgstate.addOneLocalVariable(agentName, statevar)) {
                globalStates.add(tmpgstate);
            }
        }
        return globalStates;
    }

    private void mergeTwoSetsOfStates(ArrayList<GlobalState> states1, ArrayList<GlobalState> states2) {
        int i = 0;
        while (i < states2.size()) {
            GlobalState g2 = states2.get(i);
            boolean found = false;
            int j = 0;
            while (j < states1.size()) {
                GlobalState g1 = states1.get(j);
                if (g1.equalTo(g2)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                states1.add(g2);
            }
            ++i;
        }
    }

    private void addMissingVariables(ArrayList<GlobalState> globalStates) {
        ArrayList newstates = new ArrayList();
        int i = 0;
        while (i < this.agents.size()) {
            Hashtable vars;
            basic_agent agent = (basic_agent)this.agents.get(i);
            Hashtable obsvars = agent.get_obsvars();
            if (obsvars != null && obsvars.size() > 0) {
                Enumeration j = obsvars.keys();
                while (j.hasMoreElements()) {
                    basictype bt = (basictype)obsvars.get(j.nextElement());
                    int type = bt.get_type();
                    ArrayList lexprs = type == 1 ? bt.getLogicExpressions(agent.get_name()) : (type == 2 ? ((rangedint)bt).getLogicExpressions(agent.get_name()) : ((enumerate)bt).getLogicExpressions(agent.get_name()));
                    newstates.clear();
                    int k = 0;
                    while (k < globalStates.size()) {
                        ArrayList tmpstates = this.addOneMissingVariable(bt.get_name(), agent.get_name(), lexprs, globalStates.get(k));
                        this.mergeTwoSetsOfStates(newstates, tmpstates);
                        ++k;
                    }
                    globalStates.clear();
                    globalStates.addAll(newstates);
                }
            }
            if ((vars = agent.get_vars()) != null && vars.size() > 0) {
                Enumeration j = vars.keys();
                while (j.hasMoreElements()) {
                    basictype bt = (basictype)vars.get(j.nextElement());
                    int type = bt.get_type();
                    ArrayList lexprs = type == 1 ? bt.getLogicExpressions(agent.get_name()) : (type == 2 ? ((rangedint)bt).getLogicExpressions(agent.get_name()) : ((enumerate)bt).getLogicExpressions(agent.get_name()));
                    newstates.clear();
                    int k = 0;
                    while (k < globalStates.size()) {
                        ArrayList tmpstates = this.addOneMissingVariable(bt.get_name(), agent.get_name(), lexprs, globalStates.get(k));
                        this.mergeTwoSetsOfStates(newstates, tmpstates);
                        ++k;
                    }
                    globalStates.clear();
                    globalStates.addAll(newstates);
                }
            }
            ++i;
        }
    }

    private ArrayList<GlobalState> addOneMissingVariable(String name, String agentName, ArrayList<logic_expression> lexprs, GlobalState globalState) {
        ArrayList<GlobalState> allStates = new ArrayList<GlobalState>();
        if (!globalState.isVariableAssigned(name, agentName)) {
            int j = lexprs.size() - 1;
            while (j >= 0) {
                ArrayList<GlobalState> gstates = new ArrayList<GlobalState>();
                gstates.add(globalState.Clone());
                logic_expression exp = lexprs.get(j);
                this.addLogicExpressionToGlobalStates(exp, gstates);
                allStates.addAll(gstates);
                --j;
            }
        } else {
            allStates.add(globalState);
        }
        return allStates;
    }

    public boolean getEnabledActions(GlobalState gstate, Hashtable<String, TreeSet<String>> enabledActions) {
        int i = 0;
        while (i < this.agents.size()) {
            basic_agent agent = (basic_agent)this.agents.get(i);
            TreeSet actions = agent.get_actions();
            TreeSet enabled = new TreeSet();
            if (actions == null || actions.size() == 0) {
                if (agent.get_name().compareTo("Environment") != 0) {
                    enabledActions.clear();
                    return false;
                }
            } else {
                ArrayList protocol = agent.get_protocol();
                if (protocol == null || protocol.size() == 0) {
                    if (agent.get_name().compareTo("Environment") != 0) {
                        enabledActions.clear();
                        return false;
                    }
                } else {
                    bool_expression disjunction = null;
                    int j = 0;
                    while (j < protocol.size()) {
                        protocol_line line = (protocol_line)protocol.get(j);
                        bool_expression cond = line.get_condition();
                        if (cond.get_op() != 4) {
                            boolean isEnabled = cond.evaluate(agent.get_name(), gstate, null);
                            disjunction = j == 0 ? cond : new bool_expression(2, (Object)disjunction, (Object)cond, 0, 0, 0, 0);
                            if (isEnabled) {
                                this.addEnabledActions(enabled, line);
                            }
                        } else if (disjunction != null) {
                            bool_expression other;
                            boolean isEnabled;
                            if (enabled.size() == 0 && (isEnabled = (other = new bool_expression(3, (Object)disjunction, null, 0, 0, 0, 0)).evaluate(agent.get_name(), gstate, null))) {
                                this.addEnabledActions(enabled, line);
                            }
                        } else {
                            Hashtable obsvars = agent.get_obsvars();
                            Hashtable vars = agent.get_vars();
                            if (obsvars != null && obsvars.size() != 0 || vars != null && vars.size() != 0) {
                                this.addEnabledActions(enabled, line);
                            } else {
                                enabledActions.clear();
                                return false;
                            }
                        }
                        ++j;
                    }
                    if (enabled.size() > 0) {
                        enabledActions.put(agent.get_name(), enabled);
                    } else {
                        enabledActions.clear();
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public boolean getInterleavedEnabledActions(GlobalState gstate, Hashtable<String, TreeSet<String>> enabledActions) {
        int i = 0;
        while (i < this.agents.size()) {
            basic_agent agent = (basic_agent)this.agents.get(i);
            TreeSet actions = agent.get_actions();
            TreeSet enabled = new TreeSet();
            if (actions == null || actions.size() == 0) {
                if (agent.get_name().compareTo("Environment") != 0) {
                    enabledActions.clear();
                    return false;
                }
            } else {
                ArrayList protocol = agent.get_protocol();
                if (protocol == null || protocol.size() == 0) {
                    if (agent.get_name().compareTo("Environment") != 0) {
                        enabledActions.clear();
                        return false;
                    }
                } else {
                    bool_expression disjunction = null;
                    int j = 0;
                    while (j < protocol.size()) {
                        protocol_line line = (protocol_line)protocol.get(j);
                        bool_expression cond = line.get_condition();
                        if (cond.get_op() != 4) {
                            boolean isEnabled = cond.evaluate(agent.get_name(), gstate, null);
                            disjunction = j == 0 ? cond : new bool_expression(2, (Object)disjunction, (Object)cond, 0, 0, 0, 0);
                            if (isEnabled) {
                                this.addEnabledActions(enabled, line);
                            }
                        } else if (disjunction != null) {
                            bool_expression other;
                            boolean isEnabled;
                            if (enabled.size() == 0 && (isEnabled = (other = new bool_expression(3, (Object)disjunction, null, 0, 0, 0, 0)).evaluate(agent.get_name(), gstate, null))) {
                                this.addEnabledActions(enabled, line);
                            }
                        } else {
                            Hashtable obsvars = agent.get_obsvars();
                            Hashtable vars = agent.get_vars();
                            if (obsvars != null && obsvars.size() != 0 || vars != null && vars.size() != 0) {
                                this.addEnabledActions(enabled, line);
                            } else {
                                enabledActions.clear();
                                return false;
                            }
                        }
                        ++j;
                    }
                    if (enabled.size() > 0) {
                        enabledActions.put(agent.get_name(), enabled);
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private void addEnabledActions(TreeSet<String> enabled, protocol_line line) {
        TreeSet acts = line.get_actions();
        for (groupitem t : acts) {
            enabled.add(t.name);
        }
    }

    public ArrayList<Hashtable<String, String>> getPossibleTransitions(Hashtable<String, TreeSet<String>> enabledActions) {
        ArrayList<Hashtable<String, String>> trans = new ArrayList<Hashtable<String, String>>();
        int i = 0;
        while (i < this.agents.size()) {
            basic_agent agent = (basic_agent)this.agents.get(i);
            TreeSet<String> enabled = enabledActions.get(agent.get_name());
            if (enabled != null && enabled.size() > 0) {
                this.addOneAction(agent.get_name(), enabled, trans);
            }
            ++i;
        }
        return trans;
    }

    private void addOneAction(String agentName, TreeSet<String> enabled, ArrayList<Hashtable<String, String>> trans) {
        ArrayList<Hashtable> newtrans = new ArrayList<Hashtable>();
        for (String act : enabled) {
            if (trans.size() == 0) {
                Hashtable<String, String> newelement = new Hashtable<String, String>();
                newelement.put(agentName, act);
                newtrans.add(newelement);
                continue;
            }
            int j = 0;
            while (j < trans.size()) {
                Hashtable<String, String> element = trans.get(j);
                Hashtable newelement = this.duplicateActions(element);
                newelement.put(agentName, act);
                newtrans.add(newelement);
                ++j;
            }
        }
        trans.clear();
        trans.addAll(newtrans);
    }

    private Hashtable<String, String> duplicateActions(Hashtable<String, String> element) {
        if (element == null) {
            return null;
        }
        Hashtable<String, String> newelement = new Hashtable<String, String>();
        Enumeration<String> i = element.keys();
        while (i.hasMoreElements()) {
            String agent = i.nextElement();
            String action = element.get(agent);
            newelement.put(agent, action);
        }
        return newelement;
    }

    public ArrayList<GlobalState> getSuccessors(GlobalState gstate, Hashtable<String, String> actions) {
        ArrayList<GlobalState> successors = new ArrayList<GlobalState>();
        successors.add(gstate.Clone());
        int i = 0;
        while (i < this.agents.size()) {
            basic_agent agent = (basic_agent)this.agents.get(i);
            ArrayList evolution = agent.get_evolution();
            if (evolution != null) {
                ArrayList allsucc = new ArrayList();
                int j = 0;
                while (j < evolution.size()) {
                    evolution_line line = (evolution_line)evolution.get(j);
                    bool_expression cond = line.get_condition();
                    if (cond.evaluate(agent.get_name(), gstate, actions)) {
                        ArrayList tmpsucc = this.duplicateGlobalStates(successors);
                        ArrayList<GlobalState> tmpsucc1 = new ArrayList<GlobalState>();
                        ArrayList assignments = line.get_assignments();
                        int t = 0;
                        while (t < tmpsucc.size()) {
                            GlobalState tmpstate = (GlobalState)tmpsucc.get(t);
                            boolean result = this.executeAssignment(gstate, tmpstate, agent.get_name(), assignments);
                            if (result) {
                                tmpsucc1.add(tmpstate);
                            }
                            ++t;
                        }
                        this.mergeTwoSetsOfStates(allsucc, tmpsucc1);
                    }
                    ++j;
                }
                if (allsucc.size() > 0) {
                    successors.clear();
                    successors.addAll(allsucc);
                }
            }
            ++i;
        }
        this.currentStates = successors;
        return successors;
    }

    public ArrayList<GlobalState> getSuccessors1(GlobalState gstate, Hashtable<String, String> actions) {
        ArrayList<GlobalState> successors = new ArrayList<GlobalState>();
        successors.add(gstate.Clone());
        int i = 0;
        while (i < this.agents.size()) {
            basic_agent agent = (basic_agent)this.agents.get(i);
            ArrayList evolution = agent.get_evolution();
            if (evolution != null) {
                ArrayList allsucc = new ArrayList();
                Hashtable<String, ArrayList> enableditems = new Hashtable<String, ArrayList>();
                int j = 0;
                while (j < evolution.size()) {
                    evolution_line line = (evolution_line)evolution.get(j);
                    bool_expression cond = line.get_condition();
                    if (cond.evaluate(agent.get_name(), gstate, actions)) {
                        ArrayList itemgroup;
                        assignment assign = (assignment)line.get_assignments().get(0);
                        String varname = assign.get_var().get_variable_name();
                        if (enableditems.containsKey(varname)) {
                            itemgroup = (ArrayList)enableditems.get(varname);
                            itemgroup.add(line);
                        } else {
                            itemgroup = new ArrayList();
                            itemgroup.add(line);
                            enableditems.put(varname, itemgroup);
                        }
                    }
                    ++j;
                }
                Enumeration j2 = enableditems.keys();
                while (j2.hasMoreElements()) {
                    String key = (String)j2.nextElement();
                    ArrayList lines = (ArrayList)enableditems.get(key);
                    int k = 0;
                    while (k < lines.size()) {
                        ArrayList tmpsucc = this.duplicateGlobalStates(successors);
                        ArrayList<GlobalState> tmpsucc1 = new ArrayList<GlobalState>();
                        ArrayList assignments = ((evolution_line)lines.get(k)).get_assignments();
                        int t = 0;
                        while (t < tmpsucc.size()) {
                            GlobalState tmpstate = (GlobalState)tmpsucc.get(t);
                            boolean result = this.executeAssignment(gstate, tmpstate, agent.get_name(), assignments);
                            if (result) {
                                tmpsucc1.add(tmpstate);
                            }
                            ++t;
                        }
                        this.mergeTwoSetsOfStates(allsucc, tmpsucc1);
                        ++k;
                    }
                    if (allsucc.size() <= 0) continue;
                    successors.clear();
                    successors.addAll(allsucc);
                    allsucc.clear();
                }
            }
            ++i;
        }
        this.currentStates = successors;
        return successors;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean executeAssignment(GlobalState sourcestate, GlobalState gstate, String agentName, ArrayList<assignment> assignments) {
        if (assignments != null) {
            int t = 0;
            while (t < assignments.size()) {
                block16: {
                    expression value;
                    int valuetype;
                    assignment assign = assignments.get(t);
                    variable var = assign.get_var();
                    String varName = var.get_variable_name();
                    String agentName1 = var.get_agent_name();
                    if (agentName1 == null || Util.isEmpty((String)agentName1)) {
                        agentName1 = agentName;
                    }
                    if ((valuetype = (value = assign.get_var_value()).get_type()) == 0) {
                        variable var1 = (variable)value;
                        String varName1 = var1.get_variable_name();
                        String agentName2 = var1.get_agent_name();
                        if (agentName2 == null || Util.isEmpty((String)agentName2)) {
                            agentName2 = agentName;
                        }
                        expression tmpvalue = sourcestate.getValue(agentName2, varName1);
                        gstate.replaceValue(agentName1, varName, tmpvalue);
                    } else if (valuetype == 1) {
                        gstate.replaceValue(agentName1, varName, value);
                    } else {
                        rangedint bt;
                        if (valuetype == 2) {
                            int v = ((int_value)value).get_value();
                            bt = (rangedint)var.get_var_type();
                            if (bt.get_lowerbound() <= v && v <= bt.get_upperbound()) {
                                gstate.replaceValue(agentName1, varName, value);
                                break block16;
                            } else {
                                System.out.println("Int value out of bounds: " + v + " is beyond the range [" + bt.get_lowerbound() + " .. " + bt.get_upperbound() + "] of the variable " + agentName1 + "." + varName);
                                return false;
                            }
                        }
                        if (valuetype == 3) {
                            gstate.replaceValue(agentName1, varName, value);
                        } else {
                            if (valuetype >= 5 && valuetype <= 8) {
                                int v = ((arithmetic_expression)value).evaluate(agentName1, sourcestate);
                                bt = (rangedint)var.get_var_type();
                                if (bt.get_lowerbound() <= v && v <= bt.get_upperbound()) {
                                    int_value tmpvalue = new int_value(v, 0, 0, 0, 0);
                                    gstate.replaceValue(agentName1, varName, (expression)tmpvalue);
                                    break block16;
                                } else {
                                    System.out.println("Int value out of bounds: " + value.toString() + " = " + v + " is beyond the range [" + bt.get_lowerbound() + " .. " + bt.get_upperbound() + "] of the variable " + agentName1 + "." + varName);
                                    return false;
                                }
                            }
                            boolean v = ((bit_expression)value).evaluate(agentName1, sourcestate);
                            bool_value tmpvalue = new bool_value(v, 0, 0);
                            gstate.replaceValue(agentName1, varName, (expression)tmpvalue);
                        }
                    }
                }
                ++t;
            }
        }
        return true;
    }

    public void addGlobalState(GlobalState gstates) {
        this.interactiveStack.add(gstates);
        int sp = this.interactiveStack.size();
        String s = "";
        s = sp == 1 ? initprefix + gstates.toString(this.agents) : stateprefix1 + (sp - 1) + stateprefix2 + gstates.toString(this.agents);
        Position p = new Position(this.offset, s.length());
        this.textStack.add(p);
        this.offset += s.length();
    }

    public GlobalState getTopGlobalState() {
        if (this.interactiveStack.size() > 0) {
            return (GlobalState)this.interactiveStack.get(this.interactiveStack.size() - 1);
        }
        return null;
    }

    public Position getTopTextState() {
        if (this.textStack.size() > 0) {
            return (Position)this.textStack.get(this.textStack.size() - 1);
        }
        return null;
    }

    public int stackSize() {
        return this.interactiveStack.size();
    }

    public GlobalState popupGlobalState() {
        if (this.interactiveStack.size() > 0) {
            GlobalState gstates = (GlobalState)this.interactiveStack.get(this.interactiveStack.size() - 1);
            this.interactiveStack.remove(this.interactiveStack.size() - 1);
            this.textStack.remove(this.textStack.size() - 1);
            Position p = this.getTopTextState();
            this.offset = p == null ? 0 : p.offset + p.length;
            return gstates;
        }
        return null;
    }

    public void quitInteractiveMode() {
        this.interactiveStack.clear();
        this.textStack.clear();
        this.offset = 0;
        this.currentStates = null;
        this.currentActions = null;
        this.chosenAction = null;
    }

    public boolean isStackEmpty() {
        return this.interactiveStack.size() == 0;
    }

    public String displayCandidateStates() {
        if (this.currentStates != null) {
            String strStates = "";
            int i = 0;
            while (i < this.currentStates.size()) {
                GlobalState gstate = (GlobalState)this.currentStates.get(i);
                strStates = String.valueOf(strStates) + "----------------------------- State No. " + (i + 1) + stateprefix2;
                strStates = String.valueOf(strStates) + gstate.toString(this.agents);
                ++i;
            }
            return strStates;
        }
        return "";
    }

    public boolean chooseState(int number) {
        int stateCount = this.currentStates.size();
        if (number > 0 && number <= stateCount) {
            GlobalState gstate = (GlobalState)this.currentStates.get(number - 1);
            this.addGlobalState(gstate);
            this.chosenAction = null;
            return true;
        }
        return false;
    }

    public ArrayList<Hashtable<String, String>> generateEnabledActions() {
        Hashtable enabledActions = new Hashtable();
        this.getEnabledActions(this.getTopGlobalState(), enabledActions);
        this.currentActions = this.getPossibleTransitions(enabledActions);
        return this.currentActions;
    }

    public String displayCurrentActions() {
        if (this.currentActions != null) {
            String strActions = "";
            int i = 0;
            while (i < this.currentActions.size()) {
                Hashtable gtran = (Hashtable)this.currentActions.get(i);
                strActions = String.valueOf(strActions) + "----------------------------- Action No. " + (i + 1) + stateprefix2;
                int j = 0;
                while (j < this.agents.size()) {
                    String agentName = ((basic_agent)this.agents.get(j)).get_name();
                    String act = (String)gtran.get(agentName);
                    if (act != null) {
                        strActions = String.valueOf(strActions) + agentName + ": " + act + "\n";
                    }
                    ++j;
                }
                ++i;
            }
            return strActions;
        }
        return "";
    }

    public boolean chooseAction(int number) {
        int actionCount = this.currentActions.size();
        if (number > 0 && number <= actionCount) {
            this.chosenAction = (Hashtable)this.currentActions.get(number - 1);
            return true;
        }
        return false;
    }

    public ArrayList<GlobalState> generateSuccessorStates() {
        if (this.isStackEmpty()) {
            return this.generateInitialGlobalStates();
        }
        return this.getSuccessors(this.getTopGlobalState(), this.chosenAction);
    }

    public ArrayList<GlobalState> generateSuccessorStates1() {
        if (this.isStackEmpty()) {
            return this.generateInitialGlobalStates();
        }
        return this.getSuccessors1(this.getTopGlobalState(), this.chosenAction);
    }

    public void backtrack() {
        if (this.chosenAction == null) {
            this.popupGlobalState();
        } else {
            this.chosenAction = null;
            Position p = this.getTopTextState();
            this.offset = p.offset + p.length;
        }
    }

    public String displayCurrentState() {
        GlobalState gstate = this.getTopGlobalState();
        String strState = "";
        if (this.stackSize() > 0) {
            strState = this.stackSize() == 1 ? String.valueOf(strState) + initprefix : String.valueOf(strState) + stateprefix1 + (this.stackSize() - 1) + stateprefix2;
            strState = String.valueOf(strState) + gstate.toString(this.agents);
        }
        return strState;
    }

    public String displayChosenAction() {
        String strAction = "";
        if (this.chosenAction != null) {
            int i = 0;
            strAction = String.valueOf(strAction) + tranprefix;
            int j = 0;
            while (j < this.agents.size()) {
                String agentName = ((basic_agent)this.agents.get(j)).get_name();
                String act = (String)this.chosenAction.get(agentName);
                if (act != null) {
                    if (i > 0) {
                        strAction = String.valueOf(strAction) + "\n";
                    }
                    strAction = String.valueOf(strAction) + agentName + ": " + act;
                    ++i;
                }
                ++j;
            }
            strAction = String.valueOf(strAction) + "\n";
        }
        this.offset += strAction.length();
        return strAction;
    }

    public void storeIniStates() {
        if (this.iniStates == null || this.iniStates.size() == 0) {
            this.iniStates = this.generateInitialGlobalStates();
        }
    }

    public int BDDlength() {
        int k = 0;
        int i = 0;
        while (i < this.agents.size()) {
            basic_agent agent = (basic_agent)this.agents.get(i);
            k = agent.allocate_BDD_2_variables(k);
            ++i;
        }
        return k;
    }
}

