/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.syntax;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mcmas.ui.syntax.OneVariable;
import org.mcmas.ui.syntax.Util;
import org.mcmas.ui.syntax.bool_value;
import org.mcmas.ui.syntax.enum_value;
import org.mcmas.ui.syntax.expression;
import org.mcmas.ui.syntax.int_value;

public class LocalState {
    private Hashtable<String, OneVariable> stateVariables;

    public LocalState(Hashtable<String, OneVariable> stateVariables) {
        this.stateVariables = stateVariables;
    }

    public LocalState() {
        this.stateVariables = new Hashtable();
    }

    public Hashtable<String, OneVariable> getStateVariables() {
        return this.stateVariables;
    }

    public LocalState Clone() {
        Hashtable<String, OneVariable> states = new Hashtable<String, OneVariable>();
        Enumeration i = this.stateVariables.keys();
        while (i.hasMoreElements()) {
            String name = (String)i.nextElement();
            OneVariable var = (OneVariable)this.stateVariables.get(name);
            states.put(name, var.Clone());
        }
        return new LocalState(states);
    }

    public boolean addVariable(OneVariable var) {
        if (this.stateVariables != null) {
            if (this.stateVariables.containsKey(var.getName())) {
                OneVariable oldvar = (OneVariable)this.stateVariables.get(var.getName());
                expression oldValue = oldvar.getValue();
                expression newValue = var.getValue();
                int type = var.getValue().get_type();
                if (type == 1) {
                    if (!((bool_value)oldValue).isEqualTo((bool_value)newValue)) {
                        this.stateVariables = null;
                        return false;
                    }
                } else if (type == 2) {
                    if (!((int_value)oldValue).isEqualTo((int_value)newValue)) {
                        this.stateVariables = null;
                        return false;
                    }
                } else if (type == 3 && !((enum_value)oldValue).isEqualTo((enum_value)newValue)) {
                    this.stateVariables = null;
                    return false;
                }
                return true;
            }
            this.stateVariables.put(var.getName(), var);
            return true;
        }
        return false;
    }

    public boolean isVariableAssigned(String name) {
        return this.stateVariables.containsKey(name);
    }

    public String toString() {
        String str = "";
        Enumeration i = this.stateVariables.keys();
        while (i.hasMoreElements()) {
            OneVariable var = (OneVariable)this.stateVariables.get(i.nextElement());
            str = String.valueOf(str) + var.toString();
        }
        if (Util.isEmpty((String)str)) {
            str = "\n";
        }
        return str;
    }

    public String toString(ArrayList<String> lvariables) {
        String str = "";
        int i = 0;
        while (i < lvariables.size()) {
            OneVariable var = (OneVariable)this.stateVariables.get(lvariables.get(i));
            str = String.valueOf(str) + var.toString1();
            ++i;
        }
        if (Util.isEmpty((String)str)) {
            str = "\n";
        }
        return str;
    }

    public void toIntArray(int[] source, ArrayList<String> lvariables, int intsize) {
        int i = 0;
        while (i < lvariables.size()) {
            OneVariable var = (OneVariable)this.stateVariables.get(lvariables.get(i));
            var.toIntArray(source, intsize);
            ++i;
        }
    }

    public void toIntArray1(boolean[] source, ArrayList<String> lvariables) {
        int i = 0;
        while (i < lvariables.size()) {
            OneVariable var = (OneVariable)this.stateVariables.get(lvariables.get(i));
            var.toIntArray1(source);
            ++i;
        }
    }

    public expression getValue(String varName) {
        OneVariable var = (OneVariable)this.stateVariables.get(varName);
        if (var == null) {
            return null;
        }
        return var.getValue();
    }

    public void replaceValue(String varName, expression value) {
        OneVariable var = (OneVariable)this.stateVariables.get(varName);
        if (var == null) {
            return;
        }
        var.replaceValue(value);
    }

    public boolean equalTo(LocalState lstate) {
        if (lstate != null && lstate.getStateVariables() != null && this.stateVariables != null) {
            Hashtable vars = lstate.getStateVariables();
            if (this.stateVariables.size() == vars.size()) {
                Enumeration i = this.stateVariables.keys();
                while (i.hasMoreElements()) {
                    String vname = (String)i.nextElement();
                    OneVariable value = (OneVariable)this.stateVariables.get(vname);
                    OneVariable value1 = (OneVariable)vars.get(vname);
                    if (value1 != null && value.equalTo(value1)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

