/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.syntax;

import org.mcmas.ui.syntax.Util;
import org.mcmas.ui.syntax.basictype;
import org.mcmas.ui.syntax.bool_value;
import org.mcmas.ui.syntax.enum_value;
import org.mcmas.ui.syntax.enumerate;
import org.mcmas.ui.syntax.expression;
import org.mcmas.ui.syntax.int_value;
import org.mcmas.ui.syntax.rangedint;

public class OneVariable {
    private basictype var;
    private expression value;

    public OneVariable(basictype var, expression value) {
        this.var = var;
        this.value = value;
    }

    public void setValue(expression value) {
        this.value = value;
    }

    public String getName() {
        if (this.var != null) {
            return this.var.get_name();
        }
        return null;
    }

    public expression getValue() {
        return this.value;
    }

    public OneVariable Clone() {
        return new OneVariable(this.var, this.value);
    }

    public String toString() {
        return "    " + this.var.get_name() + " = " + this.value.toString() + "\n";
    }

    public String toString1() {
        return this.value.toString();
    }

    public void toIntArray(int[] source, int intsize) {
        int count;
        int iValue;
        int type = this.var.get_type();
        if (type == 1) {
            boolean v = ((bool_value)this.value).get_value();
            iValue = v ? 1 : 0;
            count = 1;
        } else if (type == 2) {
            int v = ((int_value)this.value).get_value();
            iValue = ((rangedint)this.var).get_value_index_int(v);
            count = ((rangedint)this.var).BDD_length();
        } else {
            String v = ((enum_value)this.value).get_value();
            iValue = ((enumerate)this.var).get_value_index_int(v);
            count = ((enumerate)this.var).BDD_length();
        }
        Util.leftShift((int[])source, (int)iValue, (int)count, (int)intsize);
    }

    public void toIntArray1(boolean[] source) {
        int type = this.var.get_type();
        int index = this.var.get_index_begin();
        if (type == 1) {
            source[index] = ((bool_value)this.value).get_value();
        } else if (type == 2) {
            int v = ((int_value)this.value).get_value();
            int iValue = ((rangedint)this.var).get_value_index_int(v);
            int count = ((rangedint)this.var).BDD_length();
            int j = 1;
            int i = 0;
            while (i < count) {
                source[index + count - i - 1] = (iValue & j) > 0;
                j <<= 1;
                ++i;
            }
        } else {
            String v = ((enum_value)this.value).get_value();
            boolean[] iValue = ((enumerate)this.var).get_value_index(v);
            int count = ((enumerate)this.var).BDD_length();
            int i = 0;
            while (i < count) {
                source[index + i] = iValue[i];
                ++i;
            }
        }
    }

    public void replaceValue(expression value) {
        this.value = value;
    }

    public boolean equalTo(OneVariable v) {
        if (this.getName().compareTo(v.getName()) == 0) {
            int type = this.value.get_type();
            if (type == 1) {
                return ((bool_value)this.value).equalTo((bool_value)v.getValue());
            }
            if (type == 2) {
                return ((int_value)this.value).equalTo((int_value)v.getValue());
            }
            if (type == 3) {
                return ((enum_value)this.value).equalTo((enum_value)v.getValue());
            }
        }
        return false;
    }
}

