/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.syntax;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.mcmas.ui.editors.Segment;

public class RawSegment {
    public String name;
    public int startline;
    public int startpos;
    public int endline;
    public int endpos;
    public RawSegment parent;
    public ArrayList<RawSegment> children;

    public RawSegment(String name, int l1, int p1, int l2, int p2, RawSegment parent, ArrayList<RawSegment> children) {
        this.name = name;
        this.startline = l1;
        this.startpos = p1;
        this.endline = l2;
        this.endpos = p2;
        this.parent = parent;
        this.children = children;
    }

    public String toString() {
        return this.name;
    }

    public void setParent(RawSegment parent) {
        this.parent = parent;
    }

    public void setChildren(ArrayList<RawSegment> children) {
        this.children = children;
    }

    public RawSegment getParent() {
        return this.parent;
    }

    public ArrayList<RawSegment> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Segment getSegment(IDocument document, Segment parent) {
        Position pos = new Position(0, 1);
        try {
            int offset = document.getLineOffset(this.startline) + this.startpos;
            int length = document.getLineOffset(this.endline) + this.endpos - offset;
            pos = new Position(offset, length);
        }
        catch (BadLocationException offset) {
            // empty catch block
        }
        Segment seg = new Segment(this.name, pos, parent, null);
        if (this.children != null && this.children.size() > 0) {
            ArrayList<Segment> kids = new ArrayList<Segment>();
            int i = 0;
            while (i < this.children.size()) {
                Segment child = ((RawSegment)this.children.get(i)).getSegment(document, seg);
                kids.add(child);
                ++i;
            }
            seg.setChildren(kids);
        }
        return seg;
    }
}

