/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.syntax;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.IToken;
import org.mcmas.ui.editors.IsplWordScanner;
import org.mcmas.ui.editors.Segment;
import org.mcmas.ui.syntax.assignment;
import org.mcmas.ui.syntax.basic_agent;
import org.mcmas.ui.syntax.basictype;
import org.mcmas.ui.syntax.bool_expression;
import org.mcmas.ui.syntax.evolution_line;
import org.mcmas.ui.syntax.fairness_expression;
import org.mcmas.ui.syntax.groupitem;
import org.mcmas.ui.syntax.modal_formula;
import org.mcmas.ui.syntax.protocol_line;

/*
 * Exception performing whole class analysis ignored.
 */
public class Util {
    private static String[] fgKeywords = new String[]{"Action", "Actions", "Agent", "end", "Environment", "Evaluation", "Evolution", "Fairness", "Formulae", "Groups", "InitStates", "Obsvars", "Protocol", "RedStates", "Vars", "Other", "if", "and", "or", "AG", "EG", "AX", "EX", "X", "F", "G", "AF", "EF", "A", "E", "U", "K", "GK", "GCK", "O", "DK", "boolean", "false", "true"};

    public static int log_2(int n) {
        return (int)Math.ceil(Math.log(n) / Math.log(2.0));
    }

    public static String getErrorHeader(int line, int column, int length) {
        return "line " + line + ":" + column + ":" + length + " ";
    }

    public static String global_consistency_check(Hashtable<String, basic_agent> is_agents, ArrayList<basic_agent> agents, Hashtable<String, bool_expression> is_evaluation, bool_expression is_istates, Hashtable<String, TreeSet<groupitem>> is_groups, ArrayList<modal_formula> is_formulae, ArrayList<fairness_expression> is_fairness, IDocument document, int semantics) {
        String agent_name;
        basic_agent agent;
        String errorMessage = "";
        basic_agent is_environment = agents.get(0);
        Hashtable<String, Hashtable> global_vars = new Hashtable<String, Hashtable>();
        Hashtable en_vars = new Hashtable();
        Hashtable enobsvars = is_environment.get_obsvars();
        Hashtable envars = is_environment.get_vars();
        en_vars.putAll(enobsvars);
        en_vars.putAll(envars);
        global_vars.put(is_environment.get_name(), en_vars);
        int i = 1;
        while (i < agents.size()) {
            global_vars.put(agents.get(i).get_name(), agents.get(i).get_vars());
            ++i;
        }
        TreeSet obsenum = is_environment.get_obs_enum_values();
        int t = 0;
        while (t < agents.size()) {
            bool_expression ag_red;
            agent = agents.get(t);
            agent_name = agent.get_name();
            if (t == 0) {
                Enumeration i2 = envars.keys();
                while (i2.hasMoreElements()) {
                    String key = (String)i2.nextElement();
                    if (!enobsvars.containsKey(key)) continue;
                    basictype bt = (basictype)enobsvars.get(key);
                    errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)bt.line, (int)bt.column, (int)key.length()) + "variable " + key + " has already been defined.\n";
                }
            }
            errorMessage = String.valueOf(errorMessage) + agent.check_var_against_enum_values(obsenum);
            errorMessage = String.valueOf(errorMessage) + agent.check_lobsvars(envars);
            Hashtable<String, basictype> obsvars = null;
            if (t > 0) {
                obsvars = new Hashtable<String, basictype>(enobsvars);
                Hashtable lobsvars = agent.get_lobsvars();
                if (lobsvars != null && lobsvars.size() > 0) {
                    Enumeration i3 = lobsvars.keys();
                    while (i3.hasMoreElements()) {
                        String key = (String)i3.nextElement();
                        if (envars == null || !envars.containsKey(key)) continue;
                        obsvars.put(key, (basictype)envars.get(key));
                    }
                }
            }
            if ((ag_red = agent.get_redstates()) != null) {
                errorMessage = String.valueOf(errorMessage) + ag_red.check_var_and_value(obsvars, (Hashtable)global_vars.get(agent_name), agent_name, is_agents, document);
            }
            ArrayList ag_prot = agent.get_protocol();
            TreeSet ag_act = agent.get_actions();
            int i4 = 0;
            while (i4 < ag_prot.size()) {
                TreeSet tmp_act = ((protocol_line)ag_prot.get(i4)).get_actions();
                for (groupitem action : tmp_act) {
                    String key = action.name;
                    if (ag_act.contains(key)) continue;
                    errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)action.line, (int)action.column, (int)action.name.length()) + "action " + key + " is not defined.\n";
                }
                errorMessage = String.valueOf(errorMessage) + ((protocol_line)ag_prot.get(i4)).get_condition().check_var_and_value(obsvars, (Hashtable)global_vars.get(agent_name), agent_name, is_agents, document);
                ++i4;
            }
            ArrayList ag_evol = agent.get_evolution();
            int i5 = 0;
            while (i5 < ag_evol.size()) {
                errorMessage = String.valueOf(errorMessage) + ((evolution_line)ag_evol.get(i5)).check_double_assignment();
                ArrayList va = ((evolution_line)ag_evol.get(i5)).get_assignments();
                int j = 0;
                while (j < va.size()) {
                    errorMessage = String.valueOf(errorMessage) + ((assignment)va.get(j)).check_var_and_value(enobsvars, (Hashtable)global_vars.get(agent_name), document, semantics > 0 && j > 0);
                    ++j;
                }
                errorMessage = String.valueOf(errorMessage) + ((evolution_line)ag_evol.get(i5)).get_condition().check_evolution(obsvars, (Hashtable)global_vars.get(agent_name), agent_name, is_agents, document);
                ++i5;
            }
            ++t;
        }
        Enumeration<String> i6 = is_groups.keys();
        while (i6.hasMoreElements()) {
            TreeSet<groupitem> group = is_groups.get(i6.nextElement());
            Iterator<groupitem> j = group.iterator();
            while (j.hasNext()) {
                boolean flag = false;
                groupitem agent2 = j.next();
                if (is_agents.containsKey(agent2.name)) continue;
                errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)agent2.line, (int)agent2.column, (int)agent2.name.length()) + "agent " + agent2.name + " is not defined.\n";
            }
        }
        i6 = is_evaluation.elements();
        while (i6.hasMoreElements()) {
            errorMessage = String.valueOf(errorMessage) + ((bool_expression)i6.nextElement()).check_global_consistency(global_vars, document);
        }
        t = 0;
        while (t < agents.size()) {
            bool_expression ag_green;
            agent = agents.get(t);
            agent_name = agent.get_name();
            bool_expression ag_red = agent.get_redstates();
            String redstates = String.valueOf(agent_name) + ".RedStates";
            String greenstates = String.valueOf(agent_name) + ".GreenStates";
            if (ag_red != null) {
                ag_green = new bool_expression(3, (Object)ag_red, -1, -1, -1, -1);
                is_evaluation.put(redstates, ag_red);
                is_evaluation.put(greenstates, ag_green);
            } else {
                ag_red = new bool_expression(6, null, -1, -1, -1, -1);
                ag_green = new bool_expression(5, null, -1, -1, -1, -1);
                is_evaluation.put(redstates, ag_red);
                is_evaluation.put(greenstates, ag_green);
            }
            ++t;
        }
        errorMessage = String.valueOf(errorMessage) + is_istates.check_global_consistency(global_vars, document);
        int i2 = 0;
        while (i2 < is_fairness.size()) {
            errorMessage = String.valueOf(errorMessage) + is_fairness.get(i2).check_atomic_proposition(0, is_agents, is_evaluation, is_groups);
            ++i2;
        }
        i2 = 0;
        while (i2 < is_formulae.size()) {
            errorMessage = String.valueOf(errorMessage) + is_formulae.get(i2).check_atomic_proposition(0, is_agents, is_evaluation, is_groups);
            ++i2;
        }
        return errorMessage;
    }

    public static int getLength(IDocument document, int startline, int startcolumn, int endline, int endcolumn) {
        try {
            int offset1 = document.getLineOffset(startline) + startcolumn;
            int offset2 = document.getLineOffset(endline) + endcolumn;
            return offset2 - offset1;
        }
        catch (BadLocationException e) {
            return 1;
        }
    }

    public static boolean isKeyword(String name) {
        int i = 0;
        while (i < fgKeywords.length) {
            if (fgKeywords[i].compareTo(name) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Segment searchVariable(ArrayList<Segment> children, String name) {
        if (children != null) {
            int i = 0;
            while (i < children.size()) {
                String varname;
                Segment seg = children.get(i);
                int columnoffset = seg.name.indexOf(58);
                String string = varname = columnoffset == -1 ? seg.name : seg.name.substring(0, columnoffset - 1);
                if (varname.compareTo(name) == 0) {
                    return seg;
                }
                ++i;
            }
        }
        return null;
    }

    public static char getCharBackward(IDocument document, int offset) {
        try {
            while (offset > 0) {
                char c;
                if (Character.isWhitespace(c = document.getChar(--offset))) continue;
                return c;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return '\u0000';
    }

    public static int getOffsetBackward(IDocument document, int offset) {
        try {
            while (offset > 0) {
                char c;
                if (Character.isWhitespace(c = document.getChar(--offset))) continue;
                return offset;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getCharOffsetBackward(IDocument document, int offset, int character) {
        try {
            char c;
            do {
                if (offset > 0) continue;
                return -1;
            } while (Character.isWhitespace(c = document.getChar(--offset)));
            if (c != character) return -1;
            return offset;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    public static int getDotOffset(IDocument document, int offset) {
        return Util.getCharOffsetBackward((IDocument)document, (int)offset, (int)46);
    }

    public static int getEqOffset(IDocument document, int offset) {
        return Util.getCharOffsetBackward((IDocument)document, (int)offset, (int)61);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Position getWordPositionBackward(IDocument document, int offset) {
        try {
            char c;
            int length = -1;
            int start = -1;
            while (offset > 0) {
                if (Character.isWhitespace(c = document.getChar(--offset)) || !Character.isLetterOrDigit(c) && c != '_') continue;
                length = 1;
                start = offset;
                break;
            }
            if (length == -1) {
                return new Position(offset, 0);
            }
            while (offset > 0 && (Character.isLetterOrDigit(c = document.getChar(--offset)) || c == '_')) {
                start = offset;
                ++length;
            }
            return new Position(start, length);
        }
        catch (BadLocationException badLocationException) {
            return new Position(offset, 0);
        }
    }

    public static Position getCurrentWord(IDocument document, int offset) {
        try {
            char c = document.getChar(offset);
            if (!Character.isLetterOrDigit(c) && c != '_') {
                return new Position(offset, 0);
            }
            int length = 1;
            int start = offset;
            int pos = offset;
            while (pos > 0) {
                if (!Character.isLetterOrDigit(c = document.getChar(--pos)) && c != '_') break;
                ++length;
                start = pos;
            }
            pos = offset;
            while (pos < document.getLength()) {
                if (!Character.isLetterOrDigit(c = document.getChar(++pos)) && c != '_') break;
                ++length;
            }
            return new Position(start, length);
        }
        catch (BadLocationException badLocationException) {
            return new Position(offset, 0);
        }
    }

    public static Position searchMatchedWord(IDocument document, String name, int offset) {
        try {
            IsplWordScanner WordScanner = new IsplWordScanner();
            String key = IsplWordScanner.getKeyWordID((String)name);
            int line = document.getLineOfOffset(offset);
            int off = -1;
            int i = line;
            while (i >= 0) {
                WordScanner.setRange(document, document.getLineOffset(i), document.getLineLength(i));
                IToken t = WordScanner.nextToken();
                while (!t.isEOF()) {
                    if (t.getData() != null && t.getData().toString().compareTo(key) == 0 && WordScanner.getTokenOffset() < offset) {
                        off = WordScanner.getTokenOffset();
                    }
                    t = WordScanner.nextToken();
                }
                if (off >= 0) {
                    return new Position(off, name.length());
                }
                --i;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return new Position(offset, 0);
    }

    public static Position searchMatchedWord(IDocument document, String[] names, int offset) {
        try {
            IsplWordScanner WordScanner = new IsplWordScanner();
            String[] keys = new String[names.length];
            int i = 0;
            while (i < keys.length) {
                keys[i] = IsplWordScanner.getKeyWordID((String)names[i]);
                ++i;
            }
            int line = document.getLineOfOffset(offset);
            int off = -1;
            int length = -1;
            int i2 = line;
            while (i2 >= 0) {
                WordScanner.setRange(document, document.getLineOffset(i2), document.getLineLength(i2));
                IToken t = WordScanner.nextToken();
                while (!t.isEOF()) {
                    if (t.getData() != null && WordScanner.getTokenOffset() < offset) {
                        int j = 0;
                        while (j < keys.length) {
                            if (t.getData().toString().compareTo(keys[j]) == 0) {
                                off = WordScanner.getTokenOffset();
                                length = WordScanner.getTokenLength();
                                break;
                            }
                            ++j;
                        }
                    }
                    t = WordScanner.nextToken();
                }
                if (off >= 0) {
                    return new Position(off, length);
                }
                --i2;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return new Position(offset, 0);
    }

    public static int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        int i = offset;
        while (i < end) {
            char c = document.getChar(i);
            if (c != ' ' && c != '\t') {
                return i;
            }
            ++i;
        }
        return end;
    }

    public static boolean isEmpty(String s) {
        return s != null && s.length() == 0;
    }

    public static boolean isNonWhitespace(String s) {
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!Character.isWhitespace(chars[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void leftShift(int[] source, int value, int count, int intsize) {
        int n = source.length - 1;
        source[n] = source[n] << count;
        int k = -1 << intsize - count;
        int i = source.length - 2;
        while (i >= 0) {
            int t = k & source[i];
            int n2 = i + 1;
            source[n2] = source[n2] | (t >>>= intsize - count);
            int n3 = i--;
            source[n3] = source[n3] << count;
        }
        source[0] = source[0] | value;
    }
}

