/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.syntax;

import java.util.Hashtable;
import java.util.TreeSet;
import org.eclipse.jface.text.IDocument;
import org.mcmas.ui.syntax.Util;
import org.mcmas.ui.syntax.arithmetic_expression;
import org.mcmas.ui.syntax.basictype;
import org.mcmas.ui.syntax.bit_expression;
import org.mcmas.ui.syntax.enum_value;
import org.mcmas.ui.syntax.enumerate;
import org.mcmas.ui.syntax.expression;
import org.mcmas.ui.syntax.int_value;
import org.mcmas.ui.syntax.rangedint;
import org.mcmas.ui.syntax.variable;

public class assignment {
    variable var;
    expression var_value;

    public assignment(String name, int line, int column, expression value) {
        this.var = new variable(name, line, column);
        this.var_value = value;
    }

    public variable get_var() {
        return this.var;
    }

    public expression get_var_value() {
        return this.var_value;
    }

    public String toString() {
        return String.valueOf(this.var.toString()) + " = " + this.var_value.toString();
    }

    public String check_var_and_value(Hashtable<String, basictype> obsvars, Hashtable<String, basictype> vars, IDocument document, boolean redundant) {
        int t1;
        int right;
        int right1 = right = this.var_value.get_type();
        String vs = this.var.get_variable_name();
        basictype p = vars.get(vs);
        String errorMessage = "";
        if (redundant) {
            errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)this.var.startline, (int)this.var.startcolumn, (int)vs.length()) + "Only one assignment is allowed in SingleAssignment semantics.\n";
        }
        if (p == null) {
            return String.valueOf(errorMessage) + Util.getErrorHeader((int)this.var.startline, (int)this.var.startcolumn, (int)vs.length()) + "variable " + vs + " is not defined.\n";
        }
        this.var.set_var_type(p);
        basictype p1 = null;
        String vs1 = "";
        if (right == 0) {
            variable v2 = (variable)this.var_value;
            vs1 = v2.get_variable_name();
            if (((variable)this.var_value).is_agent_name_null()) {
                p1 = vars.get(vs1);
                if (p1 != null) {
                    right = p1.get_type();
                    ((variable)this.var_value).set_var_type(p1);
                }
            } else {
                String ag_name = ((variable)this.var_value).get_agent_name();
                if (ag_name == "Environment" && (p1 = obsvars.get(vs1)) != null) {
                    right = p1.get_type();
                    ((variable)this.var_value).set_var_type(p1);
                }
            }
        } else if (right >= 9 && right <= 12) {
            errorMessage = String.valueOf(errorMessage) + ((bit_expression)this.var_value).check_var_and_value(obsvars, vars, document);
        }
        if ((t1 = p.get_type()) != right && right < 5 && (t1 != 3 || right != 0) || t1 == 3 && right >= 5 || t1 == 1 && right >= 5 && right <= 8) {
            return String.valueOf(errorMessage) + Util.getErrorHeader((int)this.var.startline, (int)this.var.startcolumn, (int)vs.length()) + "variable " + vs + " has a wrong typed value.\n";
        }
        if (t1 == 1) {
            return errorMessage;
        }
        if (t1 == 2) {
            if (right1 == 0) {
                int ub = ((rangedint)p).get_upperbound();
                int lb = ((rangedint)p).get_lowerbound();
                int ub1 = ((rangedint)p1).get_upperbound();
                int lb1 = ((rangedint)p1).get_lowerbound();
                if (ub < lb1 || ub1 < lb) {
                    return String.valueOf(errorMessage) + Util.getErrorHeader((int)this.var.startline, (int)this.var.startcolumn, (int)vs.length()) + "variable " + vs1 + " cannot be assignment to variable " + vs + ".\n";
                }
                return errorMessage;
            }
            if (right1 == 2) {
                if (((rangedint)p).is_valid_value(((int_value)this.var_value).get_value())) {
                    return errorMessage;
                }
                return String.valueOf(errorMessage) + Util.getErrorHeader((int)this.var.startline, (int)this.var.startcolumn, (int)vs.length()) + "variable " + vs + " has a wrong integer value.\n";
            }
            return String.valueOf(errorMessage) + ((arithmetic_expression)this.var_value).check_var_and_value(obsvars, vars, document);
        }
        if (t1 == 3) {
            if (right == 0) {
                if (((enumerate)p).is_valid_value(vs1)) {
                    variable v2 = (variable)this.var_value;
                    enum_value tmp = new enum_value(new String(vs1), v2.startline, v2.startcolumn);
                    this.var_value = tmp;
                    return errorMessage;
                }
                return String.valueOf(errorMessage) + Util.getErrorHeader((int)this.var.startline, (int)this.var.startcolumn, (int)vs.length()) + "variable " + vs + " has a wrong enum value '" + vs1 + "'.\n";
            }
            TreeSet s1 = ((enumerate)p).get_enumvalue();
            TreeSet s2 = ((enumerate)p1).get_enumvalue();
            if (s1.size() == s2.size() && s2.containsAll(s1)) {
                return errorMessage;
            }
            return String.valueOf(errorMessage) + Util.getErrorHeader((int)this.var.startline, (int)this.var.startcolumn, (int)vs.length()) + "variables " + vs + " and " + vs1 + " do not have the same enumerate type.\n";
        }
        return errorMessage;
    }
}

