/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.syntax;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import org.mcmas.ui.syntax.Util;
import org.mcmas.ui.syntax.basictype;
import org.mcmas.ui.syntax.bool_expression;
import org.mcmas.ui.syntax.enumerate;
import org.mcmas.ui.syntax.evolution_line;
import org.mcmas.ui.syntax.protocol_line;
import org.mcmas.ui.syntax.rangedint;
import org.mcmas.ui.syntax.variable;

public class basic_agent {
    String name;
    Hashtable<String, variable> lobsvars;
    Hashtable<String, basictype> obsvars;
    Hashtable<String, basictype> vars;
    bool_expression redstates;
    TreeSet<String> actions;
    ArrayList<protocol_line> protocol;
    ArrayList<evolution_line> evolution;
    int action_index_begin;
    int action_index_end;
    Hashtable<String, boolean[]> action_indices;

    public basic_agent(String n, Hashtable<String, variable> lv, Hashtable<String, basictype> v0, Hashtable<String, basictype> v1, bool_expression r, TreeSet<String> v2, ArrayList<protocol_line> v3, ArrayList<evolution_line> v4) {
        this.name = n;
        this.lobsvars = lv;
        this.obsvars = v0;
        this.vars = v1;
        this.actions = v2;
        this.protocol = v3;
        this.evolution = v4;
        this.redstates = r;
        this.action_indices = new Hashtable();
        this.generate_action_bdd_value();
    }

    public String get_name() {
        if (this.name == null) {
            System.out.println(" error: name in agent is undefined!");
        }
        return this.name;
    }

    public Hashtable<String, basictype> get_obsvars() {
        return this.obsvars;
    }

    public Hashtable<String, variable> get_lobsvars() {
        return this.lobsvars;
    }

    public Hashtable<String, basictype> get_vars() {
        return this.vars;
    }

    public TreeSet<String> get_actions() {
        return this.actions;
    }

    public ArrayList<protocol_line> get_protocol() {
        return this.protocol;
    }

    public ArrayList<evolution_line> get_evolution() {
        return this.evolution;
    }

    public bool_expression get_redstates() {
        return this.redstates;
    }

    public String toString() {
        Enumeration i;
        String str = "Agent " + this.name + "\n";
        if (this.obsvars != null && this.obsvars.size() > 0) {
            str = String.valueOf(str) + "Obsvars:\n";
            i = this.obsvars.elements();
            while (i.hasMoreElements()) {
                str = String.valueOf(str) + "    " + i.nextElement() + ";\n";
            }
            str = String.valueOf(str) + "end Obsvars\n";
        }
        str = String.valueOf(str) + "Vars:\n";
        i = this.vars.elements();
        while (i.hasMoreElements()) {
            str = String.valueOf(str) + "    " + i.nextElement() + ";\n";
        }
        str = String.valueOf(str) + "end Vars\nRedStates:\n    ";
        str = this.redstates == null ? String.valueOf(str) : String.valueOf(str) + this.redstates.toString() + ";";
        str = String.valueOf(str) + "\nend RedStates\nActions = { ";
        int k = 0;
        int bound = this.actions.size() - 1;
        for (String element : this.actions) {
            str = k == bound ? String.valueOf(str) + element + " " : String.valueOf(str) + element + ", ";
            ++k;
        }
        str = String.valueOf(str) + "}\nProtocol:\n";
        int i2 = 0;
        while (i2 < this.protocol.size()) {
            str = String.valueOf(str) + "    " + ((protocol_line)this.protocol.get(i2)).toString() + ";\n";
            ++i2;
        }
        str = String.valueOf(str) + "end Protocol\nEvolution:\n";
        i2 = 0;
        while (i2 < this.evolution.size()) {
            str = String.valueOf(str) + "    " + ((evolution_line)this.evolution.get(i2)).toString() + ";\n";
            ++i2;
        }
        str = String.valueOf(str) + "end Evolution\n";
        str = String.valueOf(str) + "end Agent\n";
        return str;
    }

    public int state_BDD_length() {
        Enumeration i;
        int count = 0;
        if (this.obsvars != null) {
            i = this.obsvars.elements();
            while (i.hasMoreElements()) {
                count += ((basictype)i.nextElement()).BDD_length();
            }
        }
        if (this.vars != null) {
            i = this.vars.elements();
            while (i.hasMoreElements()) {
                count += ((basictype)i.nextElement()).BDD_length();
            }
        }
        return count;
    }

    public int actions_BDD_length() {
        if (this.actions == null || this.actions.size() == 0) {
            return 0;
        }
        return Util.log_2((int)this.actions.size());
    }

    public void set_action_index_begin(int i) {
        this.action_index_begin = i;
    }

    public void set_action_index_end(int i) {
        this.action_index_end = i;
    }

    public int get_action_index_begin() {
        return this.action_index_begin;
    }

    public int get_action_index_end() {
        return this.action_index_end;
    }

    public void generate_action_bdd_value() {
        int size = this.actions_BDD_length();
        if (size == 0) {
            return;
        }
        boolean[] base = new boolean[size];
        int i = 0;
        while (i < size) {
            base[i] = false;
            ++i;
        }
        block1: for (String element : this.actions) {
            boolean[] temp = new boolean[base.length];
            int j = 0;
            while (j < base.length) {
                temp[j] = base[j];
                ++j;
            }
            this.action_indices.put(element, temp);
            j = size - 1;
            while (j >= 0) {
                if (!base[j]) {
                    base[j] = true;
                    continue block1;
                }
                base[j] = false;
                --j;
            }
        }
    }

    public void print_value_index() {
        Enumeration i = this.action_indices.keys();
        while (i.hasMoreElements()) {
            String key = (String)i.nextElement();
            System.out.print(String.valueOf(key) + ": ");
            boolean[] value = (boolean[])this.action_indices.get(key);
            int j = 0;
            while (j < value.length) {
                System.out.print(value[j] ? 1 : 0);
                ++j;
            }
            System.out.println();
        }
    }

    public Hashtable<String, boolean[]> get_action_indices() {
        return this.action_indices;
    }

    public int allocate_BDD_2_variables(int start) {
        int l;
        basictype value;
        Enumeration i;
        int count = start;
        if (this.obsvars != null) {
            i = this.obsvars.keys();
            while (i.hasMoreElements()) {
                value = (basictype)this.obsvars.get(i.nextElement());
                l = value.BDD_length();
                value.set_index_begin(count);
                value.set_index_end(count + l - 1);
                count += l;
            }
        }
        if (this.vars != null) {
            i = this.vars.keys();
            while (i.hasMoreElements()) {
                value = (basictype)this.vars.get(i.nextElement());
                l = value.BDD_length();
                value.set_index_begin(count);
                value.set_index_end(count + l - 1);
                count += l;
            }
        }
        return count;
    }

    public int allocate_BDD_2_actions(int start) {
        this.set_action_index_begin(start);
        int end = start + this.actions_BDD_length();
        this.set_action_index_end(end - 1);
        return end;
    }

    public void print_variable_BDD_encoding() {
        basictype b;
        int end;
        int begin;
        basictype value;
        String key;
        Enumeration i;
        if (this.obsvars != null) {
            i = this.obsvars.keys();
            while (i.hasMoreElements()) {
                key = (String)i.nextElement();
                value = (basictype)this.obsvars.get(key);
                begin = value.get_index_begin();
                end = value.get_index_end();
                System.out.print("----- " + key + ": " + begin + " .. " + end + " -----");
                b = value;
                if (b.get_type() == 2) {
                    ((rangedint)b).print_value_index();
                    continue;
                }
                if (b.get_type() == 3) {
                    ((enumerate)b).print_value_index();
                    continue;
                }
                b.print_value_index();
            }
        }
        if (this.vars != null) {
            i = this.vars.keys();
            while (i.hasMoreElements()) {
                key = (String)i.nextElement();
                value = (basictype)this.vars.get(key);
                begin = value.get_index_begin();
                end = value.get_index_end();
                System.out.print("----- " + key + ": " + begin + " .. " + end + " -----");
                b = value;
                if (b.get_type() == 2) {
                    ((rangedint)b).print_value_index();
                    continue;
                }
                if (b.get_type() == 3) {
                    ((enumerate)b).print_value_index();
                    continue;
                }
                b.print_value_index();
            }
        }
    }

    public TreeSet<String> get_obs_enum_values() {
        if (this.obsvars != null) {
            TreeSet<String> tmpset = new TreeSet<String>();
            Enumeration i = this.obsvars.keys();
            while (i.hasMoreElements()) {
                basictype value = (basictype)this.obsvars.get(i.nextElement());
                if (value.get_type() != 3) continue;
                TreeSet varset = ((enumerate)value).get_enumvalue();
                tmpset.addAll(varset);
            }
            return tmpset;
        }
        return null;
    }

    public String check_var_against_enum_values(TreeSet<String> obsenum) {
        basictype bt;
        String key;
        Enumeration i;
        String errorMessage = "";
        TreeSet<String> tmpset = new TreeSet<String>();
        if (this.vars != null) {
            i = this.vars.keys();
            while (i.hasMoreElements()) {
                basictype value = (basictype)this.vars.get(i.nextElement());
                if (value.get_type() != 3) continue;
                TreeSet varset = ((enumerate)value).get_enumvalue();
                tmpset.addAll(varset);
            }
        }
        if (obsenum != null) {
            tmpset.addAll(obsenum);
        }
        if (this.obsvars != null) {
            i = this.obsvars.keys();
            while (i.hasMoreElements()) {
                key = (String)i.nextElement();
                if (!tmpset.contains(key)) continue;
                bt = (basictype)this.obsvars.get(key);
                errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)bt.line, (int)bt.column, (int)bt.name.length()) + "variable " + key + " has been used as a enumerate value.\n";
            }
        }
        if (this.vars != null) {
            i = this.vars.keys();
            while (i.hasMoreElements()) {
                key = (String)i.nextElement();
                if (!tmpset.contains(key)) continue;
                bt = (basictype)this.vars.get(key);
                errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)bt.line, (int)bt.column, (int)bt.name.length()) + "variable " + key + " has been used as a enumerate value.\n";
            }
        }
        return errorMessage;
    }

    public String check_lobsvars(Hashtable<String, basictype> envars) {
        String errorMessage = "";
        if (this.lobsvars != null && this.lobsvars.size() > 0) {
            Enumeration i = this.lobsvars.keys();
            while (i.hasMoreElements()) {
                String key = (String)i.nextElement();
                variable v = (variable)this.lobsvars.get(key);
                if (envars != null && envars.containsKey(key)) {
                    basictype bt = envars.get(key);
                    v.set_var_type(bt);
                    continue;
                }
                errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)v.agstartline, (int)v.agstartcolumn, (int)v.get_variable_name().length()) + "local observable variable " + key + " is not defined in the environment.\n";
            }
        }
        return errorMessage;
    }
}

