/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.syntax;

import java.util.Hashtable;
import org.eclipse.jface.text.IDocument;
import org.mcmas.ui.syntax.CESystem;
import org.mcmas.ui.syntax.GlobalState;
import org.mcmas.ui.syntax.Util;
import org.mcmas.ui.syntax.arithmetic_expression;
import org.mcmas.ui.syntax.basictype;
import org.mcmas.ui.syntax.bool_value;
import org.mcmas.ui.syntax.expression;
import org.mcmas.ui.syntax.variable;

public class bit_expression
extends expression {
    expression[] operands = new expression[2];

    public bit_expression(int o, expression e1, expression e2, int startline, int startcolumn, int endline, int endcolumn) {
        super(o, startline, startcolumn, endline, endcolumn);
        this.operands[0] = e1;
        this.operands[1] = e2;
    }

    public expression get_operand(int i) {
        if (i > 1) {
            System.out.println("error: bit operand " + i + " does not exist!");
        } else if (this.operands[i] == null) {
            System.out.println("error: bit operand " + i + " is undefined!");
        }
        return this.operands[i];
    }

    public String toString() {
        String opstr = "";
        int op = this.get_type();
        if (op == 0) {
            return this.operands[0].toString();
        }
        if (op == 9) {
            opstr = "&";
        } else if (op == 10) {
            opstr = "|";
        } else if (op == 11) {
            opstr = "!";
        } else if (op == 12) {
            opstr = "^";
        }
        if (op == 12) {
            return String.valueOf(opstr) + " " + this.operands[0].toString();
        }
        return String.valueOf(this.operands[0].toString()) + " " + opstr + " " + this.operands[1].toString();
    }

    public String check_var_and_value(Hashtable<String, basictype> vars, IDocument document) {
        String errorMessage = "";
        int left = this.operands[0].get_type();
        if (left == 0) {
            variable var = (variable)this.operands[0];
            String vs = var.get_variable_name();
            if (vars.containsKey(vs)) {
                basictype value = vars.get(vs);
                ((variable)this.operands[0]).set_var_type(value);
            } else {
                errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)var.startline, (int)var.startcolumn, (int)vs.length()) + "variable " + vs + " is not defined.\n";
            }
        } else if (left >= 9 && left <= 12) {
            errorMessage = String.valueOf(errorMessage) + ((bit_expression)this.operands[0]).check_var_and_value(vars, document);
        } else if (left != 1) {
            errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)this.operands[0].startline, (int)this.operands[0].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[0].startline, (int)this.operands[0].startcolumn, (int)this.operands[0].endline, (int)this.operands[0].endcolumn)) + "left hand side in " + this.toString() + " has a wrong type.\n";
        }
        if (this.type != 11) {
            int right = this.operands[1].get_type();
            if (right == 0) {
                variable var = (variable)this.operands[1];
                String vs1 = var.get_variable_name();
                if (vars.containsKey(vs1)) {
                    basictype value = vars.get(vs1);
                    ((variable)this.operands[1]).set_var_type(value);
                } else {
                    errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)var.startline, (int)var.startcolumn, (int)vs1.length()) + "variable " + vs1 + " is not defined.\n";
                }
            } else if (right >= 9 && right <= 12) {
                errorMessage = String.valueOf(errorMessage) + ((bit_expression)this.operands[1]).check_var_and_value(vars, document);
            } else if (right != 1) {
                errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)this.operands[1].endline, (int)this.operands[1].endcolumn)) + "right hand side in " + this.toString() + " has a wrong type.\n";
            }
        }
        return errorMessage;
    }

    public String check_var_and_value(Hashtable<String, basictype> obsvars, Hashtable<String, basictype> vars, IDocument document) {
        String errorMessage = "";
        int left = this.operands[0].get_type();
        if (left == 0) {
            basictype value;
            variable var = (variable)this.operands[0];
            String vs = var.get_variable_name();
            if (var.is_agent_name_null()) {
                if (vars.containsKey(vs)) {
                    value = vars.get(vs);
                    var.set_var_type(value);
                } else {
                    errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)var.startline, (int)var.startcolumn, (int)vs.length()) + "variable " + vs + " is not defined.\n";
                }
            } else if (var.get_agent_name() == "Environment") {
                if (obsvars.containsKey(vs)) {
                    value = obsvars.get(vs);
                    var.set_var_type(value);
                } else {
                    errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)var.startline, (int)var.startcolumn, (int)vs.length()) + "variable " + vs + " is not defined.\n";
                }
            } else {
                errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)var.startline, (int)var.startcolumn, (int)vs.length()) + "variable " + vs + " is not defined.\n";
            }
        } else if (left >= 9 && left <= 12) {
            errorMessage = String.valueOf(errorMessage) + ((arithmetic_expression)this.operands[0]).check_var_and_value(obsvars, vars, document);
        } else if (left != 1) {
            errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)this.operands[0].startline, (int)this.operands[0].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[0].startline, (int)this.operands[0].startcolumn, (int)this.operands[0].endline, (int)this.operands[0].endcolumn)) + "left hand side in " + this.toString() + " has a wrong type.\n";
        }
        if (this.type != 11) {
            int right = this.operands[1].get_type();
            if (right == 0) {
                variable var = (variable)this.operands[1];
                String vs = var.get_variable_name();
                if (var.is_agent_name_null()) {
                    if (vars.containsKey(vs)) {
                        basictype value = vars.get(vs);
                        var.set_var_type(value);
                    } else {
                        errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)var.startline, (int)var.startcolumn, (int)vs.length()) + " variable " + vs + " is not defined.\n";
                    }
                } else if (var.get_agent_name() == "Environment") {
                    if (obsvars.containsKey(vs)) {
                        basictype value = obsvars.get(vs);
                        var.set_var_type(value);
                    } else {
                        errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)var.startline, (int)var.startcolumn, (int)vs.length()) + "variable " + vs + " is not defined.\n";
                    }
                } else {
                    errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)var.startline, (int)var.startcolumn, (int)vs.length()) + "variable " + vs + " is not defined.\n";
                }
            } else if (right >= 9 && right <= 12) {
                errorMessage = String.valueOf(errorMessage) + ((arithmetic_expression)this.operands[1]).check_var_and_value(obsvars, vars, document);
            } else if (right != 1) {
                errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)this.operands[1].endline, (int)this.operands[1].endcolumn)) + "right hand side in " + this.toString() + " has a wrong type.\n";
            }
        }
        return errorMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String check_var_and_value1(Hashtable<String, Hashtable<String, basictype>> vars, IDocument document) {
        String ag_name;
        String vs1;
        variable var1;
        String errorMessage = "";
        int left = this.operands[0].get_type();
        if (left == 0) {
            variable var = (variable)this.operands[0];
            String vs = var.get_variable_name();
            String ag_name2 = var.get_agent_name();
            if (ag_name2 == null) {
                errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)var.startline, (int)var.startcolumn, (int)vs.length()) + "variable " + vs + " should be acompanied with an agent.\n";
            } else {
                if (!vars.containsKey(ag_name2)) return String.valueOf(Util.getErrorHeader((int)var.agstartline, (int)var.agstartcolumn, (int)ag_name2.length())) + "undefined agent " + ag_name2 + "\n";
                Hashtable<String, basictype> value = vars.get(ag_name2);
                if (value.containsKey(vs)) {
                    basictype value1 = value.get(vs);
                    var.set_var_type(value1);
                } else {
                    errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)var.startline, (int)var.startcolumn, (int)vs.length()) + "variable " + vs + " is not defined in agent " + ag_name2 + "\n";
                }
            }
        } else if (left >= 9 && left <= 12) {
            errorMessage = String.valueOf(errorMessage) + ((arithmetic_expression)this.operands[0]).check_var_and_value1(vars, document);
        } else if (left != 1) {
            errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)this.operands[0].startline, (int)this.operands[0].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[0].startline, (int)this.operands[0].startcolumn, (int)this.operands[0].endline, (int)this.operands[0].endcolumn)) + "left hand side in " + this.toString() + " has a wrong type.\n";
        }
        if (this.type == 11) return errorMessage;
        int right = this.operands[1].get_type();
        if (right == 0) {
            var1 = (variable)this.operands[1];
            vs1 = var1.get_variable_name();
            ag_name = var1.get_agent_name();
            if (ag_name == null) {
                return String.valueOf(errorMessage) + Util.getErrorHeader((int)var1.startline, (int)var1.startcolumn, (int)vs1.length()) + "variable " + vs1 + " should be acompanied with an agent.\n";
            }
        } else {
            if (right >= 9 && right <= 12) {
                return String.valueOf(errorMessage) + ((arithmetic_expression)this.operands[1]).check_var_and_value1(vars, document);
            }
            if (right == 1) return errorMessage;
            return String.valueOf(errorMessage) + Util.getErrorHeader((int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)this.operands[1].endline, (int)this.operands[1].endcolumn)) + "left hand side in " + this.toString() + " has a wrong type.\n";
        }
        if (!vars.containsKey(ag_name)) return String.valueOf(Util.getErrorHeader((int)var1.agstartline, (int)var1.agstartcolumn, (int)ag_name.length())) + "undefined agent " + ag_name + "\n";
        Hashtable<String, basictype> value = vars.get(ag_name);
        if (!value.containsKey(vs1)) return String.valueOf(errorMessage) + Util.getErrorHeader((int)var1.startline, (int)var1.startcolumn, (int)vs1.length()) + "variable " + vs1 + " is not defined in agent " + ag_name + "\n";
        basictype value1 = value.get(vs1);
        var1.set_var_type(value1);
        return errorMessage;
    }

    public boolean evaluate(String agentName, GlobalState gstate) {
        boolean rint;
        boolean lint;
        int ltype = this.operands[0].get_type();
        int rtype = this.operands[1].get_type();
        int op = this.get_type();
        if (ltype == 0) {
            variable lvar = (variable)this.operands[0];
            String agentName1 = lvar.get_agent_name();
            if (agentName1 == null || Util.isEmpty((String)agentName1)) {
                agentName1 = agentName;
            }
            bool_value lvalue = (bool_value)gstate.getValue(agentName1, lvar.get_variable_name());
            lint = lvalue.get_value();
        } else {
            lint = ltype == 1 ? ((bool_value)this.operands[0]).get_value() : ((bit_expression)this.operands[0]).evaluate(agentName, gstate);
        }
        if (rtype == 0) {
            variable rvar = (variable)this.operands[1];
            String agentName2 = rvar.get_agent_name();
            if (agentName2 == null || Util.isEmpty((String)agentName2)) {
                agentName2 = agentName;
            }
            bool_value rvalue = (bool_value)gstate.getValue(agentName2, rvar.get_variable_name());
            rint = rvalue.get_value();
        } else {
            rint = rtype == 1 ? ((bool_value)this.operands[1]).get_value() : ((bit_expression)this.operands[1]).evaluate(agentName, gstate);
        }
        if (op == 9) {
            return lint & rint;
        }
        if (op == 10) {
            return lint | rint;
        }
        if (op == 11) {
            return !lint;
        }
        return lint ^ rint;
    }

    public boolean canEvaluate(CESystem gstate) {
        int ltype = this.operands[0].get_type();
        int rtype = this.operands[1].get_type();
        boolean lcan = false;
        boolean rcan = false;
        if (ltype == 0) {
            variable lvar = (variable)this.operands[0];
            String agentName1 = lvar.get_agent_name();
            expression lvalue = gstate.getVarValue(agentName1, lvar.get_variable_name());
            if (lvalue == null) {
                return false;
            }
        } else {
            lcan = ltype == 1 ? true : ((arithmetic_expression)this.operands[0]).canEvaluate(gstate);
        }
        if (rtype == 0) {
            variable rvar = (variable)this.operands[1];
            String agentName2 = rvar.get_agent_name();
            expression rvalue = gstate.getVarValue(agentName2, rvar.get_variable_name());
            if (rvalue == null) {
                return false;
            }
        } else {
            rcan = rtype == 1 ? true : ((arithmetic_expression)this.operands[1]).canEvaluate(gstate);
        }
        return lcan && rcan;
    }

    public boolean evaluate(CESystem gstate) {
        int ltype = this.operands[0].get_type();
        int rtype = -1;
        int op = this.get_type();
        boolean lint = false;
        boolean rint = false;
        if (ltype == 0) {
            variable lvar = (variable)this.operands[0];
            String agentName1 = lvar.get_agent_name();
            bool_value lvalue = (bool_value)gstate.getVarValue(agentName1, lvar.get_variable_name());
            lint = lvalue.get_value();
        } else {
            lint = ltype == 1 ? ((bool_value)this.operands[0]).get_value() : ((bit_expression)this.operands[0]).evaluate(gstate);
        }
        if (op != 11) {
            rtype = this.operands[1].get_type();
            if (rtype == 0) {
                variable rvar = (variable)this.operands[1];
                String agentName2 = rvar.get_agent_name();
                bool_value rvalue = (bool_value)gstate.getVarValue(agentName2, rvar.get_variable_name());
                rint = rvalue.get_value();
            } else {
                rint = rtype == 1 ? ((bool_value)this.operands[1]).get_value() : ((bit_expression)this.operands[1]).evaluate(gstate);
            }
        }
        if (op == 9) {
            return lint & rint;
        }
        if (op == 10) {
            return lint | rint;
        }
        if (op == 11) {
            return !lint;
        }
        return lint ^ rint;
    }
}

