/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.syntax;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeSet;
import org.eclipse.jface.text.IDocument;
import org.mcmas.ui.syntax.CESystem;
import org.mcmas.ui.syntax.GlobalState;
import org.mcmas.ui.syntax.Util;
import org.mcmas.ui.syntax.basic_agent;
import org.mcmas.ui.syntax.basictype;
import org.mcmas.ui.syntax.laction;
import org.mcmas.ui.syntax.logic_expression;
import org.mcmas.ui.syntax.variable;

public class bool_expression {
    int op;
    Object[] operands;
    public int startline;
    public int startcolumn;
    public int endline;
    public int endcolumn;

    public bool_expression(int startline, int startcolumn, int endline, int endcolumn) {
        this.op = 4;
        this.startline = startline;
        this.startcolumn = startcolumn;
        this.endline = endline;
        this.endcolumn = endcolumn;
    }

    public bool_expression(int o, Object obj1, int startline, int startcolumn, int endline, int endcolumn) {
        this.op = o;
        this.operands = new Object[1];
        this.operands[0] = obj1;
        this.startline = startline;
        this.startcolumn = startcolumn;
        this.endline = endline;
        this.endcolumn = endcolumn;
    }

    public bool_expression(int o, Object obj1, Object obj2, int startline, int startcolumn, int endline, int endcolumn) {
        this.op = o;
        this.operands = new Object[2];
        this.operands[0] = obj1;
        this.operands[1] = obj2;
        this.startline = startline;
        this.startcolumn = startcolumn;
        this.endline = endline;
        this.endcolumn = endcolumn;
    }

    public int get_op() {
        return this.op;
    }

    public boolean is_other_branch() {
        return this.op == 4;
    }

    public Object get_operand(int i) {
        if (i > 1 || i == 1 && (this.op == 0 || this.op == 3)) {
            System.out.println("error: boolean operand " + i + " does not exist!");
        } else if (this.operands[i] == null) {
            System.out.println("error: boolean operand " + i + " is undefined!");
        }
        return this.operands[i];
    }

    public String toString() {
        if (this.op == 0) {
            return ((logic_expression)this.operands[0]).toString();
        }
        if (this.op == 1) {
            return String.valueOf(((bool_expression)this.operands[0]).toString()) + " and " + ((bool_expression)this.operands[1]).toString();
        }
        if (this.op == 2) {
            return String.valueOf(((bool_expression)this.operands[0]).toString()) + " or " + ((bool_expression)this.operands[1]).toString();
        }
        if (this.op == 3) {
            return "! " + ((bool_expression)this.operands[0]).toString();
        }
        if (this.op == 4) {
            return "Other";
        }
        if (this.op == 5) {
            return "TRUE";
        }
        if (this.op == 6) {
            return "FALSE";
        }
        return "error: should not happen.";
    }

    public String check_var_and_value(Hashtable<String, basictype> obsvars, Hashtable<String, basictype> vars, String agent_name, Hashtable<String, basic_agent> global_actions, IDocument document) {
        String tmp = this.check_null_operand();
        if (!Util.isEmpty((String)tmp)) {
            return tmp;
        }
        if (this.op == 0) {
            return ((logic_expression)this.operands[0]).check_evolution(obsvars, vars, agent_name, global_actions, document);
        }
        if (this.op == 3) {
            return ((bool_expression)this.operands[0]).check_var_and_value(obsvars, vars, agent_name, global_actions, document);
        }
        if (this.op == 1 || this.op == 2) {
            String b1 = ((bool_expression)this.operands[0]).check_var_and_value(obsvars, vars, agent_name, global_actions, document);
            String b2 = ((bool_expression)this.operands[1]).check_var_and_value(obsvars, vars, agent_name, global_actions, document);
            return String.valueOf(b1) + b2;
        }
        if (this.op == 4) {
            return "";
        }
        return String.valueOf(Util.getErrorHeader((int)0, (int)0, (int)1)) + "undefined error in " + this.toString() + ". report it to the developers.\n";
    }

    public String check_evolution(Hashtable<String, basictype> obsvars, Hashtable<String, basictype> vars, String agent_name, Hashtable<String, basic_agent> global_actions, IDocument document) {
        String tmp = this.check_null_operand();
        if (!Util.isEmpty((String)tmp)) {
            return tmp;
        }
        if (this.op == 0) {
            return ((logic_expression)this.operands[0]).check_evolution(obsvars, vars, agent_name, global_actions, document);
        }
        if (this.op == 3) {
            return ((bool_expression)this.operands[0]).check_evolution(obsvars, vars, agent_name, global_actions, document);
        }
        if (this.op == 1 || this.op == 2) {
            String b1 = ((bool_expression)this.operands[0]).check_evolution(obsvars, vars, agent_name, global_actions, document);
            String b2 = ((bool_expression)this.operands[1]).check_evolution(obsvars, vars, agent_name, global_actions, document);
            return String.valueOf(b1) + b2;
        }
        return String.valueOf(Util.getErrorHeader((int)0, (int)0, (int)1)) + "undefined error in " + this.toString() + "evolution function of Agent " + agent_name + "\n";
    }

    public String check_global_consistency(Hashtable<String, Hashtable<String, basictype>> vars, IDocument document) {
        String tmp = this.check_null_operand();
        if (!Util.isEmpty((String)tmp)) {
            return tmp;
        }
        if (this.op == 0) {
            return ((logic_expression)this.operands[0]).check_global_consistency(vars, document);
        }
        if (this.op == 3) {
            return ((bool_expression)this.operands[0]).check_global_consistency(vars, document);
        }
        if (this.op == 1 || this.op == 2) {
            String b1 = ((bool_expression)this.operands[0]).check_global_consistency(vars, document);
            String b2 = ((bool_expression)this.operands[1]).check_global_consistency(vars, document);
            return String.valueOf(b1) + b2;
        }
        return String.valueOf(Util.getErrorHeader((int)0, (int)0, (int)1)) + "undefined error in " + this.toString() + ". report it to the developers.\n";
    }

    private String check_null_operand() {
        String tmp = "";
        if (this.op == 0 || this.op == 3) {
            if (this.operands[0] == null) {
                tmp = String.valueOf(Util.getErrorHeader((int)this.startline, (int)this.startcolumn, (int)(this.endcolumn - this.startcolumn))) + "Null left boolean operand.\n";
            }
        } else if (this.op == 1 || this.op == 2) {
            if (this.operands[0] == null) {
                tmp = String.valueOf(Util.getErrorHeader((int)this.startline, (int)this.startcolumn, (int)(this.endcolumn - this.startcolumn))) + "Null left boolean operand.\n";
            }
            if (this.operands[1] == null) {
                tmp = String.valueOf(tmp) + Util.getErrorHeader((int)this.startline, (int)this.startcolumn, (int)(this.endcolumn - this.startcolumn)) + "Null right boolean operand.\n";
            }
        }
        return tmp;
    }

    bool_expression negation_down() {
        if (this.op == 0) {
            logic_expression lexpr = (logic_expression)this.get_operand(0);
            int lop = lexpr.get_operand(0).get_type();
            int rop = lexpr.get_operand(1).get_type();
            if (lop == 0 && rop == 0) {
                int lexprop = lexpr.get_op();
                int newlexprop = 0;
                switch (lexprop) {
                    case 0: {
                        newlexprop = 1;
                        break;
                    }
                    case 1: {
                        newlexprop = 0;
                        break;
                    }
                    case 2: {
                        newlexprop = 5;
                        break;
                    }
                    case 3: {
                        newlexprop = 4;
                        break;
                    }
                    case 4: {
                        newlexprop = 3;
                        break;
                    }
                    case 5: {
                        newlexprop = 2;
                    }
                }
                return new bool_expression(0, (Object)new logic_expression(newlexprop, lexpr.get_operand(0), lexpr.get_operand(1)), 0, 0, 0, 0);
            }
            return new bool_expression(3, (Object)this, 0, 0, 0, 0);
        }
        if (this.op == 3) {
            return ((bool_expression)this.operands[0]).push_negation_inside();
        }
        if (this.op == 1) {
            bool_expression b1 = ((bool_expression)this.operands[0]).negation_down();
            bool_expression b2 = ((bool_expression)this.operands[1]).negation_down();
            return new bool_expression(2, (Object)b1, (Object)b2, 0, 0, 0, 0);
        }
        bool_expression b1 = ((bool_expression)this.operands[0]).negation_down();
        bool_expression b2 = ((bool_expression)this.operands[1]).negation_down();
        return new bool_expression(1, (Object)b1, (Object)b2, 0, 0, 0, 0);
    }

    bool_expression push_negation_inside() {
        if (this.op == 0) {
            return this;
        }
        if (this.op == 3) {
            return ((bool_expression)this.operands[0]).negation_down();
        }
        bool_expression b1 = ((bool_expression)this.operands[0]).push_negation_inside();
        bool_expression b2 = ((bool_expression)this.operands[1]).push_negation_inside();
        return new bool_expression(this.op, (Object)b1, (Object)b2, 0, 0, 0, 0);
    }

    public boolean evaluate(String agentName, GlobalState gstate, Hashtable<String, String> actions) {
        if (this.op == 0) {
            return ((logic_expression)this.operands[0]).evaluate(agentName, gstate, actions);
        }
        if (this.op == 3) {
            return !((bool_expression)this.operands[0]).evaluate(agentName, gstate, actions);
        }
        if (this.op == 1) {
            if (!((bool_expression)this.operands[0]).evaluate(agentName, gstate, actions)) {
                return false;
            }
            return ((bool_expression)this.operands[1]).evaluate(agentName, gstate, actions);
        }
        if (((bool_expression)this.operands[0]).evaluate(agentName, gstate, actions)) {
            return true;
        }
        return ((bool_expression)this.operands[1]).evaluate(agentName, gstate, actions);
    }

    public boolean evaluate1(String agentName, GlobalState gstate, Hashtable<String, TreeSet<String>> actions) {
        if (this.op == 0) {
            return ((logic_expression)this.operands[0]).evaluate1(agentName, gstate, actions);
        }
        if (this.op == 3) {
            return !((bool_expression)this.operands[0]).evaluate1(agentName, gstate, actions);
        }
        if (this.op == 1) {
            if (!((bool_expression)this.operands[0]).evaluate1(agentName, gstate, actions)) {
                return false;
            }
            return ((bool_expression)this.operands[1]).evaluate1(agentName, gstate, actions);
        }
        if (((bool_expression)this.operands[0]).evaluate1(agentName, gstate, actions)) {
            return true;
        }
        return ((bool_expression)this.operands[1]).evaluate1(agentName, gstate, actions);
    }

    public boolean evaluate2(GlobalState gstate) {
        if (this.op == 0) {
            return ((logic_expression)this.operands[0]).evaluate2(gstate);
        }
        if (this.op == 3) {
            return !((bool_expression)this.operands[0]).evaluate2(gstate);
        }
        if (this.op == 1) {
            if (!((bool_expression)this.operands[0]).evaluate2(gstate)) {
                return false;
            }
            return ((bool_expression)this.operands[1]).evaluate2(gstate);
        }
        if (((bool_expression)this.operands[0]).evaluate2(gstate)) {
            return true;
        }
        return ((bool_expression)this.operands[1]).evaluate2(gstate);
    }

    public boolean evaluate3(CESystem gstate) {
        if (this.op == 0) {
            return ((logic_expression)this.operands[0]).evaluate3(gstate);
        }
        if (this.op == 3) {
            return !((bool_expression)this.operands[0]).evaluate3(gstate);
        }
        if (this.op == 1) {
            if (!((bool_expression)this.operands[0]).evaluate3(gstate)) {
                return false;
            }
            return ((bool_expression)this.operands[1]).evaluate3(gstate);
        }
        if (((bool_expression)this.operands[0]).evaluate3(gstate)) {
            return true;
        }
        return ((bool_expression)this.operands[1]).evaluate3(gstate);
    }

    public void getSynchronizedActions(String agname, ArrayList<logic_expression> synActions) {
        if (this.op == 0) {
            logic_expression l = (logic_expression)this.operands[0];
            int left = l.operands[0].get_type();
            if (left == 4) {
                synActions.add(l);
            }
        }
        if (this.op == 1) {
            bool_expression b1 = (bool_expression)this.operands[0];
            bool_expression b2 = (bool_expression)this.operands[1];
            b1.getSynchronizedActions(agname, synActions);
            b2.getSynchronizedActions(agname, synActions);
        }
    }

    public void getDependentAgents(String agname, TreeSet<String> depAgents) {
        bool_expression b1;
        if (this.op == 0) {
            String str;
            logic_expression l = (logic_expression)this.operands[0];
            int left = l.operands[0].get_type();
            if (left == 4) {
                String str2 = ((laction)l.operands[0]).get_agent_name();
                if (str2.compareTo(agname) != 0) {
                    depAgents.add(str2);
                }
            } else if (left == 0 && (str = ((variable)l.operands[0]).get_agent_name()) != null && str.compareTo(agname) != 0) {
                depAgents.add(str);
            }
        }
        if (this.op == 1 || this.op == 2) {
            b1 = (bool_expression)this.operands[0];
            bool_expression b2 = (bool_expression)this.operands[1];
            b1.getDependentAgents(agname, depAgents);
            b2.getDependentAgents(agname, depAgents);
        }
        if (this.op == 3) {
            b1 = (bool_expression)this.operands[0];
            b1.getDependentAgents(agname, depAgents);
        }
    }
}

