/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.syntax;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeSet;
import org.eclipse.jface.text.IDocument;
import org.mcmas.ui.syntax.CESystem;
import org.mcmas.ui.syntax.GlobalState;
import org.mcmas.ui.syntax.Util;
import org.mcmas.ui.syntax.arithmetic_expression;
import org.mcmas.ui.syntax.basic_agent;
import org.mcmas.ui.syntax.basictype;
import org.mcmas.ui.syntax.bit_expression;
import org.mcmas.ui.syntax.bool_value;
import org.mcmas.ui.syntax.enum_value;
import org.mcmas.ui.syntax.enumerate;
import org.mcmas.ui.syntax.expression;
import org.mcmas.ui.syntax.int_value;
import org.mcmas.ui.syntax.laction;
import org.mcmas.ui.syntax.rangedint;
import org.mcmas.ui.syntax.variable;

public class logic_expression {
    int op;
    expression[] operands;
    public int opStartline;
    public int opStartcolumn;
    public int opLength;

    public logic_expression(int o, expression e1, expression e2, int opStartline, int opStartcolumn, int opLength) {
        this.op = o;
        this.operands = new expression[2];
        this.operands[0] = e1;
        this.operands[1] = e2;
        this.opStartline = opStartline;
        this.opStartcolumn = opStartcolumn;
        this.opLength = opLength;
    }

    public logic_expression(int o, expression e1, expression e2) {
        this.op = o;
        this.operands = new expression[2];
        this.operands[0] = e1;
        this.operands[1] = e2;
        this.opStartline = 0;
        this.opStartcolumn = 0;
        this.opLength = 0;
    }

    int get_op() {
        return this.op;
    }

    public expression get_operand(int i) {
        if (i > 1) {
            System.out.println("error: logic operand " + i + " does not exist!");
        } else if (this.operands[i] == null) {
            System.out.println("error: logic operand " + i + " is undefined!");
        }
        return this.operands[i];
    }

    public String toString() {
        String opstr = "";
        if (this.op == 0) {
            opstr = "=";
        } else if (this.op == 1) {
            opstr = "<>";
        } else if (this.op == 2) {
            opstr = "<";
        } else if (this.op == 3) {
            opstr = "<=";
        } else if (this.op == 4) {
            opstr = ">";
        } else if (this.op == 5) {
            opstr = ">=";
        }
        return String.valueOf(this.operands[0].toString()) + opstr + this.operands[1].toString();
    }

    public String check_var_and_value(Hashtable<String, basictype> vars, IDocument document) {
        int left = this.operands[0].get_type();
        int right = this.operands[1].get_type();
        boolean left_var = true;
        boolean right_var = true;
        if (left == 0) {
            variable v1 = (variable)this.operands[0];
            String vs = v1.get_variable_name();
            basictype p = null;
            if (vars.containsKey(vs)) {
                p = vars.get(vs);
            } else {
                left_var = false;
            }
            if (right == 0) {
                variable v2 = (variable)this.operands[1];
                String vs1 = v2.get_variable_name();
                basictype p1 = null;
                if (vars.containsKey(vs1)) {
                    p1 = vars.get(vs1);
                } else {
                    right_var = false;
                }
                if (left_var && right_var) {
                    int t2;
                    int t1 = p.get_type();
                    if (t1 == (t2 = p1.get_type())) {
                        if (t1 == 3) {
                            if (this.op != 0 && this.op != 1) {
                                return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                            }
                            TreeSet s1 = ((enumerate)p).get_enumvalue();
                            TreeSet s2 = ((enumerate)p1).get_enumvalue();
                            if (s1.size() == s2.size() && s2.containsAll(s1)) {
                                ((variable)this.operands[0]).set_var_type(p);
                                ((variable)this.operands[1]).set_var_type(p1);
                                return "";
                            }
                            return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " and " + vs1 + " do not have the same enumeration type.\n";
                        }
                        if (t1 == 1 && this.op != 0 && this.op != 1) {
                            return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                        }
                        ((variable)this.operands[0]).set_var_type(p);
                        ((variable)this.operands[1]).set_var_type(p1);
                        return "";
                    }
                    return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " and " + vs1 + " have different type.\n";
                }
                if (left_var && !right_var) {
                    if (this.op != 0 && this.op != 1) {
                        return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                    }
                    int t1 = p.get_type();
                    if (t1 == 3) {
                        TreeSet s1 = ((enumerate)p).get_enumvalue();
                        if (s1.contains(vs1)) {
                            ((variable)this.operands[0]).set_var_type(p);
                            this.operands[1] = new enum_value(new String(vs1), this.operands[1].startline, this.operands[1].startcolumn);
                            return "";
                        }
                        return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " does not have the value " + vs1 + "\n";
                    }
                    return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " must have an enumeration type.\n";
                }
                if (!left_var && right_var) {
                    if (this.op != 0 && this.op != 1) {
                        return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                    }
                    int t2 = p1.get_type();
                    if (t2 == 3) {
                        TreeSet s2 = ((enumerate)p1).get_enumvalue();
                        if (s2.contains(vs)) {
                            ((variable)this.operands[1]).set_var_type(p1);
                            this.operands[0] = new enum_value(new String(vs), this.operands[0].startline, this.operands[0].startcolumn);
                            return "";
                        }
                        return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " does not have the value " + vs + "\n";
                    }
                    return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " must have an enumeration type.\n";
                }
                return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " or " + vs1 + " must be a variable.\n";
            }
            if (left_var) {
                left = p.get_type();
                if (right == 1) {
                    if (left != 1) {
                        return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " in " + this.toString() + " is not a Boolean variable.\n";
                    }
                    if (this.op == 0 || this.op == 1) {
                        ((variable)this.operands[0]).set_var_type(p);
                        return "";
                    }
                    return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                }
                if (right == 2) {
                    if (left != 2) {
                        return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " in " + this.toString() + " is not a bounded integer variable.\n";
                    }
                    ((variable)this.operands[0]).set_var_type(p);
                    return "";
                }
                if (right == 3) {
                    if (left != 3) {
                        return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " in " + this.toString() + " is not an enumeration variable.\n";
                    }
                    if (this.op == 0 || this.op == 1) {
                        String vs1 = ((enum_value)this.operands[1]).get_value();
                        TreeSet s1 = ((enumerate)p).get_enumvalue();
                        if (s1.contains(vs1)) {
                            ((variable)this.operands[0]).set_var_type(p);
                            return "";
                        }
                        return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " does not have the value " + vs1 + "\n";
                    }
                    return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                }
                if (right >= 5 && right <= 8) {
                    String opstr;
                    String string = opstr = this.op > 1 ? String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n" : "";
                    if (left == 2) {
                        String str = ((arithmetic_expression)this.operands[1]).check_var_and_value(vars, document);
                        if (Util.isEmpty((String)str)) {
                            ((variable)this.operands[0]).set_var_type(p);
                            return String.valueOf(opstr);
                        }
                        return String.valueOf(opstr) + str + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " does not have integer type or " + ((arithmetic_expression)this.operands[1]).toString() + " is not a correct arithmetic expression.\n";
                    }
                    return String.valueOf(opstr) + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " does not have integer type or " + ((arithmetic_expression)this.operands[1]).toString() + " is not a correct arithmetic expression.\n";
                }
                if (left == 1) {
                    String str = ((bit_expression)this.operands[1]).check_var_and_value(vars, document);
                    if (Util.isEmpty((String)str)) {
                        ((variable)this.operands[0]).set_var_type(p);
                        return "";
                    }
                    return String.valueOf(str) + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " does not have boolean type or " + ((bit_expression)this.operands[1]).toString() + " is not a correct bit expression.\n";
                }
                return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " does not have boolean type or " + ((bit_expression)this.operands[1]).toString() + " is not a correct bit expression.\n";
            }
            return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " must be a variable.\n";
        }
        if (right == 0) {
            variable v2 = (variable)this.operands[1];
            String vs1 = v2.get_variable_name();
            basictype p1 = vars.get(vs1);
            if (p1 != null) {
                String opstr;
                right = p1.get_type();
                if (left == 1) {
                    if (right != 1) {
                        return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " in " + this.toString() + " is not a Boolean variable.\n";
                    }
                    if (this.op == 0 || this.op == 1) {
                        ((variable)this.operands[1]).set_var_type(p1);
                        return "";
                    }
                    return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                }
                if (left == 2) {
                    if (right != 2) {
                        return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " in " + this.toString() + " is not a Boolean variable.\n";
                    }
                    ((variable)this.operands[1]).set_var_type(p1);
                    return "";
                }
                if (left == 3) {
                    if (right != 3) {
                        return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " in " + this.toString() + " is not a Boolean variable.\n";
                    }
                    if (this.op == 0 || this.op == 1) {
                        String vs = ((enum_value)this.operands[0]).get_value();
                        TreeSet s2 = ((enumerate)p1).get_enumvalue();
                        if (s2.contains(vs)) {
                            ((variable)this.operands[1]).set_var_type(p1);
                            return "";
                        }
                        return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " does not have the value " + vs + "\n";
                    }
                    return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                }
                if (left >= 5 && left <= 8) {
                    if (right == 2) {
                        String str = ((arithmetic_expression)this.operands[0]).check_var_and_value(vars, document);
                        if (Util.isEmpty((String)str)) {
                            ((variable)this.operands[1]).set_var_type(p1);
                            return "";
                        }
                        return String.valueOf(str) + Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length()) + vs1 + " does not have integer type or " + ((arithmetic_expression)this.operands[0]).toString() + " is not a correct arithmetic expression.\n";
                    }
                    return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " does not have integer type or " + ((arithmetic_expression)this.operands[0]).toString() + " is not a correct arithmetic expression.\n";
                }
                String string = opstr = this.op > 1 ? String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n" : "";
                if (right == 1) {
                    String str = ((bit_expression)this.operands[0]).check_var_and_value(vars, document);
                    if (Util.isEmpty((String)str)) {
                        ((variable)this.operands[1]).set_var_type(p1);
                        return String.valueOf(opstr);
                    }
                    return String.valueOf(opstr) + str + Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length()) + vs1 + " does not have boolean type or " + ((bit_expression)this.operands[0]).toString() + " is not a correct bit expression.\n";
                }
                return String.valueOf(opstr) + Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length()) + vs1 + " does not have boolean type or " + ((bit_expression)this.operands[0]).toString() + " is not a correct bit expression.\n";
            }
            return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " must be a variable.\n";
        }
        if (left >= 5 && left <= 8) {
            if (right == 2) {
                return ((arithmetic_expression)this.operands[0]).check_var_and_value(vars, document);
            }
            if (right >= 5 && right <= 8) {
                return String.valueOf(((arithmetic_expression)this.operands[0]).check_var_and_value(vars, document)) + ((arithmetic_expression)this.operands[1]).check_var_and_value(vars, document);
            }
            return String.valueOf(Util.getErrorHeader((int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)this.operands[1].endline, (int)this.operands[1].endcolumn))) + "right hand side in " + this.toString() + " has a wrong type.\n";
        }
        if (right >= 5 && right <= 8) {
            if (left == 2) {
                return ((arithmetic_expression)this.operands[1]).check_var_and_value(vars, document);
            }
            return String.valueOf(Util.getErrorHeader((int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)this.operands[1].endline, (int)this.operands[1].endcolumn))) + "left hand side in " + this.toString() + " has a wrong type.\n";
        }
        if (left >= 9 && left <= 12) {
            String opstr;
            String string = opstr = this.op > 1 ? String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n" : "";
            if (right == 1) {
                return String.valueOf(opstr) + ((arithmetic_expression)this.operands[0]).check_var_and_value(vars, document);
            }
            if (right >= 9 && right <= 12) {
                return String.valueOf(opstr) + ((arithmetic_expression)this.operands[0]).check_var_and_value(vars, document) + ((arithmetic_expression)this.operands[1]).check_var_and_value(vars, document);
            }
            return String.valueOf(Util.getErrorHeader((int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)this.operands[1].endline, (int)this.operands[1].endcolumn))) + "right hand side in " + this.toString() + " has a wrong type.\n";
        }
        if (right >= 9 && right <= 12) {
            String opstr;
            String string = opstr = this.op > 1 ? String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n" : "";
            if (left == 1) {
                return String.valueOf(opstr) + ((arithmetic_expression)this.operands[1]).check_var_and_value(vars, document);
            }
            return String.valueOf(opstr) + Util.getErrorHeader((int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)this.operands[1].endline, (int)this.operands[1].endcolumn)) + "left hand side in " + this.toString() + " has a wrong type.\n";
        }
        return String.valueOf(Util.getErrorHeader((int)this.operands[0].startline, (int)this.operands[0].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[0].startline, (int)this.operands[0].startcolumn, (int)this.operands[1].endline, (int)this.operands[1].endcolumn))) + "wrong logic expression " + this.toString() + "\n";
    }

    public String check_evolution(Hashtable<String, basictype> obsvars, Hashtable<String, basictype> vars, String agent_name, Hashtable<String, basic_agent> global_actions, IDocument document) {
        int left = this.operands[0].get_type();
        int right = this.operands[1].get_type();
        boolean left_var = true;
        boolean right_var = true;
        if (left == 4) {
            String act_name = ((variable)this.operands[1]).get_variable_name();
            boolean f = ((laction)this.operands[0]).is_agent_name_null();
            String ag_name = f ? agent_name : ((laction)this.operands[0]).get_agent_name();
            basic_agent p = global_actions.get(ag_name);
            if (p == null) {
                if (f) {
                    return String.valueOf(Util.getErrorHeader((int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)act_name.length())) + "action " + act_name + " is not found in agent " + ag_name + "\n";
                }
                laction la = (laction)this.operands[0];
                return String.valueOf(Util.getErrorHeader((int)la.agstartline, (int)la.agstartcolumn, (int)ag_name.length())) + "agent " + ag_name + " is not defined.\n";
            }
            if (f) {
                ((laction)this.operands[0]).set_agent_name(new String(agent_name));
                ((laction)this.operands[0]).set_agent(p);
            } else {
                ((laction)this.operands[0]).set_agent(p);
            }
            TreeSet acts = p.get_actions();
            if (!acts.contains(act_name)) {
                return String.valueOf(Util.getErrorHeader((int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)act_name.length())) + "action " + act_name + " is not found in agent " + ag_name + "\n";
            }
            return "";
        }
        if (left == 0) {
            variable v1 = (variable)this.operands[0];
            String vs = v1.get_variable_name();
            basictype p = null;
            if (v1.is_agent_name_null()) {
                p = vars.get(vs);
                if (p == null) {
                    left_var = false;
                }
            } else {
                p = obsvars.get(vs);
                if (p == null) {
                    left_var = false;
                }
            }
            if (right == 0) {
                basictype p1;
                variable v2 = (variable)this.operands[1];
                String vs1 = v2.get_variable_name();
                if (v2.is_agent_name_null()) {
                    p1 = vars.get(vs1);
                    if (p1 == null) {
                        right_var = false;
                    }
                } else {
                    p1 = obsvars.get(vs1);
                    if (p1 == null) {
                        right_var = false;
                    }
                }
                if (left_var && right_var) {
                    int t2;
                    int t1 = p.get_type();
                    if (t1 == (t2 = p1.get_type())) {
                        if (t1 == 3) {
                            if (this.op != 0 && this.op != 1) {
                                return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                            }
                            TreeSet s1 = ((enumerate)p).get_enumvalue();
                            TreeSet s2 = ((enumerate)p1).get_enumvalue();
                            if (s2.containsAll(s1) || s1.containsAll(s2)) {
                                ((variable)this.operands[0]).set_var_type(p);
                                ((variable)this.operands[1]).set_var_type(p1);
                                return "";
                            }
                            return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " and " + vs1 + " do not have the same enumeration type.\n";
                        }
                        if (t1 == 1 && this.op != 0 && this.op != 1) {
                            return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                        }
                        ((variable)this.operands[0]).set_var_type(p);
                        ((variable)this.operands[1]).set_var_type(p1);
                        return "";
                    }
                    return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " and " + vs1 + " have different type.\n";
                }
                if (left_var && !right_var) {
                    if (this.op != 0 && this.op != 1) {
                        return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                    }
                    int t1 = p.get_type();
                    if (t1 == 3) {
                        TreeSet s1 = ((enumerate)p).get_enumvalue();
                        if (s1.contains(vs1)) {
                            ((variable)this.operands[0]).set_var_type(p);
                            this.operands[1] = new enum_value(new String(vs1), this.operands[1].startline, this.operands[1].startcolumn);
                            return "";
                        }
                        return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " does not have the value " + vs1 + "\n";
                    }
                    return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " must have an enumeration type.\n";
                }
                if (!left_var && right_var) {
                    if (this.op != 0 && this.op != 1) {
                        return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                    }
                    int t2 = p1.get_type();
                    if (t2 == 3) {
                        TreeSet s2 = ((enumerate)p1).get_enumvalue();
                        if (s2.contains(vs)) {
                            ((variable)this.operands[1]).set_var_type(p1);
                            this.operands[0] = new enum_value(new String(vs), this.operands[0].startline, this.operands[0].startcolumn);
                            return "";
                        }
                        return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " does not have the value " + vs + "\n";
                    }
                    return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " must have an enumeration type.\n";
                }
                return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " or " + vs1 + " must be a variable.\n";
            }
            if (left_var) {
                String opstr;
                left = p.get_type();
                if (right == 1) {
                    if (left != 1) {
                        return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " in " + this.toString() + " is not a Boolean variable.\n";
                    }
                    if (this.op == 0 || this.op == 1) {
                        ((variable)this.operands[0]).set_var_type(p);
                        return "";
                    }
                    return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                }
                if (right == 2) {
                    if (left != 2) {
                        return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " in " + this.toString() + " is not a bounded integer variable.\n";
                    }
                    int value = ((int_value)this.operands[1]).get_value();
                    if (!((rangedint)p).is_valid_value(value)) {
                        return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " in " + this.toString() + " does not have value " + value + ".\n";
                    }
                    ((variable)this.operands[0]).set_var_type(p);
                    return "";
                }
                if (right == 3) {
                    if (left != 3) {
                        return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " in " + this.toString() + " is not an enumeration variable.\n";
                    }
                    if (this.op == 0 || this.op == 1) {
                        String vs1 = ((enum_value)this.operands[1]).get_value();
                        TreeSet s1 = ((enumerate)p).get_enumvalue();
                        if (s1.contains(vs1)) {
                            ((variable)this.operands[0]).set_var_type(p);
                            return "";
                        }
                        return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " does not have the value " + vs1 + "\n";
                    }
                    return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                }
                if (right >= 5 && right <= 8) {
                    if (p.get_type() == 2) {
                        String str = ((arithmetic_expression)this.operands[1]).check_var_and_value(obsvars, vars, document);
                        if (Util.isEmpty((String)str)) {
                            ((variable)this.operands[0]).set_var_type(p);
                            return "";
                        }
                        return String.valueOf(str) + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " does not have integer type or " + ((arithmetic_expression)this.operands[1]).toString() + " is not a correct arithmetic expression.\n";
                    }
                    return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " does not have integer type or " + ((arithmetic_expression)this.operands[1]).toString() + " is not a correct arithmetic expression.\n";
                }
                String string = opstr = this.op > 1 ? String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n" : "";
                if (left == 1) {
                    String str = ((bit_expression)this.operands[1]).check_var_and_value(obsvars, vars, document);
                    if (Util.isEmpty((String)str)) {
                        ((variable)this.operands[0]).set_var_type(p);
                        return String.valueOf(opstr);
                    }
                    return String.valueOf(opstr) + str + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " does not have boolean type or " + ((bit_expression)this.operands[1]).toString() + " is not a correct bit expression.\n";
                }
                return String.valueOf(opstr) + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " does not have boolean type or " + ((bit_expression)this.operands[1]).toString() + " is not a correct bit expression.\n";
            }
            return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " must be a variable.\n";
        }
        if (right == 0) {
            variable v2 = (variable)this.operands[1];
            String vs1 = ((variable)this.operands[1]).get_variable_name();
            basictype p1 = null;
            if (v2.is_agent_name_null()) {
                p1 = vars.get(vs1);
                if (p1 == null) {
                    right_var = false;
                }
            } else {
                p1 = obsvars.get(vs1);
                if (p1 == null) {
                    right_var = false;
                }
            }
            if (right_var) {
                String opstr;
                right = p1.get_type();
                if (left == 1) {
                    if (right != 1) {
                        return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " in " + this.toString() + " is not a Boolean variable.\n";
                    }
                    if (this.op == 0 || this.op == 1) {
                        ((variable)this.operands[1]).set_var_type(p1);
                        return "";
                    }
                    return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                }
                if (left == 2) {
                    if (right != 2) {
                        return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " in " + this.toString() + " is not a Boolean variable.\n";
                    }
                    int value = ((int_value)this.operands[1]).get_value();
                    if (!((rangedint)p1).is_valid_value(value)) {
                        return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " in " + this.toString() + " does not have value " + value + ".\n";
                    }
                    ((variable)this.operands[1]).set_var_type(p1);
                    return "";
                }
                if (left == 3) {
                    if (right != 3) {
                        return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " in " + this.toString() + " is not an enumeration variable.\n";
                    }
                    if (this.op == 0 || this.op == 1) {
                        String vs = ((enum_value)this.operands[0]).get_value();
                        TreeSet s2 = ((enumerate)p1).get_enumvalue();
                        if (s2.contains(vs)) {
                            ((variable)this.operands[1]).set_var_type(p1);
                            return "";
                        }
                        return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " does not have the value " + vs + "\n";
                    }
                    return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                }
                if (left >= 5 && left <= 8) {
                    if (p1.get_type() == 2) {
                        String str = ((arithmetic_expression)this.operands[0]).check_var_and_value(obsvars, vars, document);
                        if (Util.isEmpty((String)str)) {
                            ((variable)this.operands[1]).set_var_type(p1);
                            return "";
                        }
                        return String.valueOf(str) + Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length()) + vs1 + " does not have integer type or " + ((arithmetic_expression)this.operands[1]).toString() + " is not a correct arithmetic expression.\n";
                    }
                    return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " does not have integer type or " + ((arithmetic_expression)this.operands[0]).toString() + " is not a correct arithmetic expression.\n";
                }
                String string = opstr = this.op > 1 ? String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n" : "";
                if (right == 1) {
                    String str = ((bit_expression)this.operands[0]).check_var_and_value(obsvars, vars, document);
                    if (Util.isEmpty((String)str)) {
                        ((variable)this.operands[1]).set_var_type(p1);
                        return String.valueOf(opstr);
                    }
                    return String.valueOf(opstr) + str + Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length()) + vs1 + " does not have boolean type or " + ((bit_expression)this.operands[0]).toString() + " is not a correct bit expression.\n";
                }
                return String.valueOf(opstr) + Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length()) + vs1 + " does not have boolean type or " + ((bit_expression)this.operands[0]).toString() + " is not a correct bit expression.\n";
            }
            return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " must be a variable.\n";
        }
        if (left >= 5 && left <= 8) {
            if (right == 2) {
                return ((arithmetic_expression)this.operands[0]).check_var_and_value(obsvars, vars, document);
            }
            if (right >= 5 && right <= 8) {
                return String.valueOf(((arithmetic_expression)this.operands[0]).check_var_and_value(obsvars, vars, document)) + ((arithmetic_expression)this.operands[1]).check_var_and_value(obsvars, vars, document);
            }
            return String.valueOf(Util.getErrorHeader((int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)this.operands[1].endline, (int)this.operands[1].endcolumn))) + "right hand side in " + this.toString() + " has a wrong type.\n";
        }
        if (right >= 5 && right <= 8) {
            if (left == 2) {
                return ((arithmetic_expression)this.operands[1]).check_var_and_value(obsvars, vars, document);
            }
            return String.valueOf(Util.getErrorHeader((int)this.operands[0].startline, (int)this.operands[0].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[0].startline, (int)this.operands[0].startcolumn, (int)this.operands[0].endline, (int)this.operands[0].endcolumn))) + "left hand side in " + this.toString() + " has a wrong type.\n";
        }
        if (left >= 9 && left <= 12) {
            String opstr;
            String string = opstr = this.op > 1 ? String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n" : "";
            if (right == 1) {
                return String.valueOf(opstr) + ((arithmetic_expression)this.operands[0]).check_var_and_value(obsvars, vars, document);
            }
            if (right >= 9 && right <= 12) {
                return String.valueOf(opstr) + ((arithmetic_expression)this.operands[0]).check_var_and_value(obsvars, vars, document) + ((arithmetic_expression)this.operands[1]).check_var_and_value(obsvars, vars, document);
            }
            return String.valueOf(opstr) + Util.getErrorHeader((int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)this.operands[1].endline, (int)this.operands[1].endcolumn)) + "right hand side in " + this.toString() + " has a wrong type.\n";
        }
        if (right >= 9 && right <= 12) {
            String opstr;
            String string = opstr = this.op > 1 ? String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n" : "";
            if (left == 1) {
                return String.valueOf(opstr) + ((arithmetic_expression)this.operands[1]).check_var_and_value(obsvars, vars, document);
            }
            return String.valueOf(opstr) + Util.getErrorHeader((int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)this.operands[1].endline, (int)this.operands[1].endcolumn)) + "left hand side in " + this.toString() + " has a wrong type.\n";
        }
        return String.valueOf(Util.getErrorHeader((int)this.operands[0].startline, (int)this.operands[0].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[0].startline, (int)this.operands[0].startcolumn, (int)this.operands[1].endline, (int)this.operands[1].endcolumn))) + "illegal logic expression: " + this.toString() + ".\n";
    }

    public String check_global_consistency(Hashtable<String, Hashtable<String, basictype>> vars, IDocument document) {
        int left = this.operands[0].get_type();
        int right = this.operands[1].get_type();
        boolean left_var = true;
        boolean right_var = true;
        String errorMessage = "";
        if (left == 0) {
            variable v1 = (variable)this.operands[0];
            String vs = v1.get_variable_name();
            boolean left_defined = true;
            basictype p = null;
            if (v1.is_agent_name_null()) {
                left_var = false;
            } else {
                String ag_name = v1.get_agent_name();
                Hashtable<String, basictype> gp = vars.get(ag_name);
                if (gp == null) {
                    errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)v1.agstartline, (int)v1.agstartcolumn, (int)ag_name.length()) + "undefined agent " + ag_name + "\n";
                    left_defined = false;
                } else {
                    p = gp.get(vs);
                    if (p == null) {
                        errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + "variable " + vs + " is not defined in agent " + ag_name + "\n";
                        left_defined = false;
                    }
                }
            }
            if (right == 0) {
                variable v2 = (variable)this.operands[1];
                String vs1 = v2.get_variable_name();
                boolean right_defined = true;
                basictype p1 = null;
                if (v2.is_agent_name_null()) {
                    right_var = false;
                } else {
                    String ag_name = v2.get_agent_name();
                    Hashtable<String, basictype> gp = vars.get(ag_name);
                    if (gp == null) {
                        errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)v2.agstartline, (int)v2.agstartcolumn, (int)ag_name.length()) + "undefined agent " + ag_name + "\n";
                        right_defined = false;
                    } else {
                        p1 = gp.get(vs1);
                        if (p1 == null) {
                            errorMessage = String.valueOf(errorMessage) + Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length()) + "variable " + vs1 + " is not defined in agent " + ag_name + "\n";
                            right_defined = false;
                        }
                    }
                }
                if (!left_defined || !right_defined) {
                    return errorMessage;
                }
                if (left_var && right_var) {
                    int t2;
                    int t1 = p.get_type();
                    if (t1 == (t2 = p1.get_type())) {
                        if (t1 == 3) {
                            if (this.op != 0 && this.op != 1) {
                                return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                            }
                            TreeSet s1 = ((enumerate)p).get_enumvalue();
                            TreeSet s2 = ((enumerate)p1).get_enumvalue();
                            if (s2.containsAll(s1) || s1.containsAll(s2)) {
                                ((variable)this.operands[0]).set_var_type(p);
                                ((variable)this.operands[1]).set_var_type(p1);
                                return errorMessage;
                            }
                            return String.valueOf(errorMessage) + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " and " + vs1 + " do not have the same enumeration type.\n";
                        }
                        if (t1 == 1 && this.op != 0 && this.op != 1) {
                            return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                        }
                        ((variable)this.operands[0]).set_var_type(p);
                        ((variable)this.operands[1]).set_var_type(p1);
                        return errorMessage;
                    }
                    return String.valueOf(errorMessage) + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " and " + vs1 + " have different type.\n";
                }
                if (left_var && !right_var) {
                    if (this.op != 0 && this.op != 1) {
                        return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                    }
                    int t1 = p.get_type();
                    if (t1 == 3) {
                        TreeSet s1 = ((enumerate)p).get_enumvalue();
                        if (s1.contains(vs1)) {
                            ((variable)this.operands[0]).set_var_type(p);
                            this.operands[1] = new enum_value(new String(vs1), this.operands[1].startline, this.operands[1].startcolumn);
                            return errorMessage;
                        }
                        return String.valueOf(errorMessage) + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " does not have the value " + vs1 + "\n";
                    }
                    return String.valueOf(errorMessage) + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " must have an enumeration type.\n";
                }
                if (!left_var && right_var) {
                    if (this.op != 0 && this.op != 1) {
                        return String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                    }
                    int t2 = p1.get_type();
                    if (t2 == 3) {
                        TreeSet s2 = ((enumerate)p1).get_enumvalue();
                        if (s2.contains(vs)) {
                            ((variable)this.operands[1]).set_var_type(p1);
                            this.operands[0] = new enum_value(new String(vs), this.operands[0].startline, this.operands[0].startcolumn);
                            return errorMessage;
                        }
                        return String.valueOf(errorMessage) + Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length()) + vs1 + " does not have the value " + vs + "\n";
                    }
                    return String.valueOf(errorMessage) + Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length()) + vs1 + " must have an enumeration type.\n";
                }
                return String.valueOf(errorMessage) + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " or " + vs1 + " must be a variable.\n";
            }
            if (left_var) {
                String opstr;
                if (!left_defined) {
                    return errorMessage;
                }
                left = p.get_type();
                if (right == 1) {
                    if (left != 1) {
                        return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " in " + this.toString() + " is not a Boolean variable.\n";
                    }
                    if (this.op == 0 || this.op == 1) {
                        ((variable)this.operands[0]).set_var_type(p);
                        return errorMessage;
                    }
                    return String.valueOf(errorMessage) + Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                }
                if (right == 2) {
                    if (left != 2) {
                        return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " in " + this.toString() + " is not a bounded integer variable.\n";
                    }
                    int value = ((int_value)this.operands[1]).get_value();
                    if (!((rangedint)p).is_valid_value(value)) {
                        return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " in " + this.toString() + " does not have value " + value + ".\n";
                    }
                    ((variable)this.operands[0]).set_var_type(p);
                    return errorMessage;
                }
                if (right == 3) {
                    if (left != 3) {
                        return String.valueOf(Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length())) + vs + " in " + this.toString() + " is not an enumeration variable.\n";
                    }
                    if (this.op == 0 || this.op == 1) {
                        String vs1 = ((enum_value)this.operands[1]).get_value();
                        TreeSet s1 = ((enumerate)p).get_enumvalue();
                        if (s1.contains(vs1)) {
                            ((variable)this.operands[0]).set_var_type(p);
                            return errorMessage;
                        }
                        return String.valueOf(errorMessage) + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " does not have the value " + vs1 + "\n";
                    }
                    return String.valueOf(errorMessage) + Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                }
                if (right >= 5 && right <= 8) {
                    if (p.get_type() == 2) {
                        String str = ((arithmetic_expression)this.operands[1]).check_var_and_value1(vars, document);
                        if (Util.isEmpty((String)str)) {
                            ((variable)this.operands[0]).set_var_type(p);
                            return errorMessage;
                        }
                        return String.valueOf(errorMessage) + str + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " does not have integer type or " + ((arithmetic_expression)this.operands[1]).toString() + " is not a correct arithmetic expression.\n";
                    }
                    return String.valueOf(errorMessage) + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " does not have integer type or " + ((arithmetic_expression)this.operands[1]).toString() + " is not a correct arithmetic expression.\n";
                }
                String string = opstr = this.op > 1 ? String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n" : "";
                if (left == 1) {
                    String str = ((bit_expression)this.operands[1]).check_var_and_value1(vars, document);
                    if (Util.isEmpty((String)str)) {
                        ((variable)this.operands[0]).set_var_type(p);
                        return String.valueOf(opstr);
                    }
                    return String.valueOf(opstr) + str + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " does not have boolean type or " + ((bit_expression)this.operands[1]).toString() + " is not a correct bit expression.\n";
                }
                return String.valueOf(opstr) + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " does not have boolean type or " + ((bit_expression)this.operands[1]).toString() + " is not a correct bit expression.\n";
            }
            return String.valueOf(errorMessage) + Util.getErrorHeader((int)v1.startline, (int)v1.startcolumn, (int)vs.length()) + vs + " must be a variable.\n";
        }
        if (right == 0) {
            variable v2 = (variable)this.operands[1];
            String vs1 = ((variable)this.operands[1]).get_variable_name();
            basictype p1 = null;
            if (v2.is_agent_name_null()) {
                right_var = false;
            } else {
                String ag_name = v2.get_agent_name();
                Hashtable<String, basictype> gp = vars.get(ag_name);
                if (gp == null) {
                    return String.valueOf(errorMessage) + Util.getErrorHeader((int)v2.agstartline, (int)v2.agstartcolumn, (int)ag_name.length()) + "undefined agent " + ag_name + "\n";
                }
                p1 = gp.get(vs1);
                if (p1 == null) {
                    return String.valueOf(errorMessage) + Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length()) + "variable " + vs1 + " is not defined in agent " + ag_name + "\n";
                }
            }
            if (right_var) {
                String opstr;
                right = p1.get_type();
                if (left == 1) {
                    if (right != 1) {
                        return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " in " + this.toString() + " is not a Boolean variable.\n";
                    }
                    if (this.op == 0 || this.op == 1) {
                        ((variable)this.operands[1]).set_var_type(p1);
                        return errorMessage;
                    }
                    return String.valueOf(errorMessage) + Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                }
                if (left == 2) {
                    if (right != 2) {
                        return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " in " + this.toString() + " is not a bounded integer variable.\n";
                    }
                    int value = ((int_value)this.operands[0]).get_value();
                    if (!((rangedint)p1).is_valid_value(value)) {
                        return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " in " + this.toString() + " does not have value " + value + ".\n";
                    }
                    ((variable)this.operands[1]).set_var_type(p1);
                    return errorMessage;
                }
                if (left == 3) {
                    if (right != 3) {
                        return String.valueOf(Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length())) + vs1 + " in " + this.toString() + " is not an enumeration variable.\n";
                    }
                    if (this.op == 0 || this.op == 1) {
                        String vs = ((enum_value)this.operands[0]).get_value();
                        TreeSet s2 = ((enumerate)p1).get_enumvalue();
                        if (s2.contains(vs)) {
                            ((variable)this.operands[1]).set_var_type(p1);
                            return errorMessage;
                        }
                        return String.valueOf(errorMessage) + Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length()) + vs1 + " does not have the value " + vs + "\n";
                    }
                    return String.valueOf(errorMessage) + Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength) + "only equality or inequality test is allowed in " + this.toString() + ".\n";
                }
                if (left >= 5 && left <= 8) {
                    if (p1.get_type() == 2) {
                        String str = ((arithmetic_expression)this.operands[0]).check_var_and_value1(vars, document);
                        if (Util.isEmpty((String)str)) {
                            ((variable)this.operands[1]).set_var_type(p1);
                            return errorMessage;
                        }
                        return String.valueOf(errorMessage) + str + Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length()) + vs1 + " does not have integer type or " + ((arithmetic_expression)this.operands[0]).toString() + " is not a correct arithmetic expression.\n";
                    }
                    return String.valueOf(errorMessage) + Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length()) + vs1 + " does not have integer type or " + ((arithmetic_expression)this.operands[0]).toString() + " is not a correct arithmetic expression.\n";
                }
                String string = opstr = this.op > 1 ? String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n" : "";
                if (right == 1) {
                    String str = ((bit_expression)this.operands[0]).check_var_and_value1(vars, document);
                    if (Util.isEmpty((String)str)) {
                        ((variable)this.operands[1]).set_var_type(p1);
                        return String.valueOf(opstr);
                    }
                    return String.valueOf(opstr) + str + Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length()) + vs1 + " does not have boolean type or " + ((bit_expression)this.operands[0]).toString() + " is not a correct bit expression.\n";
                }
                return String.valueOf(opstr) + Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length()) + vs1 + " does not have boolean type or " + ((bit_expression)this.operands[0]).toString() + " is not a correct bit expression.\n";
            }
            return String.valueOf(errorMessage) + Util.getErrorHeader((int)v2.startline, (int)v2.startcolumn, (int)vs1.length()) + vs1 + " must be a variable.\n";
        }
        if (left >= 5 && left <= 8) {
            if (right == 2) {
                return String.valueOf(errorMessage) + ((arithmetic_expression)this.operands[0]).check_var_and_value1(vars, document);
            }
            if (right >= 5 && right <= 8) {
                return String.valueOf(errorMessage) + ((arithmetic_expression)this.operands[0]).check_var_and_value1(vars, document) + ((arithmetic_expression)this.operands[1]).check_var_and_value1(vars, document);
            }
            return String.valueOf(errorMessage) + Util.getErrorHeader((int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)this.operands[1].endline, (int)this.operands[1].endcolumn)) + "right hand side in " + this.toString() + " has a wrong type.\n";
        }
        if (right >= 5 && right <= 8) {
            if (left == 2) {
                return String.valueOf(errorMessage) + ((arithmetic_expression)this.operands[1]).check_var_and_value1(vars, document);
            }
            return String.valueOf(errorMessage) + Util.getErrorHeader((int)this.operands[0].startline, (int)this.operands[0].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[0].startline, (int)this.operands[0].startcolumn, (int)this.operands[0].endline, (int)this.operands[0].endcolumn)) + "left hand side in " + this.toString() + " has a wrong type.\n";
        }
        if (left >= 9 && left <= 12) {
            String opstr;
            String string = opstr = this.op > 1 ? String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n" : "";
            if (right == 1) {
                return String.valueOf(opstr) + ((arithmetic_expression)this.operands[0]).check_var_and_value1(vars, document);
            }
            if (right >= 9 && right <= 12) {
                return String.valueOf(opstr) + ((arithmetic_expression)this.operands[0]).check_var_and_value1(vars, document) + ((arithmetic_expression)this.operands[1]).check_var_and_value1(vars, document);
            }
            return String.valueOf(opstr) + Util.getErrorHeader((int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)this.operands[1].endline, (int)this.operands[1].endcolumn)) + "right hand side in " + this.toString() + " has a wrong type.\n";
        }
        if (right >= 9 && right <= 12) {
            String opstr;
            String string = opstr = this.op > 1 ? String.valueOf(Util.getErrorHeader((int)this.opStartline, (int)this.opStartcolumn, (int)this.opLength)) + "only equality or inequality test is allowed in " + this.toString() + ".\n" : "";
            if (left == 1) {
                return String.valueOf(opstr) + ((arithmetic_expression)this.operands[1]).check_var_and_value1(vars, document);
            }
            return String.valueOf(opstr) + Util.getErrorHeader((int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[1].startline, (int)this.operands[1].startcolumn, (int)this.operands[1].endline, (int)this.operands[1].endcolumn)) + "left hand side in " + this.toString() + " has a wrong type.\n";
        }
        return String.valueOf(errorMessage) + Util.getErrorHeader((int)this.operands[0].startline, (int)this.operands[0].startcolumn, (int)Util.getLength((IDocument)document, (int)this.operands[0].startline, (int)this.operands[0].startcolumn, (int)this.operands[1].endline, (int)this.operands[1].endcolumn)) + "illegal logic expression: " + this.toString() + "\n";
    }

    public boolean evaluate(String agentName, GlobalState gstate) {
        int ltype = this.operands[0].get_type();
        int rtype = this.operands[1].get_type();
        if (ltype == 0) {
            variable lvar = (variable)this.operands[0];
            String agentName1 = lvar.get_agent_name();
            if (agentName1 == null || Util.isEmpty((String)agentName1)) {
                agentName1 = agentName;
            }
            expression lvalue = gstate.getValue(agentName1, lvar.get_variable_name());
            if (rtype == 0) {
                variable rvar = (variable)this.operands[1];
                String agentName2 = rvar.get_agent_name();
                if (agentName2 == null || Util.isEmpty((String)agentName2)) {
                    agentName2 = agentName;
                }
                expression rvalue = gstate.getValue(agentName2, rvar.get_variable_name());
                int type = lvalue.get_type();
                if (type == 1) {
                    return this.compareTwoBooleanValues(((bool_value)lvalue).get_value(), ((bool_value)rvalue).get_value());
                }
                if (type == 2) {
                    return this.compareTwoIntegers(((int_value)lvalue).get_value(), ((int_value)rvalue).get_value());
                }
                return this.compareTwoEnumerationValues(((enum_value)lvalue).get_value(), ((enum_value)rvalue).get_value());
            }
            if (rtype == 1) {
                return this.compareTwoBooleanValues(((bool_value)lvalue).get_value(), ((bool_value)this.operands[1]).get_value());
            }
            if (rtype == 2) {
                return this.compareTwoIntegers(((int_value)lvalue).get_value(), ((int_value)this.operands[1]).get_value());
            }
            if (rtype == 3) {
                return this.compareTwoEnumerationValues(((enum_value)lvalue).get_value(), ((enum_value)this.operands[1]).get_value());
            }
            if (rtype >= 5 && rtype <= 8) {
                return this.compareTwoIntegers(((int_value)lvalue).get_value(), ((arithmetic_expression)this.operands[1]).evaluate(agentName, gstate));
            }
            return this.compareTwoBooleanValues(((bool_value)lvalue).get_value(), ((bit_expression)this.operands[1]).evaluate(agentName, gstate));
        }
        if (rtype == 0) {
            variable rvar = (variable)this.operands[1];
            String agentName2 = rvar.get_agent_name();
            if (agentName2 == null || Util.isEmpty((String)agentName2)) {
                agentName2 = agentName;
            }
            expression rvalue = gstate.getValue(agentName2, rvar.get_variable_name());
            if (ltype == 1) {
                return this.compareTwoBooleanValues(((bool_value)this.operands[0]).get_value(), ((bool_value)rvalue).get_value());
            }
            if (ltype == 2) {
                return this.compareTwoIntegers(((int_value)this.operands[0]).get_value(), ((int_value)rvalue).get_value());
            }
            if (ltype == 3) {
                return this.compareTwoEnumerationValues(((enum_value)this.operands[0]).get_value(), ((enum_value)rvalue).get_value());
            }
            if (ltype >= 5 && ltype <= 8) {
                return this.compareTwoIntegers(((arithmetic_expression)this.operands[0]).evaluate(agentName, gstate), ((int_value)rvalue).get_value());
            }
            return this.compareTwoBooleanValues(((bit_expression)this.operands[0]).evaluate(agentName, gstate), ((bool_value)rvalue).get_value());
        }
        if (ltype == 1 && rtype == 1) {
            return this.compareTwoBooleanValues(((bool_value)this.operands[0]).get_value(), ((bool_value)this.operands[1]).get_value());
        }
        if (ltype == 2 && rtype == 2) {
            return this.compareTwoIntegers(((int_value)this.operands[0]).get_value(), ((int_value)this.operands[1]).get_value());
        }
        if (ltype == 1 && rtype >= 9 && rtype <= 12) {
            return this.compareTwoBooleanValues(((bool_value)this.operands[0]).get_value(), ((bit_expression)this.operands[1]).evaluate(agentName, gstate));
        }
        if (ltype == 2 && rtype >= 5 && rtype <= 8) {
            return this.compareTwoIntegers(((int_value)this.operands[0]).get_value(), ((arithmetic_expression)this.operands[1]).evaluate(agentName, gstate));
        }
        if (rtype == 1 && ltype >= 9 && ltype <= 12) {
            return this.compareTwoBooleanValues(((bit_expression)this.operands[0]).evaluate(agentName, gstate), ((bool_value)this.operands[1]).get_value());
        }
        if (rtype == 2 && ltype >= 5 && ltype <= 8) {
            return this.compareTwoIntegers(((arithmetic_expression)this.operands[0]).evaluate(agentName, gstate), ((int_value)this.operands[1]).get_value());
        }
        if (ltype == 3) {
            return this.compareTwoEnumerationValues(((enum_value)this.operands[0]).get_value(), ((enum_value)this.operands[1]).get_value());
        }
        if (rtype >= 5 && rtype <= 8 && ltype >= 5 && ltype <= 8) {
            return this.compareTwoIntegers(((arithmetic_expression)this.operands[0]).evaluate(agentName, gstate), ((arithmetic_expression)this.operands[1]).evaluate(agentName, gstate));
        }
        return this.compareTwoBooleanValues(((bit_expression)this.operands[0]).evaluate(agentName, gstate), ((bit_expression)this.operands[1]).evaluate(agentName, gstate));
    }

    private boolean compareTwoIntegers(int lint, int rint) {
        if (this.op == 0) {
            return lint == rint;
        }
        if (this.op == 1) {
            return lint != rint;
        }
        if (this.op == 2) {
            return lint < rint;
        }
        if (this.op == 3) {
            return lint <= rint;
        }
        if (this.op == 4) {
            return lint > rint;
        }
        return lint >= rint;
    }

    private boolean compareTwoBooleanValues(boolean lbool, boolean rbool) {
        if (lbool == rbool) {
            return this.op == 0;
        }
        return this.op == 1;
    }

    private boolean compareTwoEnumerationValues(String lenum, String renum) {
        if (lenum.compareTo(renum) == 0) {
            return this.op == 0;
        }
        return this.op == 1;
    }

    public boolean evaluate(String agentName, GlobalState gstate, Hashtable<String, String> actions) {
        if (this.operands[0].get_type() == 4) {
            String agentName1 = ((laction)this.operands[0]).get_agent_name();
            if (agentName1 == null || Util.isEmpty((String)agentName1)) {
                agentName1 = agentName;
            }
            String ract = ((variable)this.operands[1]).get_variable_name();
            String lact = actions.get(agentName1);
            return lact != null && lact.compareTo(ract) == 0;
        }
        return this.evaluate(agentName, gstate);
    }

    public boolean evaluate1(String agentName, GlobalState gstate, Hashtable<String, TreeSet<String>> actions) {
        if (this.operands[0].get_type() == 4) {
            String agentName1 = ((laction)this.operands[0]).get_agent_name();
            if (agentName1 == null || Util.isEmpty((String)agentName1)) {
                agentName1 = agentName;
            }
            String ract = ((variable)this.operands[1]).get_variable_name();
            TreeSet<String> lacts = actions.get(agentName1);
            return lacts != null && lacts.contains(ract);
        }
        return this.evaluate(agentName, gstate);
    }

    public boolean evaluate2(GlobalState gstate) {
        return this.evaluate("", gstate);
    }

    public boolean evaluate3(CESystem gstate) {
        int ltype = this.operands[0].get_type();
        int rtype = this.operands[1].get_type();
        if (ltype == 0) {
            variable lvar = (variable)this.operands[0];
            String agentName1 = lvar.get_agent_name();
            expression lvalue = gstate.getVarValue(agentName1, lvar.get_variable_name());
            if (lvalue == null) {
                return false;
            }
            if (rtype == 0) {
                variable rvar = (variable)this.operands[1];
                String agentName2 = rvar.get_agent_name();
                expression rvalue = gstate.getVarValue(agentName2, rvar.get_variable_name());
                if (rvalue == null) {
                    return false;
                }
                int type = lvalue.get_type();
                if (type == 1) {
                    return this.compareTwoBooleanValues(((bool_value)lvalue).get_value(), ((bool_value)rvalue).get_value());
                }
                if (type == 2) {
                    return this.compareTwoIntegers(((int_value)lvalue).get_value(), ((int_value)rvalue).get_value());
                }
                return this.compareTwoEnumerationValues(((enum_value)lvalue).get_value(), ((enum_value)rvalue).get_value());
            }
            if (rtype == 1) {
                return this.compareTwoBooleanValues(((bool_value)lvalue).get_value(), ((bool_value)this.operands[1]).get_value());
            }
            if (rtype == 2) {
                return this.compareTwoIntegers(((int_value)lvalue).get_value(), ((int_value)this.operands[1]).get_value());
            }
            if (rtype == 3) {
                return this.compareTwoEnumerationValues(((enum_value)lvalue).get_value(), ((enum_value)this.operands[1]).get_value());
            }
            if (rtype >= 5 && rtype <= 8) {
                if (!((arithmetic_expression)this.operands[1]).canEvaluate(gstate)) {
                    return false;
                }
                return this.compareTwoIntegers(((int_value)lvalue).get_value(), ((arithmetic_expression)this.operands[1]).evaluate(gstate));
            }
            if (!((bit_expression)this.operands[1]).canEvaluate(gstate)) {
                return false;
            }
            return this.compareTwoBooleanValues(((bool_value)lvalue).get_value(), ((bit_expression)this.operands[1]).evaluate(gstate));
        }
        if (rtype == 0) {
            variable rvar = (variable)this.operands[1];
            String agentName2 = rvar.get_agent_name();
            expression rvalue = gstate.getVarValue(agentName2, rvar.get_variable_name());
            if (rvalue == null) {
                return false;
            }
            if (ltype == 1) {
                return this.compareTwoBooleanValues(((bool_value)this.operands[0]).get_value(), ((bool_value)rvalue).get_value());
            }
            if (ltype == 2) {
                return this.compareTwoIntegers(((int_value)this.operands[0]).get_value(), ((int_value)rvalue).get_value());
            }
            if (ltype == 3) {
                return this.compareTwoEnumerationValues(((enum_value)this.operands[0]).get_value(), ((enum_value)rvalue).get_value());
            }
            if (ltype >= 5 && ltype <= 8) {
                if (!((arithmetic_expression)this.operands[0]).canEvaluate(gstate)) {
                    return false;
                }
                return this.compareTwoIntegers(((arithmetic_expression)this.operands[0]).evaluate(gstate), ((int_value)rvalue).get_value());
            }
            if (!((bit_expression)this.operands[0]).canEvaluate(gstate)) {
                return false;
            }
            return this.compareTwoBooleanValues(((bit_expression)this.operands[0]).evaluate(gstate), ((bool_value)rvalue).get_value());
        }
        if (ltype == 1 && rtype == 1) {
            return this.compareTwoBooleanValues(((bool_value)this.operands[0]).get_value(), ((bool_value)this.operands[1]).get_value());
        }
        if (ltype == 2 && rtype == 2) {
            return this.compareTwoIntegers(((int_value)this.operands[0]).get_value(), ((int_value)this.operands[1]).get_value());
        }
        if (ltype == 1 && rtype >= 9 && rtype <= 12) {
            return this.compareTwoBooleanValues(((bool_value)this.operands[0]).get_value(), ((bit_expression)this.operands[1]).evaluate(gstate));
        }
        if (ltype == 2 && rtype >= 5 && rtype <= 8) {
            return this.compareTwoIntegers(((int_value)this.operands[0]).get_value(), ((arithmetic_expression)this.operands[1]).evaluate(gstate));
        }
        if (rtype == 1 && ltype >= 9 && ltype <= 12) {
            return this.compareTwoBooleanValues(((bit_expression)this.operands[0]).evaluate(gstate), ((bool_value)this.operands[1]).get_value());
        }
        if (rtype == 2 && ltype >= 5 && ltype <= 8) {
            return this.compareTwoIntegers(((arithmetic_expression)this.operands[0]).evaluate(gstate), ((int_value)this.operands[1]).get_value());
        }
        if (ltype == 3) {
            return this.compareTwoEnumerationValues(((enum_value)this.operands[0]).get_value(), ((enum_value)this.operands[1]).get_value());
        }
        if (ltype >= 5 && ltype <= 8) {
            if (!((arithmetic_expression)this.operands[1]).canEvaluate(gstate) || !((arithmetic_expression)this.operands[0]).canEvaluate(gstate)) {
                return false;
            }
            return this.compareTwoIntegers(((arithmetic_expression)this.operands[0]).evaluate(gstate), ((arithmetic_expression)this.operands[1]).evaluate(gstate));
        }
        if (!((bit_expression)this.operands[1]).canEvaluate(gstate) || !((bit_expression)this.operands[0]).canEvaluate(gstate)) {
            return false;
        }
        return this.compareTwoBooleanValues(((bit_expression)this.operands[0]).evaluate(gstate), ((bit_expression)this.operands[1]).evaluate(gstate));
    }

    public ArrayList<logic_expression> getNegation() {
        ArrayList<logic_expression> lexprs = new ArrayList<logic_expression>();
        variable var = (variable)this.operands[0];
        expression value = this.operands[1];
        int value_type = value.get_type();
        if (value_type == 1) {
            bool_value b = new bool_value(!((bool_value)value).get_value(), 0, 0);
            lexprs.add(new logic_expression(0, (expression)var, (expression)b));
        } else if (value_type == 3) {
            basictype bt = var.get_var_type();
            TreeSet values = ((enumerate)bt).get_enumvalue();
            String enumvalue = ((enum_value)value).get_value();
            for (String element : values) {
                if (element.compareTo(enumvalue) == 0) continue;
                enum_value b = new enum_value(element, 0, 0);
                lexprs.add(new logic_expression(0, (expression)var, (expression)b));
            }
        } else if (value_type == 2) {
            basictype bt = var.get_var_type();
            int lowerbound = ((rangedint)bt).get_lowerbound();
            int upperbound = ((rangedint)bt).get_upperbound();
            int intvalue = ((int_value)value).get_value();
            int i = lowerbound;
            while (i <= upperbound) {
                if (i != intvalue) {
                    int_value b = new int_value(i, 0, 0, 0, 0);
                    lexprs.add(new logic_expression(0, (expression)var, (expression)b));
                }
                ++i;
            }
        } else {
            System.out.println("The value type " + value_type + "should not happen!");
        }
        return lexprs;
    }

    public boolean isSameAction(logic_expression l1) {
        String act_name2;
        String act_name1;
        String ag_name2;
        String ag_name1;
        return this.op == 0 && l1.op == 0 && (ag_name1 = ((laction)this.operands[0]).get_agent_name()).compareTo(ag_name2 = ((laction)l1.operands[0]).get_agent_name()) == 0 && (act_name1 = ((variable)this.operands[1]).get_variable_name()).compareTo(act_name2 = ((variable)l1.operands[1]).get_variable_name()) == 0;
    }
}

