/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.syntax;

import java.util.ArrayList;
import org.mcmas.ui.syntax.Util;
import org.mcmas.ui.syntax.basictype;
import org.mcmas.ui.syntax.expression;
import org.mcmas.ui.syntax.int_value;
import org.mcmas.ui.syntax.logic_expression;
import org.mcmas.ui.syntax.variable;

public class rangedint
extends basictype {
    private int lowerbound;
    private int upperbound;
    private int power_two;
    private int half_power;
    private int bdd_length;

    public rangedint(String n, int l, int u, int line, int column) {
        super(n, 2, line, column);
        this.lowerbound = l;
        this.upperbound = u;
        this.bdd_length = Util.log_2((int)(this.upperbound - this.lowerbound + 1));
        this.power_two = 1;
        this.power_two <<= this.bdd_length;
        this.half_power = 1;
        this.half_power <<= this.bdd_length - 1;
        this.half_power += this.lowerbound;
    }

    public int get_lowerbound() {
        return this.lowerbound;
    }

    public int get_upperbound() {
        return this.upperbound;
    }

    public boolean is_valid_value(int i) {
        return i <= this.upperbound && i >= this.lowerbound;
    }

    public String toString() {
        return String.valueOf(this.get_name()) + ": " + this.lowerbound + " .. " + this.upperbound;
    }

    public int BDD_length() {
        return this.bdd_length;
    }

    public void print_value_index() {
        int k = this.lowerbound;
        while (k <= this.upperbound) {
            System.out.print(String.valueOf(k) + ": ");
            int[] v = this.get_value_index(k);
            int j = 0;
            while (j < v.length) {
                System.out.println(v[j] == 1 ? "1" : (v[j] == -1 ? "0" : "_"));
                ++j;
            }
            System.out.println();
            ++k;
        }
    }

    public int[] get_value_index(int value) {
        if (value >= this.lowerbound && value <= this.upperbound) {
            int[] temp = new int[this.bdd_length];
            int i = 0;
            while (i < this.bdd_length) {
                temp[i] = -1;
                ++i;
            }
            if (this.power_two + this.lowerbound == this.upperbound + 1) {
                int distance = value - this.lowerbound;
                int i2 = this.bdd_length - 1;
                while (i2 >= 0) {
                    if ((distance & 1) == 1) {
                        temp[i2] = 1;
                    }
                    distance >>= 1;
                    --i2;
                }
            } else {
                int index = value - this.half_power;
                if (index < 0) {
                    int distance = value - this.lowerbound;
                    int i3 = this.bdd_length - 2;
                    while (i3 >= 0) {
                        if ((distance & 1) == 1) {
                            temp[i3] = 1;
                        }
                        distance >>= 1;
                        --i3;
                    }
                    if (value - this.lowerbound > this.upperbound - this.half_power) {
                        temp[this.bdd_length - 1] = 0;
                    }
                } else {
                    int distance = index;
                    int i4 = this.bdd_length - 2;
                    while (i4 >= 0) {
                        if ((distance & 1) == 1) {
                            temp[i4] = 1;
                        }
                        distance >>= 1;
                        --i4;
                    }
                    temp[this.bdd_length - 1] = 1;
                }
            }
            return temp;
        }
        return null;
    }

    public int get_value_index_int(int value) {
        return value - this.lowerbound;
    }

    public int find_value_by_index(boolean[] index) {
        int value = 0;
        if (this.power_two + this.lowerbound == this.upperbound + 1) {
            int i = 0;
            while (i < index.length) {
                value <<= 1;
                value += index[i] ? 1 : 0;
                ++i;
            }
            return value + this.lowerbound;
        }
        int i = 0;
        while (i < index.length - 1) {
            value <<= 1;
            value += index[i] ? 1 : 0;
            ++i;
        }
        if (value > this.upperbound - this.half_power || !index[this.bdd_length - 1]) {
            return value + this.lowerbound;
        }
        return value + this.half_power;
    }

    public ArrayList<logic_expression> getLogicExpressions(String agentName) {
        if (this.lexprs == null) {
            variable var = new variable(agentName, this.get_name(), 0, 0, 0, 0);
            var.set_var_type((basictype)this);
            this.lexprs = new ArrayList();
            int i = this.lowerbound;
            while (i <= this.upperbound) {
                int_value b = new int_value(i, 0, 0, 0, 0);
                this.lexprs.add(new logic_expression(0, (expression)var, (expression)b));
                ++i;
            }
        }
        return this.lexprs;
    }
}

