/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class IsplNewFilePage
extends WizardPage {
    private Text fileText;
    private Button checkButton;
    private Button checkButton1;
    private Label label;

    public IsplNewFilePage() {
        super("wizardPage");
        this.setTitle("New MCMAS Project");
        this.setDescription("Create a new file with *.ispl extension that can be opened by a multi-page editor.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        this.checkButton1 = new Button(container, 32);
        this.checkButton1.setText("&Add a new file to the project");
        this.checkButton1.setSelection(true);
        GridData gd = new GridData(768);
        this.checkButton1.setLayoutData((Object)gd);
        this.checkButton1.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Group group = new Group(container, 0);
        gd = new GridData(768);
        group.setLayoutData((Object)gd);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        this.label = new Label((Composite)group, 0);
        this.label.setText("&File name:");
        this.fileText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.checkButton = new Button((Composite)group, 32);
        this.checkButton.setText("&Generate the basic framework");
        this.checkButton.setSelection(true);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.checkButton.setLayoutData((Object)gd);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        this.fileText.setText("new_file.ispl");
    }

    private void dialogChanged() {
        String ext;
        String fileName = this.getFileName();
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must be valid");
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("ispl")) {
            this.updateStatus("File extension must be \"ispl\"");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public boolean getSelection() {
        return this.checkButton.getSelection();
    }

    private void setGroupEnabled(boolean flag) {
        this.label.setEnabled(flag);
        this.fileText.setEnabled(flag);
        this.checkButton.setEnabled(flag);
    }

    public boolean isAddFileSelected() {
        return this.checkButton1.getSelection();
    }

    public boolean isAddContentSelected() {
        return this.checkButton.getSelection();
    }

    static /* synthetic */ Button access$0(IsplNewFilePage isplNewFilePage) {
        return isplNewFilePage.checkButton1;
    }

    static /* synthetic */ void access$1(IsplNewFilePage isplNewFilePage, boolean bl) {
        isplNewFilePage.setGroupEnabled(bl);
    }

    static /* synthetic */ void access$2(IsplNewFilePage isplNewFilePage) {
        isplNewFilePage.dialogChanged();
    }
}

