/*
 * Decompiled with CFR 0.152.
 */
package org.mcmas.ui.wizards;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.mcmas.ui.wizards.IsplNewFilePage;
import org.mcmas.ui.wizards.IsplNewWizard;
import org.mcmas.ui.wizards.McmasNewSiteProjectWizard;

public class McmasNewSiteProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private WizardNewProjectCreationPage wizardPage;
    private IsplNewFilePage page;
    private IConfigurationElement config;
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private IProject project;

    public void addPages() {
        this.wizardPage = new WizardNewProjectCreationPage("NewMcmasSiteProject");
        this.wizardPage.setDescription("Create a new MCMAS Project.");
        this.wizardPage.setTitle("New MCMAS Project");
        this.addPage((IWizardPage)this.wizardPage);
        this.page = new IsplNewFilePage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        String fileName = this.page.getFileName();
        boolean addFile = this.page.isAddFileSelected();
        boolean addContent = this.page.isAddContentSelected();
        if (this.project != null) {
            return true;
        }
        IProject projectHandle = this.wizardPage.getProjectHandle();
        URI projectURI = !this.wizardPage.useDefaults() ? this.wizardPage.getLocationURI() : null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription desc = workspace.newProjectDescription(projectHandle.getName());
        desc.setLocationURI(projectURI);
        1 op = new /* Unavailable Anonymous Inner Class!! */;
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        this.project = projectHandle;
        if (this.project == null) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        BasicNewProjectResourceWizard.selectAndReveal((IResource)this.project, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
        return true;
    }

    void createProject(IProjectDescription description, IProject proj, IProgressMonitor monitor, String fileName, boolean addFile, boolean addContent) throws CoreException, OperationCanceledException {
        try {
            try {
                monitor.beginTask("", 2000);
                proj.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                proj.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                IProject container = proj;
                if (addFile) {
                    this.addFileToProject((IContainer)container, new Path(fileName), IsplNewWizard.openContentStream((boolean)addContent), monitor);
                }
            }
            catch (Exception ioe) {
                Status status = new Status(4, "IsplNewWizard", 0, ioe.getLocalizedMessage(), null);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.config = config;
    }

    private void addFileToProject(IContainer container, Path path, InputStream contentStream, IProgressMonitor monitor) throws CoreException {
        IFile file = container.getFile((IPath)path);
        if (file.exists()) {
            file.setContents(contentStream, true, true, monitor);
        } else {
            file.create(contentStream, true, monitor);
        }
    }
}

