grammar ISPL;

options {
	backtrack=true;
	output = AST;
	ASTLabelType=CommonTree;
}

tokens{
SEMANTICS;
SINGLEASSIGNMENT;
MULTIASSIGNMENT;
IS;
VARDEF;
BOOLEAN;
RANGEDINT;
ENUMERATION;
POSITIVE;
NEGATIVE;
PROTLINE;
ACTIONLIST;
ENVEVLINE;
EVLINE;
ASSIGNMENT;
EASSIGNMENT;
GLOBALVAR;
ATOMICPROPOSITION;
GROUP;
AGENTLIST;
AU;
EU;
}

@header {
package org.mcmas.ui.syntax;

import org.mcmas.ui.editors.MCMASEditor;
}

@lexer::header {
package org.mcmas.ui.syntax;

import org.mcmas.ui.editors.MCMASEditor;
}

@members {
//public String errorMessage = "";
private MCMASEditor editor;
public void setMCMASEditor(MCMASEditor editor) {
	this.editor = editor;
}
public String getErrorHeader(RecognitionException e) {
	if(e.token.getText() != null)
		return "line "+e.line+":"+e.charPositionInLine+":"+e.token.getText().length();
	else
		return "line "+e.line+":"+e.charPositionInLine+":1";
}
public void emitErrorMessage(String str) {
	editor.errorMessage += str + "\n";
}
/*public void recoverFromMismatchedToken(IntStream input, RecognitionException e, int ttype, BitSet follow)
		throws RecognitionException
	{
		// if next token is what we are looking for then "delete" this token
		if ( input.LA(2)==ttype ) {
			reportError(e);
			/*
			System.err.println("recoverFromMismatchedToken deleting "+input.LT(1)+
							   " since "+input.LT(2)+" is what we want");
			* /
			beginResync();
			input.consume(); // simply delete extra token
			endResync();
			input.consume(); // move past ttype token as if all were ok
			return;
		}
		if ( !recoverFromMismatchedElement(input,e,follow) ) {
			throw e;
		}
	}*/
}

@lexer::members {
private MCMASEditor editor;
public void setMCMASEditor(MCMASEditor editor) {
	this.editor = editor;
}
public String getErrorHeader(RecognitionException e) {
	return "line "+e.line+":"+e.charPositionInLine+":"+1;
}
public void emitErrorMessage(String str) {
	editor.errorMessage += str + "\n";
}
}

is 	:	(semantics {editor.ispltree.add($semantics.value);})? 
		(environment {editor.ispltree.add($environment.value);})?
		(agent {editor.ispltree.add($agent.value);})+ 
		evaluation {editor.ispltree.add($evaluation.value);}
		initstates {editor.ispltree.add($initstates.value);}
		(groups {editor.ispltree.add($groups.value);})?
		(fairness {editor.ispltree.add($fairness.value);})?
		formulae {editor.ispltree.add($formulae.value);}
			-> ^(IS semantics? environment? agent+ evaluation initstates groups? fairness? formulae)
	;

semantics	returns[RawSegment value]
	:	SEMAN='Semantics' '=' 'MultiAssignment' SEMI=';'
		{	$value = new RawSegment("Semantics", $SEMAN.line-1, $SEMAN.pos, $SEMI.line-1, $SEMI.pos+1, null, null);}
		-> ^(SEMANTICS MULTIASSIGNMENT)
	|	SEMAN='Semantics' '=' 'MA' SEMI=';'
		{	$value = new RawSegment("Semantics", $SEMAN.line-1, $SEMAN.pos, $SEMI.line-1, $SEMI.pos+1, null, null);}
		-> ^(SEMANTICS MULTIASSIGNMENT)
	|	SEMAN='Semantics' '=' 'SingleAssignment' SEMI=';'
		{	$value = new RawSegment("Semantics", $SEMAN.line-1, $SEMAN.pos, $SEMI.line-1, $SEMI.pos+1, null, null);}
		-> ^(SEMANTICS SINGLEASSIGNMENT)
	|	SEMAN='Semantics' '=' 'SA' SEMI=';'
		{	$value = new RawSegment("Semantics", $SEMAN.line-1, $SEMAN.pos, $SEMI.line-1, $SEMI.pos+1, null, null);}
		-> ^(SEMANTICS SINGLEASSIGNMENT)
	;

environment 	returns[RawSegment value]
@init {ArrayList<RawSegment> children = new ArrayList<RawSegment>();}
@after {
	if($value == null)
		$value = new RawSegment("Agent Environment", $AGENT.line-1, $AGENT.pos, $endagent.line-1, $endagent.pos+5, null, children);
}
	:	AGENT='Agent' 'Environment' 
		(obsvars {children.add($obsvars.value);})?
		(envvars {children.add($envvars.value);})?
		(enredstates {children.add($enredstates.value);})?
		envactions {children.add($envactions.value);}
		envprotocol {children.add($envprotocol.value);}
		envevolution {children.add($envevolution.value);}
		'end' endagent='Agent'
		{	$value = new RawSegment("Agent Environment", $AGENT.line-1, $AGENT.pos, $endagent.line-1, $endagent.pos+5, null, children);
		}
			-> ^($AGENT 'Environment' obsvars? envvars? enredstates? envactions envprotocol envevolution)
	/*|	AGENT='Agent' 'Environment' 
		obsvars {children.add($obsvars.value);} 
		envvars {children.add($envvars.value);}
		//enredstates {children.add($enredstates.value);}
		envactions {children.add($envactions.value);}
		envprotocol {children.add($envprotocol.value);}
		envevolution {children.add($envevolution.value);}
		'end' endagent='Agent'
		{	$value = new RawSegment("Agent Environment", $AGENT.line-1, $AGENT.pos, $endagent.line-1, $endagent.pos+5, null, children);
		}
			-> ^($AGENT 'Environment' obsvars envvars envactions envprotocol envevolution)*/
	;

agent		returns[RawSegment value]
@init {ArrayList<RawSegment> children = new ArrayList<RawSegment>();}
@after {
	if($value == null)
		$value = new RawSegment("Agent"+$id.text, $AGENT.line-1, $AGENT.pos, $endagent.line-1, $endagent.pos+5, null, children);
}
	:	AGENT='Agent' id=ID 
		(lobsvars {children.add($lobsvars.value);})?
		vars {children.add($vars.value);}
		(redstates {children.add($redstates.value);})?
		actions {children.add($actions.value);}
		protocol {children.add($protocol.value);}
		evolution {children.add($evolution.value);}
		'end' endagent='Agent'
		{	$value = new RawSegment("Agent"+$ID.text, $AGENT.line-1, $AGENT.pos, $endagent.line-1, $endagent.pos+5, null, children);
		}
			-> ^($AGENT ID lobsvars? vars redstates? actions protocol evolution)
	/*|	AGENT='Agent' id=ID 
		vars {children.add($vars.value);}
		actions {children.add($actions.value);}
		protocol {children.add($protocol.value);}
		evolution {children.add($evolution.value);}
		'end' endagent='Agent'
		{	$value = new RawSegment("Agent"+$ID.text, $AGENT.line-1, $AGENT.pos, $endagent.line-1, $endagent.pos+5, null, children);
		}
			-> ^($AGENT ID vars actions protocol evolution)*/
	;

obsvars		returns[RawSegment value]
@init {ArrayList<RawSegment> children = new ArrayList<RawSegment>();}
	:	OBSVARS='Obsvars' ':' 
		(var {children.add($var.value);})* 
		'end' endobsvars='Obsvars' 
		{	$value = new RawSegment("Obsvars", $OBSVARS.line-1, $OBSVARS.pos, $endobsvars.line-1, $endobsvars.pos+7, null, children);
		}
			-> ^($OBSVARS var*)
	;
envvars		returns[RawSegment value]
@init {ArrayList<RawSegment> children = new ArrayList<RawSegment>();}
	:	VARS='Vars' ':' 
		(var {children.add($var.value);})* 
		'end' endvars='Vars'
		{	$value = new RawSegment("Vars", $VARS.line-1, $VARS.pos, $endvars.line-1, $endvars.pos+4, null, children);
		}
			-> ^($VARS var*)
	;
vars		returns[RawSegment value]
@init {ArrayList<RawSegment> children = new ArrayList<RawSegment>();}
	:	VARS='Vars' ':'
		(var {children.add($var.value);})+ 
		'end' endvars='Vars'
		{	$value = new RawSegment("Vars", $VARS.line-1, $VARS.pos, $endvars.line-1, $endvars.pos+4, null, children);
		}
			-> ^($VARS var+)
	;
var		returns[RawSegment value]
	:	name=ID ':' type='boolean' SEMI=';'
		{	$value = new RawSegment($ID.text+" : boolean", $ID.line-1, $ID.pos, $SEMI.line-1, $SEMI.pos+1, null, null);
		}
			-> ^(VARDEF[$name] ID BOOLEAN[$type, "boolean"])
	|	name=ID ':' '{' enum_list '}' SEMI=';'
		{	$value = new RawSegment($ID.text+" : enumeration", $ID.line-1, $ID.pos, $SEMI.line-1, $SEMI.pos+1, null, null);
		}
			-> ^(VARDEF[$name] ID enum_list)
	|	name=ID ':' lb=integer rd='..' ub=integer SEMI=';'
		{	$value = new RawSegment($ID.text+" : bounded integer", $ID.line-1, $ID.pos, $SEMI.line-1, $SEMI.pos+1, null, null);
		}
			-> ^(VARDEF[$name] ID ^(RANGEDINT[$rd, "rangedint"] $lb $ub))
	;
enum_list	
	:	id1=ID (',' id2=ID)*
			-> ^(ENUMERATION[$id1, "enummeration"] ID+)
	;
lobsvars	returns[RawSegment value]
	:	ACTIONS='Lobsvars' '=' '{' (ID (',' ID)*)? '}' SEMI=';'
		{	$value = new RawSegment("Lobsvars", $ACTIONS.line-1, $ACTIONS.pos, $SEMI.line-1, $SEMI.pos+1, null, null);}
			-> ^('Lobsvars' (ID+)?)
	;
envactions	returns[RawSegment value]
	:	ACTIONS='Actions' '=' '{' (ID (',' ID)*)? '}' SEMI=';'
		{	$value = new RawSegment("Actions", $ACTIONS.line-1, $ACTIONS.pos, $SEMI.line-1, $SEMI.pos+1, null, null);}
			-> ^('Actions' (ID+)?)
	;
actions		returns[RawSegment value]
	:	ACTIONS='Actions' '=' '{' ID (',' ID)* '}' SEMI=';'
		{	$value = new RawSegment("Actions", $ACTIONS.line-1, $ACTIONS.pos, $SEMI.line-1, $SEMI.pos+1, null, null);}
			 -> ^('Actions' ID+)
	;
enredstates 	returns[RawSegment value]
	:	REDSTATES='RedStates' ':' (enlboolcond ';')? 'end' ensredstates='RedStates'
		{	$value = new RawSegment("RedStates", $REDSTATES.line-1, $REDSTATES.pos, $ensredstates.line-1, $ensredstates.pos+9, null, null);
		}
			-> ^($REDSTATES enlboolcond?)
	;
redstates 	returns[RawSegment value]
	:	REDSTATES='RedStates' ':' (lboolcond ';')? 'end' ensredstates='RedStates'
		{	$value = new RawSegment("RedStates", $REDSTATES.line-1, $REDSTATES.pos, $ensredstates.line-1, $ensredstates.pos+9, null, null);
		}
			-> ^($REDSTATES lboolcond?)
	;	
enlboolcond	
	:	enlboolcond1 ('or'^ enlboolcond1)*
	;
enlboolcond1	
	:	enlboolcond2 ('and'^ enlboolcond2)*
	;
enlboolcond2	
	:	'!' enlboolcond3
			-> ^('!' enlboolcond3)
	|	enlboolcond3
	;
enlboolcond3
options {memoize=true;}
	:	'(' enlboolcond ')'
			-> enlboolcond
	|	e1=expr4 op=logicop e2=expr4
			-> ^($op $e1 $e2)
	;
lboolcond	
	:	lboolcond1 ('or'^ lboolcond1)*
	;
lboolcond1	
	:	lboolcond2 ('and'^ lboolcond2)*
	;
lboolcond2	
	:	'!' lboolcond3
			-> ^('!' lboolcond3)
	|	lboolcond3
	;
lboolcond3
options {memoize=true;}
	:	'(' lboolcond ')'
			-> lboolcond
	|	e1=expr5 op=logicop e2=expr5
			-> ^($op $e1 $e2)
	;
expr1 	:	term1 ('+'^ term1 |'-'^ term1)*
	;
term1 	: 	element1 ('*'^ element1 |'/'^ element1)*
	;
element1	
	:	'(' expr1 ')'
			-> expr1
	|	varvalue1
	;	
logicop 
	:	'<' 
	|	'<='
	|	'>'
	|	'>='
	|	'='
	|	'<>'
	;	
varvalue1 	
	:	boolvalue
	|	ID 
	|	integer
	;
boolvalue	
	:	'true'
	|	'false'
	;
expr4 	:	term4 ('|'^ term4 |'^'^ term4)*
	;
term4 	: 	factor4 ('&'^ factor4)*
	;
factor4	: 	('~'^)? element4
	;
element4	
	:	'(' expr4 ')'
			-> expr4
	|	expr1
	;

envprotocol	returns[RawSegment value]
@init {ArrayList<RawSegment> children = new ArrayList<RawSegment>();}
	: 	PROTOCOL='Protocol' ':' 
		(enprotline {children.add($enprotline.value);})* 
		(otherbranch {children.add($otherbranch.value);})? 
		'end' endprotocol='Protocol'
		{	$value = new RawSegment("Protocol", $PROTOCOL.line-1, $PROTOCOL.pos, $endprotocol.line-1, $endprotocol.pos+8, null, children);
		}
			-> ^('Protocol' enprotline* otherbranch?)
	;
enprotline 	returns[RawSegment value]
	:	enlboolcond cl=':' '{' enabledidlist '}' SEMI=';' 
		{	$value = new RawSegment("Item", $enlboolcond.start.getLine()-1, $enlboolcond.start.getCharPositionInLine(), $SEMI.line-1, $SEMI.pos+1, null, null);
		}
			-> ^(PROTLINE[$cl] enlboolcond enabledidlist)
	;
protline 	returns[RawSegment value]
	:	lboolcond cl=':' '{' enabledidlist '}' SEMI=';' 
		{	$value = new RawSegment("Item", $lboolcond.start.getLine()-1, $lboolcond.start.getCharPositionInLine(), $SEMI.line-1, $SEMI.pos+1, null, null);
		}
			-> ^(PROTLINE[$cl] lboolcond enabledidlist)
	;
enabledidlist 	
	:	id1=ID (',' ID)*
			-> ^(ACTIONLIST[$id1] ID+)
	;
otherbranch 	returns[RawSegment value]
	:	OTHER='Other' ':' '{' enabledidlist '}' SEMI=';'
		{	$value = new RawSegment("Item", $OTHER.line-1, $OTHER.pos, $SEMI.line-1, $SEMI.pos+8, null, null);
		}
			-> ^(PROTLINE[$OTHER] 'Other' enabledidlist)
	;
envevolution	returns[RawSegment value]
@init {ArrayList<RawSegment> children = new ArrayList<RawSegment>();}
	:	EVOLUTION='Evolution' ':' 
		(envevline {children.add($envevline.value);})* 
		'end' endevolution='Evolution'
		{	$value = new RawSegment("Evolution", $EVOLUTION.line-1, $EVOLUTION.pos, $endevolution.line-1, $endevolution.pos+9, null, children);
		}
			-> ^('Evolution' envevline*)
	;
envevline 	returns[RawSegment value]
	:	boolresult if1='if' eboolcond SEMI=';'
		{	$value = new RawSegment("Item", $boolresult.start.getLine()-1, $boolresult.start.getCharPositionInLine(), $SEMI.line-1, $SEMI.pos+1, null, null);
		}
			-> ^(ENVEVLINE[$if1] boolresult eboolcond)
	;
boolresult 	
	:	sboolresult ('and'^ sboolresult)*
	;
sboolresult	
	:	'(' boolresult ')' 
			-> boolresult
	|	id=ID '=' expr4
			-> ^(ASSIGNMENT[$id] ID expr4)
	;
eboolcond 	
	: 	eboolcond1 ('or'^ eboolcond1)*
	;
eboolcond1	
	:	eboolcond2 ('and'^ eboolcond2)*
	;
eboolcond2	
	:	'!' eboolcond3
			-> ^('!' eboolcond3)
	|	eboolcond3
	;
eboolcond3
options {memoize=true;}
	:	'(' eboolcond ')'
			-> eboolcond
	|	e1=expr4 op=logicop e2=expr4
			-> ^($op $e1 $e2)
	|	'Action' '=' ID 
			-> ^('Action' ID)
	|	id1=ID '.' 'Action' '=' id2=ID
			-> ^('Action' $id1 $id2)
	
	;
protocol	returns[RawSegment value]
@init {ArrayList<RawSegment> children = new ArrayList<RawSegment>();}
	:	PROTOCOL='Protocol' ':' 
		(protline {children.add($protline.value);})+ 
		(otherbranch {children.add($otherbranch.value);})? 
		'end' endprotocol='Protocol'
		{	$value = new RawSegment("Protocol", $PROTOCOL.line-1, $PROTOCOL.pos, $endprotocol.line-1, $endprotocol.pos+8, null, children);
		}
			-> ^('Protocol' protline+ otherbranch?)
	|	PROTOCOL='Protocol' ':' 
		otherbranch {children.add($otherbranch.value);}
		'end' endprotocol='Protocol'
		{	$value = new RawSegment("Protocol", $PROTOCOL.line-1, $PROTOCOL.pos, $endprotocol.line-1, $endprotocol.pos+8, null, children);
		}
			-> ^('Protocol' otherbranch)
	;

evolution	returns[RawSegment value]
@init {ArrayList<RawSegment> children = new ArrayList<RawSegment>();}
	:	EVOLUTION='Evolution' ':' 
		(evline {children.add($evline.value);})+ 
		'end' endevolution='Evolution'
		{	$value = new RawSegment("Evolution", $EVOLUTION.line-1, $EVOLUTION.pos, $endevolution.line-1, $endevolution.pos+9, null, children);
		}
			-> ^('Evolution' evline+)
	;

evline		returns[RawSegment value]
	: 	boolresult1 if1='if' gboolcond SEMI=';'
		{	$value = new RawSegment("Item", $boolresult1.start.getLine()-1, $boolresult1.start.getCharPositionInLine(), $SEMI.line-1, $SEMI.pos+1, null, null);
		}
			-> ^(EVLINE[$if1] boolresult1 gboolcond)
	;

gboolcond 	
	: 	gboolcond1 ('or'^ gboolcond1)*
	;
gboolcond1	
	:	gboolcond2 ('and'^ gboolcond2)*
	;

gboolcond2	
options {memoize=true;}
	:	'!' gboolcond3 
			-> ^('!' gboolcond3)
	|	gboolcond3
	;
gboolcond3
	:	'(' gboolcond ')' 
			-> gboolcond
	|	e1=expr5 op=logicop e2=expr5
			-> ^($op $e1 $e2)
	|	'Action' '=' ID 
			-> ^('Action' ID)
	|	id1=ID '.' 'Action' '=' id2=ID 
			-> ^('Action' $id1 $id2)
	|	'Environment' '.' 'Action' '=' ID 
			-> ^('Action' 'Environment' ID)
	;
boolresult1 	
	:	sboolresult1 ('and'^ sboolresult1)*
	;
sboolresult1	
	:	'(' boolresult1 ')'
			-> boolresult1
	|	id=ID '=' expr5
			-> ^(ASSIGNMENT[$id] ID expr5)
	;
expr2 	:	term2 ('+'^ term2|'-'^ term2)*
	;
term2 	: 	element2 ('*'^ element2|'/'^ element2)*
	;
element2	
	:	'(' expr2 ')' 
			-> expr2
	|	varvalue2 
	;
varvalue2 	
	:	boolvalue
	|	ID
	|	ENVIRONMENT='Environment' '.' ID 
			-> ^(GLOBALVAR[$ENVIRONMENT] 'Environment' ID)
	|	integer
	;
expr5 	:	term5 ('|'^ term5 |'^'^ term5)*
	;
term5 	: 	factor5 ('&'^ factor5)*
	;
factor5	: 	('~'^)? element5
	;
element5	
	:	'(' expr5 ')'
			-> expr5
	|	expr2
	;
	
evaluation 	returns[RawSegment value]
@init {ArrayList<RawSegment> children = new ArrayList<RawSegment>();}
@after {
	if($value == null)
		$value = new RawSegment("Evaluation", $EVALUATION.line-1, $EVALUATION.pos, $endevaluation.line-1, $endevaluation.pos+10, null, children);
}
	:	EVALUATION='Evaluation'	
		(id=ID 'if' evaboolcond SEMI=';' 
		{	$value = new RawSegment($ID.text, $ID.line-1, $ID.pos, $SEMI.line-1, $SEMI.pos+1, null, null);
		})+ 
		'end' endevaluation='Evaluation'
		{	$value = new RawSegment("Evaluation", $EVALUATION.line-1, $EVALUATION.pos, $endevaluation.line-1, $endevaluation.pos+10, null, children);
		}
			-> ^('Evaluation' (^(ATOMICPROPOSITION[$id] ID evaboolcond))+)
	;
evaboolcond 	
	:	evaboolcond1 ('or'^ evaboolcond1)*
	;
evaboolcond1	
	:	evaboolcond2 ('and'^ evaboolcond2)*
	;
evaboolcond2	
	:	'!' evaboolcond3 
			-> ^('!' evaboolcond3)
	|	evaboolcond3
	;
evaboolcond3
options {memoize=true;}
	:	'(' evaboolcond ')'
			-> evaboolcond
	|	e1=expr6 op=logicop e2=expr6
			-> ^($op $e1 $e2)
	;

expr3 	:	term3 ('+'^ term3 | '-'^ term3 )*
	;
term3 	
	: 	element3 ('*'^ element3 | '/'^ element3)*
	;
element3	
	:	'(' expr3 ')' 
			-> expr3
	|	varvalue3
	;
varvalue3 	
	:	boolvalue
	|	ID
	|	id1=ID '.' id2=ID 
			-> ^(GLOBALVAR[$id1] $id1 $id2)
	|	ENVIRONMENT='Environment' '.' ID 
			-> ^(GLOBALVAR[$ENVIRONMENT] 'Environment' ID)
	|	integer
	;
	
expr6 	:	term6 ('|'^ term6 |'^'^ term6)*
	;
term6 	: 	factor6 ('&'^ factor6)*
	;
factor6	: 	('~'^)? element6
	;
element6	
	:	'(' expr6 ')'
			-> expr6
	|	expr3
	;
	
initstates 	returns[RawSegment value]
@after {
	if($value == null)
		$value = new RawSegment("InitStates", $INITSTATES.line-1, $INITSTATES.pos, $endinitstates.line-1, $endinitstates.pos+10, null, null);
}
	: 	INITSTATES='InitStates' isboolcond ';' 'end' endinitstates='InitStates' 
		{	$value = new RawSegment("InitStates", $INITSTATES.line-1, $INITSTATES.pos, $endinitstates.line-1, $endinitstates.pos+10, null, null);
		}
			-> ^('InitStates' isboolcond)
	;
isboolcond 	
	:	isboolcond1 ('or'^ isboolcond1)*
	;
isboolcond1		
	:	isboolcond2 ('and'^ isboolcond2 )*
	;
isboolcond2	
	:	'!' isboolcond3
			-> ^('!' isboolcond3)
	|	isboolcond3
	;
isboolcond3
//options {memoize=true;}
	:
	|	'(' isboolcond ')'
			-> isboolcond
	|	id1=ID '.' id2=ID '=' varvalue4 
			-> ^(ASSIGNMENT[$id1] ^(GLOBALVAR[$id1] $id1 $id2) varvalue4)
	|	ENVIRONMENT='Environment' '.' ID '=' varvalue4 
			-> ^(ASSIGNMENT[$ENVIRONMENT] ^(GLOBALVAR[$ENVIRONMENT] 'Environment' ID) varvalue4)
	;
varvalue4 	
	:	boolvalue
	|	ID 
	|	integer
	
	|	id1=ID '.' id2=ID
			->^(GLOBALVAR[$id1] $id1 $id2)
	|	id1='Environment' '.' id2=ID 
			->^(GLOBALVAR[$id1] 'Environment' $id2)
	;

groups 		returns[RawSegment value]
@init {ArrayList<RawSegment> children = new ArrayList<RawSegment>();}
@after {
	if($value == null)
		$value = new RawSegment("Groups", $GROUPS.line-1, $GROUPS.pos, $endgroups.line-1, $endgroups.pos+6, null, children);
}
	:	GROUPS='Groups' 
		(id=ID '=' '{' namelist '}' SEMI=';' 
		{	$value = new RawSegment($ID.text, $ID.line-1, $ID.pos, $SEMI.line-1, $SEMI.pos+1, null, null);
		})* 
		'end' endgroups='Groups'
		{	$value = new RawSegment("Groups", $GROUPS.line-1, $GROUPS.pos, $endgroups.line-1, $endgroups.pos+6, null, children);
		}
			-> ^($GROUPS (^(GROUP[$id] ID namelist))*)
	;
namelist 	
	:	agentname (',' agentname)* 
			-> ^(AGENTLIST agentname+)
	;
agentname 	
	:	'Environment' 
	|	ID 
	;
fairness 	returns[RawSegment value]
@init {ArrayList<RawSegment> children = new ArrayList<RawSegment>();}
@after {
	if($value == null)
		$value = new RawSegment("Fairness", $FAIRNESS.line-1, $FAIRNESS.pos, $endfairness.line-1, $endfairness.pos+8, null, children);
}
	:	FAIRNESS='Fairness' 
		/*(fformula SEMI=';'
		{	$value = new RawSegment("fairness formula", $fformula.start.getLine()-1, $fformula.start.getCharPositionInLine(), $SEMI.line-1, $SEMI.pos+1, null, null);
		})* 
		'end' endfairness='Fairness'
		{	$value = new RawSegment("Fairness", $FAIRNESS.line-1, $FAIRNESS.pos, $endfairness.line-1, $endfairness.pos+8, null, children);
		}
			-> ^('Fairness' fformula*) */
		/* allow all kinds of temporal epistemic logic formulae */
		(fformula SEMI=';'
		{	$value = new RawSegment("fairness formula", $fformula.start.getLine()-1, $fformula.start.getCharPositionInLine(), $SEMI.line-1, $SEMI.pos+1, null, null);
		})* 
		'end' endfairness='Fairness'
		{	$value = new RawSegment("Fairness", $FAIRNESS.line-1, $FAIRNESS.pos, $endfairness.line-1, $endfairness.pos+8, null, children);
		}
			-> ^('Fairness' fformula*) 
	;
fformula 	
	:	fformula1 ('or'^ fformula1)*
	;
fformula1 	
	:	fformula2 ('->'^ fformula2)?
	;	
fformula2	
	:	fformula3 ('and'^ fformula3)*
	;
fformula3	
	:	'!' fformula4
			-> ^('!' fformula4)
	|	fformula4
	;
fformula4
	:	'(' fformula ')'
			-> fformula
	|	ID
	|	ID '.'^ 'GreenStates'
	|	ID '.'^ 'RedStates'
	|	'Environment' '.'^ 'GreenStates'
	|	'Environment' '.'^ 'RedStates'
	|	'AG'^ fformula 
	|	'EG'^ fformula 
	|	'AX'^ fformula 
	|	'EX'^ fformula 
	|	'AF'^ fformula 
	|	'EF'^ fformula 
	|	a='A' '(' f1=fformula 'U' f2=fformula ')' 
			-> ^(AU[$a] $f1 $f2)
	|	a='E' '(' f1=fformula 'U' f2=fformula ')' 
			-> ^(EU[$a] $f1 $f2)
	|	'K'^ '('! ID ','! fformula ')'! 
	|	'K'^ '('! 'Environment' ','! fformula ')'! 
	|	'GK'^ '('! ID ','! fformula ')'! 
	|	'GCK'^ '('! ID ','! fformula ')'! 
	|	'O'^ '('! ID ','! fformula ')'! 
	|	'O'^ '('! 'Environment' ','! fformula ')'! 
	|	'DK'^ '('! ID ','! fformula ')'!
	;
formulae 	returns[RawSegment value]
@init {ArrayList<RawSegment> children = new ArrayList<RawSegment>();}
@after {
	if($value == null)
		$value = new RawSegment("Formulae", $FORMULAE.line-1, $FORMULAE.pos, $endformulae.line-1, $endformulae.pos+8, null, children);
}
	:	FORMULAE='Formulae' 
		(formula  SEMI=';'
		{	$value = new RawSegment("formula", $formula.start.getLine()-1, $formula.start.getCharPositionInLine(), $SEMI.line-1, $SEMI.pos+1, null, null);
		})+ 
		'end' endformulae='Formulae'
		{	$value = new RawSegment("Formulae", $FORMULAE.line-1, $FORMULAE.pos, $endformulae.line-1, $endformulae.pos+8, null, children);
		}
			-> ^('Formulae' formula+)
	;
formula	
	:	formula1 ('or'^ formula1)*
	;
formula1 	
	:	formula2 ('->'^ formula2)?
	;	
formula2	
	:	formula3 ('and'^ formula3)*
	;
formula3	
	:	'!'^ formula4
	|	 formula4
	;
formula4
	:	'(' formula ')' 
			-> formula
	|	ID 
	|	ID '.'^ 'GreenStates'
	|	ID '.'^ 'RedStates'
	|	'Environment' '.'^ 'GreenStates'
	|	'Environment' '.'^ 'RedStates'
	|	'AG'^ formula 
	|	'EG'^ formula 
	|	'AX'^ formula 
	|	'EX'^ formula 
	|	'AF'^ formula 
	|	'EF'^ formula 
	|	a='A' '(' f1=formula 'U' f2=formula ')' 
			-> ^(AU[$a] $f1 $f2)
	|	a='E' '(' f1=formula 'U' f2=formula ')' 
			-> ^(EU[$a] $f1 $f2)
	|	'K'^ '('! ID ','! formula ')'! 
	|	'K'^ '('! 'Environment' ','! formula ')'! 
	|	'GK'^ '('! ID ','! formula ')'! 
	|	'GCK'^ '('! ID ','! formula ')'! 
	|	'O'^ '('! ID ','! formula ')'! 
	|	'O'^ '('! 'Environment' ','! formula ')'! 
	|	'DK'^ '('! ID ','! formula ')'!
	|	'<'! ID '>'! 'X'^ formula
	|	'<'! ID '>'! 'F'^ formula
	|	'<'! ID '>'! 'G'^ formula
	|	'<'! ID '>'! '('! f1=formula 'U'^ f2=formula ')'!
	;
integer	
	:	n=NUM 
			-> ^(POSITIVE[$n] NUM)
	|	m='-' NUM
			-> ^('-' NUM)
	;
ID	:	('a'..'z'|'A'..'Z')('a'..'z'|'A'..'Z'|'0'..'9'|'_')*
	;
NUM	:	'0'..'9'+ 
	;	
LINE_COMMENT
    : '--' ~('\n'|'\r')* '\r'? '\n' {skip();/* $channel=HIDDEN;*/}
    ;
WS  :   (' '|'\t'|'\r'| '\n')+ {skip();}
    ;
    
