tree grammar ISPLTREE;

options {
	tokenVocab=ISPL;
	ASTLabelType=CommonTree;
}

@header {
package org.mcmas.ui.syntax;

import java.util.Hashtable;
import java.util.TreeSet;
import java.util.ArrayList;
import org.mcmas.ui.editors.MCMASEditor;
}

@members {
private MCMASEditor editor;
public void setMCMASEditor(MCMASEditor editor) {
	this.editor = editor;
}
}

is 	
@init {
	basic_agent env = new basic_agent("Environment", null, new Hashtable<String, basictype>(), 
					new Hashtable<String, basictype>(), null, 
					new TreeSet<String>(), new ArrayList<protocol_line>(), 
					new ArrayList<evolution_line>()); 
	Hashtable<String, basic_agent> is_agents = new Hashtable<String, basic_agent>();
	ArrayList<basic_agent> agents = new ArrayList<basic_agent>();
	agents.add(env); 
	is_agents.put("Environment", env);
	Hashtable<String, bool_expression> is_evaluation = null;
	bool_expression is_istates = null;
	Hashtable<String, TreeSet<groupitem>> is_groups = new Hashtable<String, TreeSet<groupitem>>(0);
	ArrayList<modal_formula> is_formulae = null;
	ArrayList<fairness_expression> is_fairness = new ArrayList<fairness_expression>(0);
}
@after {
	editor.is = new InterpretedSystem(is_agents, agents, is_evaluation, is_istates, is_groups, is_formulae, is_fairness);
}
:	^(IS 	semantics ? 
		(environment 
		{	if(agents.get(0).get_name().compareTo("Environment")==0)
				agents.remove(0);
			agents.add($environment.value); 
			is_agents.remove("Environment");
		 	is_agents.put("Environment", $environment.value);
		})? 
		(agent 
		{	agents.add($agent.value); 
			is_agents.put($agent.value.get_name(), $agent.value);
		})+ 
		evaluation 
		{	is_evaluation = $evaluation.value;
		}
		initstates 
		{	is_istates = $initstates.value;
		}
		(groups 
		{	is_groups = $groups.value;
		})?
		(fairness 
		{	is_fairness = $fairness.value;
		})?
		formulae
		{	is_formulae = $formulae.value;
		})
	;

semantics
	:	^(SEMANTICS MULTIASSIGNMENT) {
		editor.semantics = 0;
	}
	|	^(SEMANTICS SINGLEASSIGNMENT) {
		editor.semantics = 1;
	}
	;

environment 	returns[basic_agent value]
@init {	bool_expression red = null;
	Hashtable<String, basictype> ovar = new Hashtable<String, basictype>();
	Hashtable<String, basictype> var = new Hashtable<String, basictype>();}
	:	^('Agent' 'Environment' (obsvars {ovar = $obsvars.value;})? 
			(envvars {var = $envvars.value;})? 
			(enredstates {red = $enredstates.value;})? 
			envactions envprotocol envevolution)
		{	$value = new basic_agent("Environment", null, ovar, var, red, 
						 $envactions.value, $envprotocol.value, 
						 $envevolution.value);}
	/*|	^('Agent' 'Environment' obsvars envvars  envactions envprotocol envevolution)
		{	$value = new basic_agent("Environment", $obsvars.value, 
						 $envvars.value, null, 
						 $envactions.value, $envprotocol.value, 
						 $envevolution.value);}*/
	;

agent		returns[basic_agent value]
@init { bool_expression red = null;
	Hashtable<String, variable> lovar = null;}
	:	^('Agent' ID (lobsvars {lovar = $lobsvars.value;})? vars (redstates {red = $redstates.value;})? actions protocol evolution)
		{	$value = new basic_agent($ID.text, lovar, null, $vars.value, 
						 red, $actions.value, 
						 $protocol.value, $evolution.value);}
	/*|	^('Agent' ID vars actions protocol evolution)
		{	$value = new basic_agent($ID.text, null, $vars.value, 
						 null, $actions.value, 
						 $protocol.value, $evolution.value);}*/
	;

obsvars		returns[Hashtable<String,basictype> value]
@init {$value = new Hashtable<String, basictype>();}
	:	^('Obsvars' 
		(var
		{	$value.put($var.value.get_name(), $var.value);
		})*)
	;
envvars		returns[Hashtable<String,basictype> value]
@init {$value = new Hashtable<String, basictype>();}
	:	^('Vars' 
		(var 
		{	$value.put($var.value.get_name(), $var.value);
		})*)
	;
vars		returns[Hashtable<String,basictype> value]
@init {$value = new Hashtable<String, basictype>();}
	:	^('Vars' 
		(var
		{	$value.put($var.value.get_name(), $var.value);
		})+)
	;
var		returns[basictype value]
	:	^(VARDEF ID BOOLEAN)
		{	$value = new basictype($ID.text, $ID.line, $ID.pos);
		}
	|	^(VARDEF name=ID 
		^(ENUMERATION 
		{	TreeSet<String> enum1 = new TreeSet<String>();
		} 
		(id=ID
		{	enum1.add($id.text);
		})+))
		{	$value = new enumerate($name.text, enum1, $ID.line, $ID.pos);
		}
	|	^(VARDEF ID ^(RANGEDINT lb=integer ub=integer))
		{	$value = new rangedint($ID.text, $lb.value, $ub.value, $ID.line, $ID.pos);
		}
	;
lobsvars	returns[Hashtable<String,variable> value]
@init {$value = new Hashtable<String,variable>();}
	:	^('Lobsvars' 
		(ID
		{	variable v = new variable($ID.text, $ID.line, $ID.pos);
			$value.put($ID.text, v);
		})*)
	;
envactions	returns[TreeSet<String> value]
@init {$value = new TreeSet<String>();}
	:	^('Actions' 
		(ID
		{	$value.add($ID.text);
		})*)
	;
actions		returns[TreeSet<String> value]
@init {$value = new TreeSet<String>();}
	:	^('Actions' 
		(ID
		{	$value.add($ID.text);
		})+)
	;
enredstates 	returns[bool_expression value]
	:	^('RedStates' 
		(enlboolcond
		{	$value = $enlboolcond.value;
		})?)
	;
redstates 	returns[bool_expression value]
	:	^('RedStates' 
		(lboolcond
		{	$value = $lboolcond.value;
		})?)
	;
enlboolcond	returns[bool_expression value]
	:	^(lop='or' c1=enlboolcond c2=enlboolcond)
		{	$value = new bool_expression(2, $c1.value, $c2.value, $lop.line, $lop.pos, $lop.line, $lop.pos+2);
		}
	| 	^(lop='and' c1=enlboolcond c2=enlboolcond)
		{	$value = new bool_expression(1, $c1.value, $c2.value, $lop.line, $lop.pos, $lop.line, $lop.pos+3);
		}
	|	^(lop='!' c1=enlboolcond)
		{	$value = new bool_expression(3, $c1.value, $lop.line, $lop.pos, $lop.line, $lop.pos+1);
		}
	/*|	^(op=logicop e1=expr1 e2=expr1)
		{	$value = new bool_expression(0,  new logic_expression($op.value, $e1.value, $e2.value, $op.start.getLine(), 
				$op.start.getCharPositionInLine(), $op.start.getText().length()), 0, 0, 0, 0);
		}*/
	|	^(op=logicop e1=expr4 e2=expr4)
		{	$value = new bool_expression(0,  new logic_expression($op.value, $e1.value, $e2.value, $op.start.getLine(), 
				$op.start.getCharPositionInLine(), $op.start.getText().length()), 0, 0, 0, 0);
		}
	;
lboolcond	returns[bool_expression value]
	:	^(lop='or' c1=lboolcond c2=lboolcond)
		{	$value = new bool_expression(2, $c1.value, $c2.value, $lop.line, $lop.pos, $lop.line, $lop.pos+2);
		}
	| 	^(lop='and' c1=lboolcond c2=lboolcond)
		{	$value = new bool_expression(1, $c1.value, $c2.value, $lop.line, $lop.pos, $lop.line, $lop.pos+3);
		}
	|	^(lop='!' c1=lboolcond)
		{	$value = new bool_expression(3, $c1.value, $lop.line, $lop.pos, $lop.line, $lop.pos+1);
		}
	/*|	^(op=logicop e1=expr2 e2=expr2)
		{	$value = new bool_expression(0,  new logic_expression($op.value, $e1.value, $e2.value, $op.start.getLine(), 
				$op.start.getCharPositionInLine(), $op.start.getText().length()), 0, 0, 0, 0);
		}*/
	|	^(op=logicop e1=expr5 e2=expr5)
		{	$value = new bool_expression(0,  new logic_expression($op.value, $e1.value, $e2.value, $op.start.getLine(), 
				$op.start.getCharPositionInLine(), $op.start.getText().length()), 0, 0, 0, 0);
		}
	;
expr1 		returns[expression value, int endline, int endcolumn]
	:	^('+' e1=expr1 e2=expr1)
		{	$value = new arithmetic_expression(5, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('-' e1=expr1 e2=expr1)
		{	$value = new arithmetic_expression(6, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('*' e1=expr1 e2=expr1)
		{	$value = new arithmetic_expression(7, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('/' e1=expr1 e2=expr1)
		{	$value = new arithmetic_expression(8, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	varvalue1
		{	$value = $varvalue1.value;
			$endline = $varvalue1.endline; $endcolumn = $varvalue1.endcolumn;
		}
	;
logicop 	returns[int value]
	:	'<'	{$value = 2;}
	|	'<='	{$value = 3;}
	|	'>'	{$value = 4;}
	|	'>='	{$value = 5;}
	|	'='	{$value = 0;}
	|	'<>'	{$value = 1;}
	;	
varvalue1 	returns[expression value, int endline, int endcolumn]
	:	boolvalue	
		{	$value = $boolvalue.value;
			$endline = $boolvalue.endline; $endcolumn = $boolvalue.endcolumn;
		}
	|	ID 		
		{	$value = new variable($ID.text, $ID.line, $ID.pos);
			$endline = $ID.line; $endcolumn = $ID.pos + $ID.text.length();
		}
	|	integer		
		{	$value = new int_value($integer.value, $integer.line, $integer.pos, $integer.endline, $integer.endcolumn);
			$endline = $integer.endline; $endcolumn = $integer.endcolumn;
		}
	;
	
expr4 		returns[expression value, int endline, int endcolumn]
	:	^('|' e1=expr4 e2=expr4)
		{	$value = new bit_expression(10, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('^' e1=expr4 e2=expr4)
		{	$value = new bit_expression(12, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('&' e1=expr4 e2=expr4)
		{	$value = new bit_expression(9, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('~' e1=expr4)
		{	$value = new bit_expression(11, $e1.value, null, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e1.endline, $e1.endcolumn);
			$endline = $e1.endline; $endcolumn = $e1.endcolumn;
		} 
	|	expr1
		{	$value = $expr1.value;
			$endline = $expr1.endline; $endcolumn = $expr1.endcolumn;
		}
	/*|	varvalue5
		{	$value = $varvalue5.value;
			$endline = $varvalue5.endline; $endcolumn = $varvalue5.endcolumn;
		}*/
	;
/*varvalue5 	returns[expression value, int endline, int endcolumn]
	:	boolvalue	
		{	$value = $boolvalue.value;
			$endline = $boolvalue.endline; $endcolumn = $boolvalue.endcolumn;
		}
	|	ID 		
		{	$value = new variable($ID.text, $ID.line, $ID.pos);
			$endline = $ID.line; $endcolumn = $ID.pos + $ID.text.length();
		}
	;*/
		
boolvalue	returns[expression value, int endline, int endcolumn]
	:	t='true'		
		{	$value = new bool_value(true, $t.line, $t.pos);
			$endline = $t.line; $endcolumn = $t.pos + 4;
		}
	|	t='false'		
		{	$value = new bool_value(false, $t.line, $t.pos);
			$endline = $t.line; $endcolumn = $t.pos + 5;
		}
	;
envprotocol	returns[ArrayList<protocol_line> value]
@init {$value = new ArrayList<protocol_line>();}
	: 	^('Protocol' 
		(enprotline
		{	$value.add($enprotline.value);	
		})* 
		(otherbranch
		{	$value.add($otherbranch.value);
		})?)
	;
enprotline 	returns[protocol_line value]
	:	^(PROTLINE enlboolcond enabledidlist)
		{	$value = new protocol_line($enlboolcond.value, $enabledidlist.value);
		}
	;
protline 	returns[protocol_line value]
	:	^(PROTLINE lboolcond enabledidlist)
		{	$value = new protocol_line($lboolcond.value, $enabledidlist.value);
		}
	;
enabledidlist 	returns[TreeSet<groupitem> value]
@init {$value = new TreeSet<groupitem>();}
	:	^(ACTIONLIST 
		(ID
		{	$value.add(new groupitem($ID.text, $ID.line, $ID.pos));
		})+)
	;
otherbranch 	returns[protocol_line value]
	:	^(PROTLINE op='Other' enabledidlist)
		{	$value = new protocol_line(new bool_expression(0, 0, 0, 0), $enabledidlist.value);
		}
	;
envevolution	returns[ArrayList<evolution_line> value]
@init {$value = new ArrayList<evolution_line>();}
	:	^('Evolution' 
		(envevline
		{	$value.add($envevline.value);
		})*)
	;
envevline 	returns[evolution_line value]
	:	^(ENVEVLINE boolresult eboolcond)
		{	$value = new evolution_line($boolresult.value, $eboolcond.value);
		}
	;
boolresult 	returns[ArrayList<assignment> value]
@init {$value = new ArrayList<assignment>();}
	:	^('and' r1=boolresult r2=boolresult)
		{	$value.addAll($r1.value);
			$value.addAll($r2.value);
		}
	/*|	^(ASSIGNMENT ID expr1)
		{	$value.add(new assignment($ID.text, $ID.line, $ID.pos, $expr1.value));
		}*/
	|	^(ASSIGNMENT ID expr4)
		{	$value.add(new assignment($ID.text, $ID.line, $ID.pos, $expr4.value));
		}
	;
eboolcond 	returns[bool_expression value]
	: 	^(lop='or' c1=eboolcond c2=eboolcond)
		{	$value = new bool_expression(2, $c1.value, $c2.value, $lop.line, $lop.pos, $lop.line, $lop.pos+2);
		}
	|	^(lop='and' c1=eboolcond c2=eboolcond)
		{	$value = new bool_expression(1, $c1.value, $c2.value, $lop.line, $lop.pos, $lop.line, $lop.pos+3);
		}
	|	^(lop='!' c1=eboolcond)
		{	$value = new bool_expression(3, $c1.value, $lop.line, $lop.pos, $lop.line, $lop.pos+1);
		}
	/*|	^(op=logicop e1=expr1 e2=expr1)
		{	$value = new bool_expression(0, new logic_expression($op.value, $e1.value, $e2.value, $op.start.getLine(), 
				$op.start.getCharPositionInLine(), $op.start.getText().length()), 0, 0, 0, 0);
		}*/
	|	^(op=logicop e1=expr4 e2=expr4)
		{	$value = new bool_expression(0, new logic_expression($op.value, $e1.value, $e2.value, $op.start.getLine(), 
				$op.start.getCharPositionInLine(), $op.start.getText().length()), 0, 0, 0, 0);
		}
	|	^(a='Action' ID)
		{	$value = new bool_expression(0, new logic_expression(0, new laction($a.line, $a.pos), new variable($ID.text, $ID.line, $ID.pos)), 0, 0, 0, 0);
		}
	|	^(a='Action' id1=ID id2=ID)
		{	$value = new bool_expression(0, new logic_expression(0, new laction($id1.text, $id1.line, $id1.pos, $a.line, $a.pos), 
			new variable($id2.text, $id2.line, $id2.pos)), 0, 0, 0, 0);
		}
	;
protocol	returns[ArrayList<protocol_line> value]
@init {$value = new ArrayList<protocol_line>();}
	:	^('Protocol' 
		(protline
		{	$value.add($protline.value);	
		})+ 
		(otherbranch
		{	$value.add($otherbranch.value);
		})?)
	|	^('Protocol' otherbranch)
		{	$value.add($otherbranch.value);
		}
	;

evolution	returns[ArrayList<evolution_line> value]
@init {$value = new ArrayList<evolution_line>();}
	:	^('Evolution' 
		(evline
		{	$value.add($evline.value);
		})+)
	;

evline		returns[evolution_line value]
	: 	^(EVLINE boolresult1 gboolcond)
		{	$value = new evolution_line($boolresult1.value, $gboolcond.value);
		}
	;

gboolcond 	returns[bool_expression value]
	: 	^(lop='or' c1=gboolcond c2=gboolcond)
		{	$value = new bool_expression(2, $c1.value, $c2.value, $lop.line, $lop.pos, $lop.line, $lop.pos+2);
		}
	|	^(lop='and' c1=gboolcond c2=gboolcond)
		{	$value = new bool_expression(1, $c1.value, $c2.value, $lop.line, $lop.pos, $lop.line, $lop.pos+3);
		}
	|	^(lop='!' c1=gboolcond)
		{	$value = new bool_expression(3, $c1.value, $lop.line, $lop.pos, $lop.line, $lop.pos+1);
		}
	/*|	^(op=logicop e1=expr2 e2=expr2)
		{	$value = new bool_expression(0, new logic_expression($op.value, $e1.value, $e2.value, $op.start.getLine(), 
				$op.start.getCharPositionInLine(), $op.start.getText().length()), 0, 0, 0, 0);
		}*/
	|	^(op=logicop e1=expr5 e2=expr5)
		{	$value = new bool_expression(0, new logic_expression($op.value, $e1.value, $e2.value, $op.start.getLine(), 
				$op.start.getCharPositionInLine(), $op.start.getText().length()), 0, 0, 0, 0);
		}
	|	^(a='Action' ID)
		{	$value = new bool_expression(0, new logic_expression(0, new laction($a.line, $a.pos), new variable($ID.text, $ID.line, $ID.pos)), 0, 0, 0, 0);
		}
	|	^(a='Action' id1=ID id2=ID)
		{	$value = new bool_expression(0, new logic_expression(0, new laction($id1.text, $id1.line, $id1.pos, $a.line, $a.pos), 
			new variable($id2.text, $id2.line, $id2.pos)), 0, 0, 0, 0);
		}
	|	^(a='Action' id1='Environment' id2=ID)
		{	$value = new bool_expression(0, new logic_expression(0, new laction("Environment", $id1.line, $id1.pos, $a.line, $a.pos), 
			new variable($id2.text, $id2.line, $id2.pos)), 0, 0, 0, 0);
		}
	;
boolresult1 	returns[ArrayList<assignment> value]
@init {$value = new ArrayList<assignment>();}
	:	^('and' r1=boolresult1 r2=boolresult1)
		{	$value.addAll($r1.value);
			$value.addAll($r2.value);
		}
	/*|	^(ASSIGNMENT ID expr2)
		{	$value.add(new assignment($ID.text, $ID.line, $ID.pos, $expr2.value));
		}*/
	|	^(ASSIGNMENT ID expr5)
		{	$value.add(new assignment($ID.text, $ID.line, $ID.pos, $expr5.value));
		}
	;
expr2 		returns[expression value, int endline, int endcolumn]
	:	^('+' e1=expr2 e2=expr2)
		{	$value = new arithmetic_expression(5, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('-' e1=expr2 e2=expr2)
		{	$value = new arithmetic_expression(6, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('*' e1=expr2 e2=expr2)
		{	$value = new arithmetic_expression(7, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('/' e1=expr2 e2=expr2)
		{	$value = new arithmetic_expression(8, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	varvalue2 
		{	$value = $varvalue2.value;
			$endline = $varvalue2.endline; $endcolumn = $varvalue2.endcolumn;
		}
	;
varvalue2 	returns[expression value, int endline, int endcolumn]	
	:	boolvalue			
		{	$value = $boolvalue.value;
			$endline = $boolvalue.endline; $endcolumn = $boolvalue.endcolumn;
		}
	|	ID				
		{	$value = new variable($ID.text, $ID.line, $ID.pos);
			$endline = $ID.line; $endcolumn = $ID.pos + $ID.text.length();
		}
	|	^(GLOBALVAR id1='Environment' id2=ID)	
		{	$value = new variable("Environment", $ID.text, $id1.line, $id1.pos, $id2.line, $id2.pos);
			$endline = $ID.line; $endcolumn = $ID.pos + $ID.text.length();
		}
	|	integer				
		{	$value = new int_value($integer.value, $integer.line, $integer.pos, $integer.endline, $integer.endcolumn);
			$endline = $integer.endline; $endcolumn = $integer.endcolumn;
		}
	;
	
expr5 		returns[expression value, int endline, int endcolumn]
	:	^('|' e1=expr5 e2=expr5)
		{	$value = new bit_expression(10, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('^' e1=expr5 e2=expr5)
		{	$value = new bit_expression(12, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('&' e1=expr5 e2=expr5)
		{	$value = new bit_expression(9, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('~' e1=expr5)
		{	$value = new bit_expression(11, $e1.value, null, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e1.endline, $e1.endcolumn);
			$endline = $e1.endline; $endcolumn = $e1.endcolumn;
		} 
	|	expr2
		{	$value = $expr2.value;
			$endline = $expr2.endline; $endcolumn = $expr2.endcolumn;
		}
	/*|	varvalue6
		{	$value = $varvalue6.value;
			$endline = $varvalue6.endline; $endcolumn = $varvalue6.endcolumn;
		}*/
	;
/*varvalue6 	returns[expression value, int endline, int endcolumn]
	:	boolvalue	
		{	$value = $boolvalue.value;
			$endline = $boolvalue.endline; $endcolumn = $boolvalue.endcolumn;
		}
	|	ID 		
		{	$value = new variable($ID.text, $ID.line, $ID.pos);
			$endline = $ID.line; $endcolumn = $ID.pos + $ID.text.length();
		}
	|	^(GLOBALVAR id1='Environment' id2=ID)	
		{	$value = new variable("Environment", $ID.text, $id1.line, $id1.pos, $id2.line, $id2.pos);
			$endline = $ID.line; $endcolumn = $ID.pos + $ID.text.length();
		}
	;*/
	
evaluation 	returns[Hashtable<String, bool_expression> value]
@init {$value = new Hashtable<String, bool_expression>();}
	:	^('Evaluation' 
		(^(ATOMICPROPOSITION ID evaboolcond
		{	{$value.put($ID.text, $evaboolcond.value);}
		}))+)
	;
evaboolcond 	returns[bool_expression value]
	:	^(lop='or' c1=evaboolcond c2=evaboolcond)
		{	$value = new bool_expression(2, $c1.value, $c2.value, $lop.line, $lop.pos, $lop.line, $lop.pos+2);
		}
	|	^(lop='and' c1=evaboolcond c2=evaboolcond)
		{	$value = new bool_expression(1, $c1.value, $c2.value, $lop.line, $lop.pos, $lop.line, $lop.pos+3);
		}
	|	^(lop='!' c1=evaboolcond)
		{	$value = new bool_expression(3, $c1.value, $lop.line, $lop.pos, $lop.line, $lop.pos+1);
		}
	/*|	^(op=logicop e1=expr3 e2=expr3)
		{	$value = new bool_expression(0, new logic_expression($op.value, $e1.value, $e2.value, $op.start.getLine(), 
				$op.start.getCharPositionInLine(), $op.start.getText().length()), 0, 0, 0, 0);
		}*/
	|	^(op=logicop e1=expr6 e2=expr6)
		{	$value = new bool_expression(0, new logic_expression($op.value, $e1.value, $e2.value, $op.start.getLine(), 
				$op.start.getCharPositionInLine(), $op.start.getText().length()), 0, 0, 0, 0);
		}
	;
expr3 		returns[expression value, int endline, int endcolumn]
	:	^('+' e1=expr3 e2=expr3) 
		{	$value = new arithmetic_expression(5, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('-' e1=expr3 e2=expr3)
		{	$value = new arithmetic_expression(6, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('*' e1=expr3 e2=expr3) 
		{	$value = new arithmetic_expression(7, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('/' e1=expr3 e2=expr3)
		{	$value = new arithmetic_expression(8, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	varvalue3
		{	$value = $varvalue3.value;
			$endline = $varvalue3.endline; $endcolumn = $varvalue3.endcolumn;
		}
	;
varvalue3 	returns[expression value, int endline, int endcolumn]
	:	boolvalue			
		{	$value = $boolvalue.value;
		}
	|	ID				
		{	$value = new variable($ID.text, $ID.line, $ID.pos);
			$endline = $ID.line; $endcolumn = $ID.pos + $ID.text.length();
		}
	|	^(GLOBALVAR id1=ID id2=ID)	
		{	$value = new variable($id1.text, $id2.text, $id1.line, $id1.pos, $id2.line, $id2.pos);
			$endline = $id2.line; $endcolumn = $id2.pos + $id2.text.length();
		}
	|	^(GLOBALVAR id1='Environment' id2=ID)	
		{	$value = new variable("Environment", $ID.text, $id1.line, $id1.pos, $id2.line, $id2.pos);
			$endline = $id2.line; $endcolumn = $id2.pos + $id2.text.length();
		}
	|	integer				
		{	$value = new int_value($integer.value, $integer.line, $integer.pos, $integer.endline, $integer.endcolumn);
			$endline = $integer.endline; $endcolumn = $integer.endcolumn;
		}
	;

expr6 		returns[expression value, int endline, int endcolumn]
	:	^('|' e1=expr6 e2=expr6)
		{	$value = new bit_expression(19, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('^' e1=expr6 e2=expr6)
		{	$value = new bit_expression(12, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('&' e1=expr6 e2=expr6)
		{	$value = new bit_expression(9, $e1.value, $e2.value, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e2.endline, $e2.endcolumn);
			$endline = $e2.endline; $endcolumn = $e2.endcolumn;
		} 
	|	^('~' e1=expr6)
		{	$value = new bit_expression(11, $e1.value, null, $e1.start.getLine(), $e1.start.getCharPositionInLine(), 
										    $e1.endline, $e1.endcolumn);
			$endline = $e1.endline; $endcolumn = $e1.endcolumn;
		} 
	|	expr3
		{	$value = $expr3.value;
			$endline = $expr3.endline; $endcolumn = $expr3.endcolumn;
		}
	/*|	varvalue7
		{	$value = $varvalue7.value;
			$endline = $varvalue7.endline; $endcolumn = $varvalue7.endcolumn;
		}*/
	;
/*varvalue7 	returns[expression value, int endline, int endcolumn]
	:	boolvalue	
		{	$value = $boolvalue.value;
			$endline = $boolvalue.endline; $endcolumn = $boolvalue.endcolumn;
		}
	|	ID 		
		{	$value = new variable($ID.text, $ID.line, $ID.pos);
			$endline = $ID.line; $endcolumn = $ID.pos + $ID.text.length();
		}
	|	^(GLOBALVAR id1=ID id2=ID)	
		{	$value = new variable($id1.text, $id2.text, $id1.line, $id1.pos, $id2.line, $id2.pos);
			$endline = $id2.line; $endcolumn = $id2.pos + $id2.text.length();
		}
	|	^(GLOBALVAR id1='Environment' id2=ID)	
		{	$value = new variable("Environment", $ID.text, $id1.line, $id1.pos, $id2.line, $id2.pos);
			$endline = $ID.line; $endcolumn = $ID.pos + $ID.text.length();
		}
	;*/
		
initstates 	returns[bool_expression value]
	: 	^('InitStates' isboolcond)
		{	$value = $isboolcond.value;
		}
	;
isboolcond 	returns[bool_expression value]
	:	^(lop='or' c1=isboolcond c2=isboolcond)
		{	$value = new bool_expression(2, $c1.value, $c2.value, $lop.line, $lop.pos, $lop.line, $lop.pos+2);
		}
	|	^(lop='and' c1=isboolcond c2=isboolcond)
		{	$value = new bool_expression(1, $c1.value, $c2.value, $lop.line, $lop.pos, $lop.line, $lop.pos+3);
		}
	|	^(lop='!' c1=isboolcond)
		{	$value = new bool_expression(3, $c1.value, $lop.line, $lop.pos, $lop.line, $lop.pos+1);
		}
	|	^(ASSIGNMENT ^(GLOBALVAR id1=ID id2=ID) varvalue4)
		{	$value = new bool_expression(0, new logic_expression(0, 
				new variable($id1.text, $id2.text, $id1.line, $id1.pos, $id2.line, $id2.pos), $varvalue4.value), 0, 0, 0, 0);
		}
	|	^(ASSIGNMENT ^(GLOBALVAR id1='Environment' id2=ID) varvalue4)
		{	$value = new bool_expression(0, new logic_expression(0, 
				new variable("Environment", $id2.text, $id1.line, $id1.pos, $id2.line, $id2.pos), $varvalue4.value), 0, 0, 0, 0);
		}

	/*|	^(ASSIGNMENT ^(GLOBALVAR id1=ID id2=ID) (GLOBALVAR id3=ID id4=ID))
		{	$value = new bool_expression(0, new logic_expression(0, 
				new variable($id1.text, $id2.text, $id1.line, $id1.pos, $id2.line, $id2.pos), 
				new variable($id3.text, $id4.text, $id3.line, $id3.pos, $id4.line, $id4.pos)), 0, 0, 0, 0);
		}

	|	^(ASSIGNMENT ^(GLOBALVAR id1='Environment' id2=ID) (GLOBALVAR id3=ID id4=ID))
		{	$value = new bool_expression(0, new logic_expression(0, 
				new variable("Environment", $id2.text, $id1.line, $id1.pos, $id2.line, $id2.pos), 
				new variable($id3.text, $id4.text, $id3.line, $id3.pos, $id4.line, $id4.pos)), 0, 0, 0, 0);
		}

	|	^(ASSIGNMENT ^(GLOBALVAR id1=ID id2=ID) (GLOBALVAR id3='Environment' id4=ID))
		{	$value = new bool_expression(0, new logic_expression(0, 
				new variable($id1.text, $id2.text, $id1.line, $id1.pos, $id2.line, $id2.pos), 
				new variable("Environment", $id4.text, $id3.line, $id3.pos, $id4.line, $id4.pos)), 0, 0, 0, 0);
		}

	|	^(ASSIGNMENT ^(GLOBALVAR id1='Environment' id2=ID) (GLOBALVAR id3='Environment' id4=ID))
		{	$value = new bool_expression(0, new logic_expression(0, 
				new variable("Environment", $id2.text, $id1.line, $id1.pos, $id2.line, $id2.pos), 
				new variable("Environment", $id4.text, $id3.line, $id3.pos, $id4.line, $id4.pos)), 0, 0, 0, 0);
		}*/
	;
varvalue4 	returns[expression value, int endline, int endcolumn]
	:	boolvalue	
		{	$value = $boolvalue.value;
			$endline = $boolvalue.endline; $endcolumn = $boolvalue.endcolumn;
		}
	|	ID 		
		{	$value = new enum_value($ID.text, $ID.line, $ID.pos);
			$endline = $ID.line; $endcolumn = $ID.pos + $ID.text.length();
		}
	|	integer		
		{	$value = new int_value($integer.value, $integer.line, $integer.pos, $integer.endline, $integer.endcolumn);
			$endline = $integer.endline; $endcolumn = $integer.endcolumn;
		}
	|	^(GLOBALVAR id1=ID id2=ID)	
		{	$value = new variable($id1.text, $id2.text, $id1.line, $id1.pos, $id2.line, $id2.pos);
			$endline = $id2.line; $endcolumn = $id2.pos + $id2.text.length();
		}
	|	^(GLOBALVAR id1='Environment' id2=ID)	
		{	$value = new variable("Environment", $ID.text, $id1.line, $id1.pos, $id2.line, $id2.pos);
			$endline = $id2.line; $endcolumn = $id2.pos + $id2.text.length();
		}

	;

groups 		returns[Hashtable<String,TreeSet<groupitem>> value]
@init {$value = new Hashtable<String, TreeSet<groupitem>>();}
	:	^('Groups' 
		(^(GROUP ID namelist
		{	$value.put($ID.text, $namelist.value);
		}))*)
	;
namelist 	returns[TreeSet<groupitem> value]
@init {$value = new TreeSet<groupitem>();}
	:	^(AGENTLIST 
		(agentname
		{	$value.add($agentname.value);
		})+)
	;
agentname 	returns[groupitem value]
	:	id='Environment' 	{$value = new groupitem("Environment", $id.line, $id.pos);}
	|	ID 		 {$value = new groupitem($ID.text, $ID.line, $ID.pos);}
	;
fairness 	returns[ArrayList<fairness_expression> value]
@init {$value = new ArrayList<fairness_expression>();}
	/*:	^('Fairness' fformula*)*/
	/* allow all kinds of temporal epistemic logic formulae */
	:	^('Fairness' 
		(fformula
		{	$value.add($fformula.value);
		})*)
	;
fformula 	returns[fairness_expression value]
	:	^('or' c1=fformula c2=fformula)
		{	$value = new fairness_expression(2, $c1.value, $c2.value);
		}
	|	^('and' c1=fformula c2=fformula)
		{	$value = new fairness_expression(1, $c1.value, $c2.value);
		}
	|	^('->' c1=fformula c2=fformula)
		{	$value = new fairness_expression(4, $c1.value, $c2.value);
		}
	|	^('!' c1=fformula)
		{	$value = new fairness_expression(3, $c1.value);
		}
	|	ID
		{	$value = new fairness_expression(new atomic_proposition($ID.text, $ID.line, $ID.pos));
		}
	|	^('.' ID 'GreenStates')
		{	$value = new fairness_expression(new atomic_proposition($ID.text + ".GreenStates", $ID.line, $ID.pos));
		}
	|	^('.' ID 'RedStates')
		{	$value = new fairness_expression(new atomic_proposition($ID.text + ".RedStates", $ID.line, $ID.pos));
		}
	|	^('.' id='Environment' 'GreenStates')
		{	$value = new fairness_expression(new atomic_proposition("Environment.GreenStates", $id.line, $id.pos));
		}
	|	^('.' id='Environment' 'RedStates')
		{	$value = new fairness_expression(new atomic_proposition("Environment.RedStates", $id.line, $id.pos));
		}
	|	^('AG' c1=fformula)
		{	$value = new fairness_expression(10, $c1.value);
		}
	|	^('EG' c1=fformula)
		{	$value = new fairness_expression(11, $c1.value);
		}
	|	^('AX' c1=fformula)
		{	$value = new fairness_expression(12, $c1.value);
		}
	|	^('EX' c1=fformula) 
		{	$value = new fairness_expression(13, $c1.value);
		}
	|	^('AF' c1=fformula)
		{	$value = new fairness_expression(14, $c1.value);
		}
	|	^('EF' c1=fformula) 
		{	$value = new fairness_expression(15, $c1.value);
		}
	|	^(AU c1=fformula c2=fformula)
		{	$value = new fairness_expression(16, $c1.value, $c2.value);
		}
	|	^(EU c1=fformula c2=fformula)
		{	$value = new fairness_expression(17, $c1.value, $c2.value);
		}
	|	^('K' id1=ID c1=fformula) 
		{	$value = new fairness_expression(30, 
				new fairness_expression(new atomic_proposition($id1.text, $ID.line, $ID.pos)), 
				$c1.value);
		}
	|	^('K' id1='Environment' c1=fformula)
		{	$value = new fairness_expression(30, 
				new fairness_expression(new atomic_proposition("Environment", $id1.line, $id1.pos)), 
				$c1.value);
		}
	|	^('GK' id1=ID c1=fformula) 
		{	$value = new fairness_expression(31, 
				new fairness_expression(new atomic_proposition($id1.text, $id1.line, $id1.pos)), 
				$c1.value);
		}
	|	^('GCK' id1=ID c1=fformula) 
		{	$value = new fairness_expression(32, 
				new fairness_expression(new atomic_proposition($id1.text, $id1.line, $id1.pos)), 
				$c1.value);
		}
	|	^('O' id1=ID c1=fformula)
		{	$value = new fairness_expression(40, 
				new fairness_expression(new atomic_proposition($id1.text, $id1.line, $id1.pos)), 
				$c1.value);
		}
	|	^('O' id1='Environment' c1=fformula)
		{	$value = new fairness_expression(40, 
				new fairness_expression(new atomic_proposition("Environment", $id1.line, $id1.pos)), 
				$c1.value);
		}
	|	^('DK' id1=ID c1=fformula)
		{	$value = new fairness_expression(42, 
				new fairness_expression(new atomic_proposition($id1.text, $id1.line, $id1.pos)), 
				$c1.value);
		}
	;
formulae 	returns[ArrayList<modal_formula> value]
@init {$value = new ArrayList<modal_formula>();}
	:	^('Formulae' 
		(formula
		{	$value.add($formula.value);
		})+)
	;
formula		returns[modal_formula value]
	:	^('or' c1=formula c2=formula)
		{	$value = new modal_formula(2, $c1.value, $c2.value);
		}
	|	^('and' c1=formula c2=formula)
		{	$value = new modal_formula(1, $c1.value, $c2.value);
		}
	|	^('->' c1=formula c2=formula)
		{	$value = new modal_formula(4, $c1.value, $c2.value);
		}
	|	^('!' c1=formula)
		{	$value = new modal_formula(3, $c1.value);
		}
	|	ID 
		{	$value = new modal_formula(new atomic_proposition($ID.text, $ID.line, $ID.pos));
		}
	|	^('.' ID 'GreenStates')
		{	$value = new modal_formula(new atomic_proposition($ID.text + ".GreenStates", $ID.line, $ID.pos));
		}
	|	^('.' ID 'RedStates')
		{	$value = new modal_formula(new atomic_proposition($ID.text + ".RedStates", $ID.line, $ID.pos));
		}
	|	^('.' id='Environment' 'GreenStates')
		{	$value = new modal_formula(new atomic_proposition("Environment.GreenStates", $id.line, $id.pos));
		}
	|	^('.' id='Environment' 'RedStates')
		{	$value = new modal_formula(new atomic_proposition("Environment.RedStates", $id.line, $id.pos));
		}
	|	^('AG' c1=formula)
		{	$value = new modal_formula(10, $c1.value);
		}
	|	^('EG' c1=formula)
		{	$value = new modal_formula(11, $c1.value);
		}
	|	^('AX' c1=formula)
		{	$value = new modal_formula(12, $c1.value);
		}
	|	^('EX' c1=formula) 
		{	$value = new modal_formula(13, $c1.value);
		}
	|	^('AF' c1=formula)
		{	$value = new modal_formula(14, $c1.value);
		}
	|	^('EF' c1=formula) 
		{	$value = new modal_formula(15, $c1.value);
		}
	|	^(AU c1=formula c2=formula)
		{	$value = new modal_formula(16, $c1.value, $c2.value);
		}
	|	^(EU c1=formula c2=formula)
		{	$value = new modal_formula(17, $c1.value, $c2.value);
		}
	|	^('K' id1=ID c1=formula) 
		{	$value = new modal_formula(30, 
				new modal_formula(new atomic_proposition($id1.text, $ID.line, $ID.pos)), 
				$c1.value);
		}
	|	^('K' id1='Environment' c1=formula)
		{	$value = new modal_formula(30, 
				new modal_formula(new atomic_proposition("Environment", $id1.line, $id1.pos)), 
				$c1.value);
		}
	|	^('GK' id1=ID c1=formula) 
		{	$value = new modal_formula(31, 
				new modal_formula(new atomic_proposition($id1.text, $id1.line, $id1.pos)), 
				$c1.value);
		}
	|	^('GCK' id1=ID c1=formula) 
		{	$value = new modal_formula(32, 
				new modal_formula(new atomic_proposition($id1.text, $id1.line, $id1.pos)), 
				$c1.value);
		}
	|	^('O' id1=ID c1=formula)
		{	$value = new modal_formula(40, 
				new modal_formula(new atomic_proposition($id1.text, $id1.line, $id1.pos)), 
				$c1.value);
		}
	|	^('O' id1='Environment' c1=formula)
		{	$value = new modal_formula(40, 
				new modal_formula(new atomic_proposition("Environment", $id1.line, $id1.pos)), 
				$c1.value);
		}
	|	^('DK' id1=ID c1=formula)
		{	$value = new modal_formula(42, 
				new modal_formula(new atomic_proposition($id1.text, $id1.line, $id1.pos)), 
				$c1.value);
		}
	|	^('X' id1=ID c1=formula)
		{	$value = new modal_formula(45, 
				new modal_formula(new atomic_proposition($id1.text, $id1.line, $id1.pos)), 
				$c1.value);
		}
	|	^('F' id1=ID c1=formula)
		{	$value = new modal_formula(46, 
				new modal_formula(new atomic_proposition($id1.text, $id1.line, $id1.pos)), 
				$c1.value);
		}
	|	^('G' id1=ID c1=formula)
		{	$value = new modal_formula(47, 
				new modal_formula(new atomic_proposition($id1.text, $id1.line, $id1.pos)), 
				$c1.value);
		}
	|	^('U' id1=ID c1=formula  c2=formula)
		{	$value = new modal_formula(48, 
				new modal_formula(new atomic_proposition($id1.text, $id1.line, $id1.pos)), 
				$c1.value,
				$c2.value);
		}
	;
integer		returns[int value, int line, int pos, int endline, int endcolumn]
	:	^(POSITIVE NUM)	
		{	$value = Integer.parseInt($NUM.text);
			$line = $NUM.line; $pos = $NUM.pos;
			$endline = $NUM.line; $endcolumn = $NUM.pos + $NUM.text.length();
		}
	|	^(m='-' NUM)	
		{	$value = 0 - Integer.parseInt($NUM.text);
			$line = $m.line; $pos = $m.pos;
			$endline = $NUM.line; $endcolumn = $NUM.pos + $NUM.text.length();
		}
	;
