grammar counterexample;

@header {
package org.mcmas.ui.syntax;
}

@lexer::header {
package org.mcmas.ui.syntax;
}

is 		returns[CounterExample value]
@init {ArrayList<CESystem> states = new ArrayList<CESystem>();}
	:	(state
		{	states.add($state.value);	
		})+
		{	CESystem[] ss = new CESystem[states.size()];
			states.toArray(ss);
			$value = new CounterExample(ss);
		}
	;

state		returns[CESystem value]
@init {ArrayList<CEAgent> agents = new ArrayList<CEAgent>();}
	:	'--' 'State' NUM '--' 
		(agent
		{	agents.add($agent.value);
		})+
		{	CEAgent[] as = new CEAgent[agents.size()];
			agents.toArray(as);
			$value = new CESystem(Integer.parseInt($NUM.text), as);
		}
	;
agent		returns[CEAgent value]
@init {ArrayList<assignment> assignments = new ArrayList<assignment>();}
	:	'Agent' ID 
		(variable 
		{	assignments.add($variable.value); 
		})*
		{	if(assignments.size() == 0) 
				$value = new CEAgent($ID.text, null);
			else {
				assignment[] assigns = new assignment[assignments.size()];
				assignments.toArray(assigns);
				$value = new CEAgent($ID.text, assigns);
			}
		}
	;
variable	returns[assignment value]
	:	ID '=' expr
		{	$value = new assignment($ID.text, 0, 0, $expr.value);
		}
	;
expr		returns[expression value]
	:	'true'
		{	$value = new bool_value(true, 0, 0);
		}
	|	'false'
		{	$value = new bool_value(false, 0, 0);
		}
	|	ID 
		{	$value = new enum_value($ID.text, 0, 0);
		}
	|	integer
		{	$value = new int_value($integer.value, 0, 0, 0, 0);
		}
	;
integer		returns[int value]
	:	NUM 
		{$value = Integer.parseInt($NUM.text);}
	|	'-' NUM
		{$value = 0 - Integer.parseInt($NUM.text);}
	;
ID	:	('a'..'z'|'A'..'Z')('a'..'z'|'A'..'Z'|'0'..'9'|'_')*
	;
NUM	:	'0'..'9'+ 
	;	
WS  :   (' '|'\t'|'\r'| '\n')+ {skip();} ;
