grammar enabledtransitions;

@header {
package org.mcmas.ui.syntax;
}

@lexer::header {
package org.mcmas.ui.syntax;
}

is 		returns[EnabledTransitions value]
@init {ArrayList<Transition> transitions = new ArrayList<Transition>();}
	:	(transition
		{	transitions.add($transition.value);	
		})+
		{	Transition[] ss = new Transition[transitions.size()];
			transitions.toArray(ss);
			$value = new EnabledTransitions(ss);
		}
	;

transition	returns[Transition value]
@init {ArrayList<LocalAction> actions = new ArrayList<LocalAction>();}
	:	'--' 'transition' NUM '--' 
		(agent
		{	actions.add($agent.value);
		})+
		{	LocalAction[] as = new LocalAction[actions.size()];
			actions.toArray(as);
			$value = new Transition(Integer.parseInt($NUM.text), as);
		}
	;
agent		returns[LocalAction value]
	:	n1=ID ':' n2=ID ';'
		{	$value = new LocalAction($n1.text, $n2.text);
		}
	|	n1=ID ':'  ';'
		{	$value = new LocalAction($n1.text);
		}
	;
ID	:	('a'..'z'|'A'..'Z')('a'..'z'|'A'..'Z'|'0'..'9'|'_')*
	;
NUM	:	'0'..'9'+ 
	;	
WS  :   (' '|'\t'|'\r'| '\n')+ {skip();} ;
